/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.object.struct;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.internal.EditorsMessages;
import org.jkiss.dbeaver.ui.editors.object.struct.AttributesSelectorPage;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class EditConstraintPage
extends AttributesSelectorPage {
    private DBSEntityConstraint entityConstraint;
    private String constraintName;
    private DBSEntityConstraintType[] constraintTypes;
    private DBSEntityConstraintType selectedConstraintType;
    private String constraintExpression;
    private DBSEntityReferrer constraint;
    private Collection<? extends DBSEntityAttributeRef> attributes;
    private Map<DBSEntityConstraintType, String> TYPE_PREFIX = new HashMap<DBSEntityConstraintType, String>();
    private Group expressionGroup;
    private Text expressionText;
    private boolean enableConstraint = true;
    private boolean showEnable = false;
    private boolean useAllColumns = false;

    public EditConstraintPage(String title, DBSEntityConstraint constraint, DBSEntityConstraintType[] constraintTypes) {
        super(title, constraint.getParentObject());
        this.entityConstraint = constraint;
        this.constraintTypes = constraintTypes;
        Assert.isTrue((!ArrayUtils.isEmpty((Object[])this.constraintTypes) ? 1 : 0) != 0);
    }

    public EditConstraintPage(String title, DBSEntity entity, DBSEntityConstraintType[] constraintTypes, Boolean showEnable) {
        super(title, entity);
        this.entity = entity;
        this.constraintTypes = constraintTypes;
        this.showEnable = showEnable;
        Assert.isTrue((!ArrayUtils.isEmpty((Object[])this.constraintTypes) ? 1 : 0) != 0);
    }

    public EditConstraintPage(String title, DBSEntityReferrer constraint) {
        super(title, constraint.getParentObject());
        this.constraint = constraint;
        this.constraintTypes = new DBSEntityConstraintType[]{constraint.getConstraintType()};
        try {
            this.attributes = constraint.getAttributeReferences((DBRProgressMonitor)new VoidProgressMonitor());
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Can't get attributes", "Error obtaining entity attributes", (Throwable)e);
        }
        this.constraintName = this.constraint.getName();
        if (constraint instanceof DBVEntityConstraint) {
            this.useAllColumns = ((DBVEntityConstraint)constraint).isUseAllColumns();
        }
    }

    private boolean isUniqueVirtualKeyEdit() {
        return this.constraintTypes.length == 1 && this.constraintTypes[0] == DBSEntityConstraintType.VIRTUAL_KEY;
    }

    private void addTypePrefix(DBSEntityConstraintType type, String prefix) {
        if (this.entity.getDataSource() != null) {
            prefix = this.entity.getDataSource().getSQLDialect().storesUnquotedCase().transform(prefix);
        }
        this.TYPE_PREFIX.put(type, prefix);
    }

    @Override
    protected Composite createPageContents(Composite parent) {
        Composite pageContents = super.createPageContents(parent);
        this.toggleEditAreas();
        return pageContents;
    }

    private void toggleEditAreas() {
        boolean custom = this.selectedConstraintType.isCustom();
        this.columnsGroup.setVisible(!custom);
        ((GridData)this.columnsGroup.getLayoutData()).exclude = custom;
        this.expressionGroup.setVisible(custom);
        ((GridData)this.expressionGroup.getLayoutData()).exclude = !custom;
        this.columnsGroup.getParent().layout();
    }

    @Override
    protected void createContentsBeforeColumns(Composite panel) {
        Text nameText;
        if (this.entity != null) {
            this.addTypePrefix(DBSEntityConstraintType.PRIMARY_KEY, "_PK");
            this.addTypePrefix(DBSEntityConstraintType.UNIQUE_KEY, "_UN");
            this.addTypePrefix(DBSEntityConstraintType.VIRTUAL_KEY, "_VK");
            this.addTypePrefix(DBSEntityConstraintType.FOREIGN_KEY, "_FK");
            this.addTypePrefix(DBSEntityConstraintType.CHECK, "_CHECK");
            if (CommonUtils.isEmpty((String)this.constraintName)) {
                String namePrefix = this.TYPE_PREFIX.get(this.constraintTypes[0]);
                if (namePrefix == null) {
                    namePrefix = "KEY";
                }
                this.constraintName = DBObjectNameCaseTransformer.transformName((DBPDataSource)this.entity.getDataSource(), (String)(String.valueOf(CommonUtils.escapeIdentifier((String)this.entity.getName())) + namePrefix));
            }
        }
        Text text = nameText = this.entity != null ? UIUtils.createLabelText((Composite)panel, (String)EditorsMessages.dialog_struct_edit_constrain_label_name, (String)this.constraintName) : null;
        if (nameText != null) {
            nameText.addModifyListener(e -> {
                String string = this.constraintName = nameText.getText();
            });
        }
        UIUtils.createControlLabel((Composite)panel, (String)EditorsMessages.dialog_struct_edit_constrain_label_type);
        final Combo typeCombo = new Combo(panel, 12);
        typeCombo.setLayoutData((Object)new GridData(768));
        DBSEntityConstraintType[] dBSEntityConstraintTypeArray = this.constraintTypes;
        int n = this.constraintTypes.length;
        int n2 = 0;
        while (n2 < n) {
            DBSEntityConstraintType constraintType = dBSEntityConstraintTypeArray[n2];
            typeCombo.add(constraintType.getName());
            if (this.selectedConstraintType == null) {
                this.selectedConstraintType = constraintType;
            }
            ++n2;
        }
        typeCombo.select(0);
        typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newPrefix;
                String oldPrefix;
                DBSEntityConstraintType oldType = EditConstraintPage.this.selectedConstraintType;
                EditConstraintPage.this.selectedConstraintType = EditConstraintPage.this.constraintTypes[typeCombo.getSelectionIndex()];
                if (EditConstraintPage.this.constraintName != null && (oldPrefix = (String)EditConstraintPage.this.TYPE_PREFIX.get(oldType)) != null && EditConstraintPage.this.constraintName.endsWith(oldPrefix) && (newPrefix = (String)EditConstraintPage.this.TYPE_PREFIX.get(EditConstraintPage.this.selectedConstraintType)) != null) {
                    EditConstraintPage.this.constraintName = String.valueOf(EditConstraintPage.this.constraintName.substring(0, EditConstraintPage.this.constraintName.length() - oldPrefix.length())) + newPrefix;
                    if (nameText != null) {
                        nameText.setText(EditConstraintPage.this.constraintName);
                    }
                }
                EditConstraintPage.this.toggleEditAreas();
            }
        });
        if (this.showEnable) {
            final Button enableConstraintButton = UIUtils.createCheckbox((Composite)panel, (String)"Enable Constraint", (String)"Enable constraint after creation", (boolean)true, (int)2);
            enableConstraintButton.setVisible(this.showEnable);
            enableConstraintButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditConstraintPage.this.enableConstraint = enableConstraintButton.getSelection();
                }
            });
        }
        if (this.isUniqueVirtualKeyEdit()) {
            final Button useAllColumnsCheck = UIUtils.createCheckbox((Composite)panel, (String)"Use All columns", (String)"Include all table columns in unique key", (boolean)this.useAllColumns, (int)2);
            useAllColumnsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditConstraintPage.this.useAllColumns = useAllColumnsCheck.getSelection();
                    EditConstraintPage.this.columnsTable.setEnabled(!EditConstraintPage.this.useAllColumns);
                }
            });
        }
    }

    @Override
    protected void createContentsAfterColumns(Composite panel) {
        this.expressionGroup = UIUtils.createControlGroup((Composite)panel, (String)"Expression", (int)1, (int)1808, (int)0);
        this.expressionText = new Text((Composite)this.expressionGroup, 2050);
        GridData gd = new GridData(1808);
        gd.heightHint = this.expressionText.getLineHeight() * 3;
        this.expressionText.setLayoutData((Object)gd);
        this.expressionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditConstraintPage.this.constraintExpression = EditConstraintPage.this.expressionText.getText();
                EditConstraintPage.this.updatePageState();
            }
        });
        this.columnsTable.setEnabled(!this.useAllColumns);
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public DBSEntityConstraintType getConstraintType() {
        return this.selectedConstraintType;
    }

    public String getConstraintExpression() {
        return this.constraintExpression;
    }

    @Override
    public boolean isPageComplete() {
        if (this.selectedConstraintType == null) {
            return false;
        }
        if (this.selectedConstraintType.isCustom()) {
            return !CommonUtils.isEmpty((String)this.constraintExpression);
        }
        return super.isPageComplete();
    }

    @Override
    public boolean isColumnSelected(DBSEntityAttribute attribute) {
        if (!CommonUtils.isEmpty(this.attributes)) {
            for (DBSEntityAttributeRef dBSEntityAttributeRef : this.attributes) {
                if (dBSEntityAttributeRef.getAttribute() != attribute) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEnableConstraint() {
        return this.enableConstraint;
    }

    public boolean isUseAllColumns() {
        return this.useAllColumns;
    }
}

