/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttributeIdentity;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCollation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreTableColumnManager
extends SQLTableColumnManager<PostgreTableColumn, PostgreTableBase>
implements DBEObjectRenamer<PostgreTableColumn> {
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreDataTypeModifier = (monitor, column, sql, command) -> {
        PostgreDataType rawType;
        PostgreDataType dataType;
        block28: {
            sql.append(' ');
            dataType = column.getDataType();
            String defValue = column.getDefaultValue();
            if (CommonUtils.isEmpty((String)defValue) || !defValue.contains("nextval")) break block28;
            switch (dataType.getName()) {
                case "int2": {
                    sql.append("smallserial");
                    return;
                }
                case "int4": {
                    sql.append("serial");
                    return;
                }
                case "int8": {
                    sql.append("bigserial");
                    return;
                }
            }
        }
        if ((rawType = null) != null) {
            sql.append(rawType.getFullyQualifiedName(DBPEvaluationContext.DDL));
        } else {
            sql.append(dataType.getFullyQualifiedName(DBPEvaluationContext.DDL));
        }
        switch (dataType.getDataKind()) {
            case STRING: {
                long length = column.getMaxLength();
                if (length <= 0L) break;
                sql.append('(').append(length).append(')');
                break;
            }
            case NUMERIC: {
                if (dataType.getTypeID() != 2) break;
                int precision = CommonUtils.toInt((Object)column.getPrecision());
                int scale = CommonUtils.toInt((Object)column.getScale());
                if (scale <= 0 && precision <= 0) break;
                sql.append('(');
                if (precision > 0) {
                    sql.append(precision);
                }
                if (scale > 0) {
                    if (precision > 0) {
                        sql.append(',');
                    }
                    sql.append(scale);
                }
                sql.append(')');
            }
        }
        if (PostgreUtils.isGISDataType(column.getTypeName())) {
            try {
                String geometryType = column.getAttributeGeometryType(monitor);
                int geometrySRID = column.getAttributeGeometrySRID(monitor);
                if (geometryType != null && !"geometry".equalsIgnoreCase(geometryType) && !"geography".equalsIgnoreCase(geometryType)) {
                    sql.append("(").append(geometryType);
                    if (geometrySRID > 0) {
                        sql.append(", ").append(geometrySRID);
                    }
                    sql.append(")");
                }
            }
            catch (DBCException e) {
                log.debug((Object)e);
            }
        }
        if (rawType != null) {
            sql.append("[]");
        }
    };
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreDefaultModifier = (monitor, column, sql, command) -> {
        block11: {
            String defaultValue = column.getDefaultValue();
            if (CommonUtils.isEmpty((String)defaultValue) || !defaultValue.contains("nextval")) break block11;
            switch (column.getDataType().getName()) {
                case "int2": 
                case "int4": 
                case "int8": {
                    return;
                }
            }
        }
        this.DefaultModifier.appendModifier(monitor, column, sql, command);
    };
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreIdentityModifier = (monitor, column, sql, command) -> {
        PostgreAttributeIdentity identity = column.getIdentity();
        if (identity != null) {
            sql.append(" ").append(identity.getDefinitionClause());
        }
    };
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreCollateModifier = (monitor, column, sql, command) -> {
        try {
            PostgreCollation collation = column.getCollation(monitor);
            if (collation != null && !"default".equals(collation.getName())) {
                sql.append(" COLLATE \"").append(collation.getName()).append("\"");
            }
        }
        catch (DBException e) {
            log.debug((Object)e);
        }
    };
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreCommentModifier = (monitor, column, sql, command) -> {
        String comment = column.getDescription();
        if (!CommonUtils.isEmpty((String)comment)) {
            sql.append(" -- ").append(CommonUtils.getSingleLineString((String)comment));
        }
    };

    @Nullable
    public DBSObjectCache<? extends DBSObject, PostgreTableColumn> getObjectsCache(PostgreTableColumn object) {
        return ((PostgreTableContainer)((PostgreTableBase)object.getParentObject()).getContainer()).getSchema().getTableCache().getChildrenCache((PostgreTableBase)object.getParentObject());
    }

    protected SQLTableColumnManager.ColumnModifier[] getSupportedModifiers(PostgreTableColumn column, Map<String, Object> options) {
        Object[] modifiers = new SQLTableColumnManager.ColumnModifier[]{this.PostgreDataTypeModifier, this.NullNotNullModifier, this.PostgreDefaultModifier, this.PostgreIdentityModifier, this.PostgreCollateModifier};
        if (CommonUtils.getOption(options, (String)"pg.ddl.show.column.comments")) {
            modifiers = (SQLTableColumnManager.ColumnModifier[])ArrayUtils.add(SQLTableColumnManager.ColumnModifier.class, (Object[])modifiers, this.PostgreCommentModifier);
        }
        return modifiers;
    }

    public StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, PostgreTableBase owner, DBECommandAbstract<PostgreTableColumn> command, Map<String, Object> options) {
        StringBuilder decl = super.getNestedDeclaration(monitor, (DBSEntity)owner, command, options);
        PostgreAttribute cfr_ignored_0 = (PostgreAttribute)command.getObject();
        return decl;
    }

    protected PostgreTableColumn createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        PostgreTableBase table = (PostgreTableBase)container;
        PostgreTableColumn column = new PostgreTableColumn(table);
        column.setName(this.getNewColumnName(monitor, context, table));
        PostgreDataType dataType = table.getDatabase().getDataType(monitor, 1043L);
        column.setDataType(dataType);
        column.setOrdinalPosition(-1);
        return column;
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        super.addObjectCreateActions(monitor, executionContext, actions, command, options);
        if (!CommonUtils.isEmpty((String)((PostgreTableColumn)command.getObject()).getDescription())) {
            PostgreTableColumnManager.addColumnCommentAction(actions, (PostgreAttribute)command.getObject());
        }
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        PostgreAttribute column = (PostgreAttribute)command.getObject();
        String prefix = "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)column.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + " ALTER COLUMN " + DBUtils.getQuotedIdentifier((DBSObject)column) + " ";
        String typeClause = column.getFullTypeName();
        if (column.getDataType() != null) {
            typeClause = String.valueOf(typeClause) + " USING " + DBUtils.getQuotedIdentifier((DBSObject)column) + "::" + column.getDataType().getName();
        }
        if (command.getProperty((Object)"dataType") != null || command.getProperty((Object)"maxLength") != null || command.getProperty((Object)"precision") != null || command.getProperty((Object)"scale") != null) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column type", String.valueOf(prefix) + "TYPE " + typeClause));
        }
        if (command.getProperty((Object)"required") != null) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column nullability", String.valueOf(prefix) + (column.isRequired() ? "SET" : "DROP") + " NOT NULL"));
        }
        if (command.getProperty((Object)"defaultValue") != null) {
            if (CommonUtils.isEmpty((String)column.getDefaultValue())) {
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Drop column default", String.valueOf(prefix) + "DROP DEFAULT"));
            } else {
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column default", String.valueOf(prefix) + "SET DEFAULT " + column.getDefaultValue()));
            }
        }
        if (command.getProperty((Object)"description") != null) {
            PostgreTableColumnManager.addColumnCommentAction(actionList, column);
        }
    }

    public static void addColumnCommentAction(List<DBEPersistAction> actionList, PostgreAttribute column) {
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column comment", "COMMENT ON COLUMN " + DBUtils.getObjectFullName((DBPNamedObject)column.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + "." + DBUtils.getQuotedIdentifier((DBSObject)column) + " IS " + SQLUtils.quoteString((DBSObject)column, (String)CommonUtils.notEmpty((String)column.getDescription()))));
    }

    public void renameObject(DBECommandContext commandContext, PostgreTableColumn object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
        PostgreTableBase table = (PostgreTableBase)object.getTable();
        if (table.isPersisted() && table instanceof PostgreViewBase) {
            table.setObjectDefinitionText(null);
            commandContext.addCommand((DBECommand)new SQLObjectEditor.EmptyCommand((DBPObject)table), (DBECommandReflector)new SQLObjectEditor.RefreshObjectReflector(), true);
        }
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        PostgreAttribute column = (PostgreAttribute)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)column.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + " RENAME COLUMN " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getNewName())));
    }
}

