/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.tools.maintenance;

import java.util.Collection;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleTable;
import org.jkiss.dbeaver.ext.oracle.ui.tools.maintenance.OracleMaintenanceDialog;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.tools.IUserInterfaceTool;
import org.jkiss.utils.CommonUtils;

public class OracleToolTruncate
implements IUserInterfaceTool {
    public void execute(IWorkbenchWindow window, IWorkbenchPart activePart, Collection<DBSObject> objects) throws DBException {
        List tables = CommonUtils.filterCollection(objects, OracleTable.class);
        if (!tables.isEmpty()) {
            SQLDialog dialog = new SQLDialog(activePart.getSite(), tables);
            dialog.open();
        }
    }

    static class SQLDialog
    extends OracleMaintenanceDialog<OracleTable> {
        private Button reuseStorage;

        public SQLDialog(IWorkbenchPartSite partSite, Collection<OracleTable> selectedTables) {
            super(partSite, "Truncate table(s)", selectedTables);
        }

        protected void generateObjectCommand(List<String> lines, OracleTable object) {
            String sql = "TRUNCATE TABLE " + object.getFullyQualifiedName(DBPEvaluationContext.DDL);
            if (this.reuseStorage.getSelection()) {
                sql = String.valueOf(sql) + " REUSE STORAGE";
            }
            lines.add(sql);
        }

        protected void createControls(Composite parent) {
            Group optionsGroup = UIUtils.createControlGroup((Composite)parent, (String)"Options", (int)1, (int)0, (int)0);
            optionsGroup.setLayoutData((Object)new GridData(768));
            this.reuseStorage = UIUtils.createCheckbox((Composite)optionsGroup, (String)"Reuse storage", (boolean)false);
            this.reuseStorage.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.reuseStorage.setToolTipText("Specify REUSE STORAGE to retain the space from the deleted rows allocated to the table.\nStorage values are not reset to the values when the table or cluster was created.\nThis space can subsequently be used only by new data in the table or cluster resulting from insert or update operations.\nThis clause leaves storage parameters at their current settings.");
            this.createObjectsSelector(parent);
        }

        protected boolean needsRefreshOnFinish() {
            return true;
        }
    }
}

