/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IHelpContextIdProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.EditVirtualAttributePage;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.editors.object.struct.BaseObjectEditPage;
import org.jkiss.utils.CommonUtils;

public class EditVirtualColumnsPage
extends BaseObjectEditPage
implements IHelpContextIdProvider {
    private ResultSetViewer viewer;
    private DBVEntity vEntity;
    private boolean structChanged;
    private Table attrTable;

    public EditVirtualColumnsPage(ResultSetViewer viewer, DBVEntity vEntity) {
        super("Add virtual columns", DBIcon.TREE_COLUMN);
        this.viewer = viewer;
        this.vEntity = vEntity;
    }

    public boolean isStructChanged() {
        return this.structChanged;
    }

    protected Composite createPageContents(final Composite parent) {
        Composite panel = UIUtils.createComposite((Composite)parent, (int)1);
        panel.setLayoutData((Object)new GridData(1808));
        this.attrTable = new Table(panel, 67584);
        this.attrTable.setLayoutData((Object)new GridData(1808));
        this.attrTable.setHeaderVisible(true);
        UIUtils.executeOnResize((Control)this.attrTable, () -> UIUtils.packColumns((Table)this.attrTable, (boolean)true));
        UIUtils.createTableColumn((Table)this.attrTable, (int)16384, (String)"Name");
        UIUtils.createTableColumn((Table)this.attrTable, (int)16384, (String)"Data type");
        UIUtils.createTableColumn((Table)this.attrTable, (int)16384, (String)"Expression");
        Composite buttonsPanel = UIUtils.createComposite((Composite)panel, (int)3);
        buttonsPanel.setLayoutData((Object)new GridData(32));
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Add", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBVEntityAttribute vAttr = new DBVEntityAttribute(EditVirtualColumnsPage.this.vEntity, null, "vcolumn");
                EditVirtualAttributePage editAttrPage = new EditVirtualAttributePage(EditVirtualColumnsPage.this.viewer, vAttr);
                if (editAttrPage.edit(parent.getShell())) {
                    vAttr.setCustom(true);
                    EditVirtualColumnsPage.this.vEntity.addVirtualAttribute(vAttr);
                    EditVirtualColumnsPage.this.structChanged = true;
                    EditVirtualColumnsPage.this.createAttributeItem(EditVirtualColumnsPage.this.attrTable, vAttr);
                }
            }
        });
        final Button btnEdit = UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Edit ...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditVirtualColumnsPage.this.editSelectedAttribute(EditVirtualColumnsPage.this.attrTable);
            }
        });
        btnEdit.setEnabled(false);
        final Button btnRemove = UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Remove", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBVEntityAttribute virtualAttr = (DBVEntityAttribute)EditVirtualColumnsPage.this.attrTable.getSelection()[0].getData();
                if (!UIUtils.confirmAction((Shell)parent.getShell(), (String)"Delete virtual column", (String)("Are you sure you want to delete virtual column '" + virtualAttr.getName() + "'?"))) {
                    return;
                }
                EditVirtualColumnsPage.this.vEntity.removeVirtualAttribute(virtualAttr);
                EditVirtualColumnsPage.this.attrTable.remove(EditVirtualColumnsPage.this.attrTable.getSelectionIndices());
                EditVirtualColumnsPage.this.structChanged = true;
            }
        });
        btnRemove.setEnabled(false);
        this.attrTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean attrSelected = EditVirtualColumnsPage.this.attrTable.getSelectionIndex() >= 0;
                btnEdit.setEnabled(attrSelected);
                btnRemove.setEnabled(attrSelected);
            }
        });
        this.attrTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                EditVirtualColumnsPage.this.editSelectedAttribute(EditVirtualColumnsPage.this.attrTable);
            }
        });
        this.refreshAttributes();
        return panel;
    }

    private void editSelectedAttribute(Table attrTable) {
        TableItem[] selection = attrTable.getSelection();
        if (selection.length <= 0) {
            return;
        }
        TableItem tableItem = selection[0];
        DBVEntityAttribute vAttr = (DBVEntityAttribute)tableItem.getData();
        EditVirtualAttributePage editAttrPage = new EditVirtualAttributePage(this.viewer, vAttr);
        if (editAttrPage.edit(attrTable.getShell())) {
            tableItem.setText(0, vAttr.getName());
            tableItem.setText(1, vAttr.getTypeName());
            tableItem.setText(2, CommonUtils.notEmpty((String)vAttr.getExpression()));
        }
    }

    private void createAttributeItem(Table attrTable, DBVEntityAttribute attribute) {
        TableItem item = new TableItem(attrTable, 0);
        item.setImage(0, DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)attribute)));
        item.setText(0, attribute.getName());
        item.setText(1, attribute.getTypeName());
        if (attribute.getExpression() != null) {
            item.setText(2, attribute.getExpression());
        }
        item.setData((Object)attribute);
    }

    public void refreshAttributes() {
        this.attrTable.removeAll();
        for (DBVEntityAttribute attr : this.vEntity.getCustomAttributes()) {
            this.createAttributeItem(this.attrTable, attr);
        }
    }

    public String getHelpContextId() {
        return "virtual-column-expressions";
    }
}

