/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.rules;

import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPPartitionScanner;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;
import org.jkiss.dbeaver.model.text.parser.rules.MultiLineRule;

public class NestedMultiLineRule
extends MultiLineRule {
    protected int _commentNestingDepth = 0;

    public NestedMultiLineRule(String startSequence, String endSequence, TPToken token) {
        super(startSequence, endSequence, token);
    }

    public NestedMultiLineRule(String startSequence, String endSequence, TPToken token, char escapeCharacter) {
        super(startSequence, endSequence, token, escapeCharacter);
    }

    public NestedMultiLineRule(String startSequence, String endSequence, TPToken token, char escapeCharacter, boolean breaksOnEOF) {
        super(startSequence, endSequence, token, escapeCharacter, breaksOnEOF);
    }

    @Override
    protected boolean endSequenceDetected(TPCharacterScanner scanner) {
        int c;
        while ((c = scanner.read()) != -1) {
            if (c == this.fEscapeCharacter) {
                scanner.read();
                continue;
            }
            if (this.fEndSequence.length > 0 && c == this.fEndSequence[0]) {
                if (this.sequenceDetected(scanner, this.fEndSequence, true)) {
                    --this._commentNestingDepth;
                }
                if (this._commentNestingDepth > 0) continue;
                return true;
            }
            if (this.fStartSequence.length <= 0 || c != this.fStartSequence[0] || !this.sequenceDetected(scanner, this.fStartSequence, false)) continue;
            ++this._commentNestingDepth;
        }
        if (this.fBreaksOnEOF) {
            return true;
        }
        scanner.unread();
        return false;
    }

    @Override
    protected TPToken doEvaluate(TPCharacterScanner scanner, boolean resume) {
        if (resume) {
            String scanned;
            this._commentNestingDepth = 0;
            if (scanner instanceof TPPartitionScanner && (scanned = ((TPPartitionScanner)scanner).getScannedPartitionString()) != null && scanned.length() > 0) {
                String startSequence = new String(this.fStartSequence);
                int index = 0;
                while ((index = scanned.indexOf(startSequence, index)) >= 0) {
                    ++index;
                    ++this._commentNestingDepth;
                }
                String endSequence = new String(this.fEndSequence);
                index = 0;
                while ((index = scanned.indexOf(endSequence, index)) >= 0) {
                    ++index;
                    --this._commentNestingDepth;
                }
            }
            if (this.endSequenceDetected(scanner)) {
                return this.fToken;
            }
        } else {
            int c = scanner.read();
            if (c == this.fStartSequence[0] && this.sequenceDetected(scanner, this.fStartSequence, false)) {
                this._commentNestingDepth = 1;
                if (this.endSequenceDetected(scanner)) {
                    return this.fToken;
                }
            }
        }
        scanner.unread();
        return TPTokenAbstract.UNDEFINED;
    }
}

