/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.model;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.data.DBDPreferences;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.data.DefaultValueHandler;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.tools.transfer.stream.model.StreamDataSourceContainer;
import org.jkiss.dbeaver.tools.transfer.stream.model.StreamDataSourceInfo;
import org.jkiss.dbeaver.tools.transfer.stream.model.StreamExecutionContext;

public class StreamDataSource
implements DBPDataSource,
DBSInstance,
DBDValueHandlerProvider {
    private final StreamDataSourceContainer container;
    private final StreamExecutionContext executionContext;

    public StreamDataSource(StreamDataSourceContainer container) {
        this.container = container;
        this.executionContext = new StreamExecutionContext(this, "Main");
    }

    public StreamDataSource(File inputFile) {
        this(new StreamDataSourceContainer(inputFile));
    }

    public StreamDataSource(String inputName) {
        this(new StreamDataSourceContainer(inputName));
    }

    @NotNull
    public DBPDataSourceContainer getContainer() {
        return this.container;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return new StreamDataSourceInfo();
    }

    public Object getDataSourceFeature(String featureId) {
        return null;
    }

    public SQLDialect getSQLDialect() {
        return BasicSQLDialect.INSTANCE;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
    }

    @NotNull
    public DBCExecutionContext getDefaultContext(DBRProgressMonitor monitor, boolean meta) {
        return this.executionContext;
    }

    @NotNull
    public DBCExecutionContext[] getAllContexts() {
        return new DBCExecutionContext[]{this.executionContext};
    }

    @NotNull
    public StreamExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose, @Nullable DBCExecutionContext initFrom) throws DBException {
        return new StreamExecutionContext(this, purpose);
    }

    @NotNull
    public DBSInstance getDefaultInstance() {
        return this;
    }

    @NotNull
    public Collection<? extends DBSInstance> getAvailableInstances() {
        return Collections.singleton(this);
    }

    public void shutdown(DBRProgressMonitor monitor) {
    }

    @Nullable
    public DBDValueHandler getValueHandler(DBPDataSource dataSource, DBDPreferences preferences, DBSTypedObject typedObject) {
        return DefaultValueHandler.INSTANCE;
    }

    @Nullable
    public DBSObject getParentObject() {
        return null;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this;
    }

    @NotNull
    public String getName() {
        return this.container.getName();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }
}

