/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;

public class NavigatorHandlerToggleView
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String viewId = event.getParameter("viewId");
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IViewPart view = UIUtils.findView((IWorkbenchWindow)workbenchWindow, (String)viewId);
        if (view != null) {
            workbenchWindow.getActivePage().hideView(view);
        } else {
            try {
                workbenchWindow.getActivePage().showView(viewId);
            }
            catch (PartInitException e) {
                DBWorkbench.getPlatformUI().showError("Toggle view", "Cannot open view " + viewId, (Throwable)e);
            }
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        String viewId = (String)parameters.get("viewId");
        IViewPart view = UIUtils.getActiveWorkbenchWindow().getActivePage().findView(viewId);
        element.setChecked(view != null);
    }
}

