/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.INewWizard;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.jobs.ConnectJob;
import org.jkiss.dbeaver.runtime.jobs.DisconnectJob;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.IDataSourceConnectionTester;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizard;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageSettings;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionTestDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class ConnectionWizard
extends ActiveWizard
implements INewWizard {
    static final String PROP_CONNECTION_TYPE = "connection-type";
    private static final Log log = Log.getLog(ConnectionWizard.class);
    private final Map<DriverDescriptor, DataSourceDescriptor> infoMap = new HashMap<DriverDescriptor, DataSourceDescriptor>();
    private final List<IPropertyChangeListener> propertyListeners = new ArrayList<IPropertyChangeListener>();

    protected ConnectionWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public String getWindowTitle() {
        if (this.isNew()) {
            return CoreMessages.dialog_new_connection_wizard_title;
        }
        DataSourceDescriptor activeDataSource = this.getActiveDataSource();
        return NLS.bind((String)CoreMessages.dialog_connection_edit_title, (Object)activeDataSource.getName());
    }

    public Image getDefaultPageImage() {
        DBPDriver selectedDriver = this.getSelectedDriver();
        return DBeaverIcons.getImage((DBPImage)(selectedDriver == null ? DBIcon.DATABASE_DEFAULT : selectedDriver.getIcon()));
    }

    public void dispose() {
        for (DataSourceDescriptor dataSource : this.infoMap.values()) {
            dataSource.dispose();
        }
        super.dispose();
    }

    public abstract DBPDataSourceRegistry getDataSourceRegistry();

    abstract DBPDriver getSelectedDriver();

    abstract DBPProject getSelectedProject();

    public abstract ConnectionPageSettings getPageSettings();

    protected abstract void saveSettings(DataSourceDescriptor var1);

    @NotNull
    public DataSourceDescriptor getActiveDataSource() {
        DriverDescriptor driver = (DriverDescriptor)this.getSelectedDriver();
        DataSourceDescriptor info = this.infoMap.get(driver);
        if (info == null) {
            DBPConnectionConfiguration connectionInfo = new DBPConnectionConfiguration();
            info = new DataSourceDescriptor(this.getDataSourceRegistry(), DataSourceDescriptor.generateNewId((DBPDriver)this.getSelectedDriver()), driver, connectionInfo);
            DBPNativeClientLocation defaultClientLocation = driver.getDefaultClientLocation();
            if (defaultClientLocation != null) {
                info.getConnectionConfiguration().setClientHomeId(defaultClientLocation.getName());
            }
            info.setSavePassword(true);
            this.infoMap.put(driver, info);
        }
        return info;
    }

    public DataSourceDescriptor getOriginalDataSource() {
        return null;
    }

    public void testConnection() {
        DataSourceDescriptor dataSource = this.getPageSettings().getActiveDataSource();
        DataSourceDescriptor testDataSource = new DataSourceDescriptor(dataSource);
        this.saveSettings(testDataSource);
        testDataSource.setTemporary(true);
        testDataSource.setId(DataSourceDescriptor.generateNewId((DBPDriver)dataSource.getDriver()));
        testDataSource.getPreferenceStore().setValue("database.meta.separate.connection", false);
        try {
            ConnectionTester op = new ConnectionTester(testDataSource);
            try {
                this.getContainer().run(true, true, monitor -> {
                    connectionTester.ownerMonitor = RuntimeUtils.makeMonitor((IProgressMonitor)monitor);
                    op.schedule();
                    while (op.getState() == 2 || op.getState() == 4) {
                        if (monitor.isCanceled()) {
                            op.cancel();
                            throw new InterruptedException();
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                    if (op.getConnectError() != null) {
                        throw new InvocationTargetException(op.getConnectError());
                    }
                    if (op.getConnectStatus() == Status.CANCEL_STATUS) {
                        throw new InterruptedException("cancel");
                    }
                });
                String serverVersion = "?";
                String clientVersion = "?";
                if (!CommonUtils.isEmpty((String)op.productName)) {
                    serverVersion = String.valueOf(op.productName) + " " + op.productVersion;
                }
                if (!CommonUtils.isEmpty((String)op.driverName)) {
                    clientVersion = String.valueOf(op.driverName) + " " + op.driverVersion;
                }
                new ConnectionTestDialog(this.getShell(), serverVersion, clientVersion, op.connectTime).open();
            }
            catch (InterruptedException ex) {
                if (!"cancel".equals(ex.getMessage())) {
                    DBWorkbench.getPlatformUI().showError(CoreMessages.dialog_connection_wizard_start_dialog_interrupted_title, CoreMessages.dialog_connection_wizard_start_dialog_interrupted_message);
                }
            }
            catch (InvocationTargetException ex) {
                DBWorkbench.getPlatformUI().showError(CoreMessages.dialog_connection_wizard_start_dialog_error_title, null, GeneralUtils.makeExceptionStatus((Throwable)ex.getTargetException()));
            }
            catch (Throwable ex) {
                DBWorkbench.getPlatformUI().showError(CoreMessages.dialog_connection_wizard_start_dialog_error_title, null, GeneralUtils.makeExceptionStatus((Throwable)ex));
            }
        }
        finally {
            testDataSource.dispose();
        }
    }

    public boolean isNew() {
        return false;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyListeners.add(listener);
    }

    public void firePropertyChangeEvent(String property, Object oldValue, Object newValue) {
        for (IPropertyChangeListener listener : this.propertyListeners) {
            listener.propertyChange(new PropertyChangeEvent((Object)this, property, oldValue, newValue));
        }
    }

    public boolean openSettingsPage(String pageId) {
        IWizardPage page = this.getPage(pageId);
        if (page != null) {
            this.getContainer().showPage(page);
        }
        return false;
    }

    private class ConnectionTester
    extends ConnectJob {
        String productName;
        String productVersion;
        String driverName;
        String driverVersion;
        long connectTime;
        DBRProgressMonitor ownerMonitor;

        ConnectionTester(DataSourceDescriptor testDataSource) {
            super((DBPDataSourceContainer)testDataSource);
            this.connectTime = -1L;
            this.setSystem(true);
            this.setUser(false);
            this.initialize = true;
            this.productName = null;
            this.productVersion = null;
        }

        public IStatus run(DBRProgressMonitor monitor) {
            if (this.ownerMonitor != null) {
                monitor = this.ownerMonitor;
            }
            Thread.currentThread().setName(CoreMessages.dialog_connection_wizard_start_connection_monitor_thread);
            try {
                DBCSession session;
                Object var7_11;
                this.container.setName(this.container.getConnectionConfiguration().getUrl());
                long startTime = System.currentTimeMillis();
                super.run(monitor);
                this.connectTime = System.currentTimeMillis() - startTime;
                if (this.connectError != null || monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                if (this.connectStatus == Status.CANCEL_STATUS) {
                    return Status.CANCEL_STATUS;
                }
                monitor.beginTask(CoreMessages.dialog_connection_wizard_start_connection_monitor_start, 3);
                DBPDataSource dataSource = this.container.getDataSource();
                if (dataSource == null) {
                    throw new DBException(ModelMessages.error_not_connected_to_database);
                }
                monitor.subTask(CoreMessages.dialog_connection_wizard_start_connection_monitor_subtask_test);
                DBPDataSourceInfo info = dataSource.getInfo();
                if (info != null) {
                    try {
                        this.productName = info.getDatabaseProductName();
                        this.productVersion = info.getDatabaseProductVersion();
                        this.driverName = info.getDriverName();
                        this.driverVersion = info.getDriverVersion();
                    }
                    catch (Exception e) {
                        log.error((Object)"Can't obtain connection metadata", (Throwable)e);
                    }
                } else {
                    Throwable e = null;
                    var7_11 = null;
                    try {
                        session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)dataSource, (String)"Test connection");
                        try {
                            if (session instanceof Connection) {
                                try {
                                    Connection connection = (Connection)session;
                                    DatabaseMetaData metaData = connection.getMetaData();
                                    this.productName = metaData.getDatabaseProductName();
                                    this.productVersion = metaData.getDatabaseProductVersion();
                                    this.driverName = metaData.getDriverName();
                                    this.driverVersion = metaData.getDriverVersion();
                                }
                                catch (Exception e2) {
                                    log.error((Object)"Can't obtain connection metadata", (Throwable)e2);
                                }
                            }
                        }
                        finally {
                            if (session != null) {
                                session.close();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                if (this.driverName == null || this.driverVersion == null) {
                    try {
                        Object driverInstance;
                        if (this.driverName == null) {
                            this.driverName = this.container.getDriver().getDriverClassName();
                        }
                        if (this.driverVersion == null && (driverInstance = this.container.getDriver().getDriverInstance(monitor)) instanceof Driver) {
                            this.driverVersion = String.valueOf(((Driver)driverInstance).getMajorVersion()) + "." + ((Driver)driverInstance).getMinorVersion();
                        }
                    }
                    catch (DBException e) {
                        log.debug((Object)e);
                    }
                }
                monitor.worked(1);
                monitor.subTask("Load connection info");
                Throwable throwable = null;
                var7_11 = null;
                try {
                    session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)dataSource, (String)"Call connection testers");
                    try {
                        IWizardPage[] iWizardPageArray = ConnectionWizard.this.getPages();
                        int n = iWizardPageArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IWizardPage page = iWizardPageArray[n2];
                            this.testInPage(session, (IDialogPage)page);
                            ++n2;
                        }
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                monitor.worked(1);
                new DisconnectJob(this.container).schedule();
                monitor.worked(1);
                monitor.subTask(CoreMessages.dialog_connection_wizard_start_connection_monitor_success);
            }
            catch (DBException ex) {
                this.connectError = ex;
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        private void testInPage(DBCSession session, IDialogPage page) {
            if (page instanceof IDataSourceConnectionTester && page.getControl() != null && !page.getControl().isDisposed()) {
                ((IDataSourceConnectionTester)page).testConnection(session);
            }
            if (page instanceof ICompositeDialogPage && ConnectionWizard.isPageActive((IDialogPage)page)) {
                for (IDialogPage subPage : ArrayUtils.safeArray((Object[])((ICompositeDialogPage)page).getSubPages(false, false))) {
                    this.testInPage(session, subPage);
                }
            }
        }
    }
}

