/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data;

import java.io.IOException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentAbstract;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public abstract class JDBCContentLOB
extends JDBCContentAbstract
implements DBDContent {
    private DBDContentStorage originalStorage;
    protected DBDContentStorage storage;

    protected JDBCContentLOB(DBPDataSource dataSource) {
        super(dataSource);
    }

    @Override
    public long getContentLength() throws DBCException {
        if (this.storage != null) {
            return this.storage.getContentLength();
        }
        return this.getLOBLength();
    }

    protected abstract long getLOBLength() throws DBCException;

    @Override
    public boolean updateContents(DBRProgressMonitor monitor, DBDContentStorage storage) {
        if (this.storage != null) {
            if (this.originalStorage != null && this.originalStorage != this.storage) {
                this.originalStorage.release();
            }
            this.originalStorage = this.storage;
        }
        this.storage = storage;
        this.modified = true;
        return true;
    }

    @Override
    public void release() {
        if (this.storage != null) {
            this.storage.release();
            this.storage = null;
        }
        if (this.originalStorage != null) {
            this.originalStorage.release();
            this.originalStorage = null;
        }
    }

    @Override
    public void resetContents() {
        if (this.originalStorage != null) {
            if (this.storage != null) {
                this.storage.release();
            }
            this.storage = this.originalStorage;
            this.modified = false;
        }
    }

    @Override
    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) throws DBCException {
        JDBCContentLOB copy = this.createNewContent();
        DBDContentStorage storage = this.getContents(monitor);
        if (storage != null) {
            try {
                copy.updateContents(monitor, storage.cloneStorage(monitor));
            }
            catch (IOException e) {
                throw new DBCException("IO error while clone content", e);
            }
        }
        return copy;
    }

    protected abstract JDBCContentLOB createNewContent();
}

