/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.maven.IMavenIdentifier;
import org.jkiss.dbeaver.registry.maven.MavenArtifact;
import org.jkiss.dbeaver.registry.maven.MavenArtifactDependency;
import org.jkiss.dbeaver.registry.maven.MavenArtifactLicense;
import org.jkiss.dbeaver.registry.maven.MavenArtifactReference;
import org.jkiss.dbeaver.registry.maven.MavenProfile;
import org.jkiss.dbeaver.registry.maven.MavenRegistry;
import org.jkiss.dbeaver.registry.maven.MavenRepository;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.runtime.WebUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MavenArtifactVersion
implements IMavenIdentifier {
    private static final Log log = Log.getLog(MavenArtifactVersion.class);
    public static final String PROP_PROJECT_VERSION = "project.version";
    public static final String PROP_PROJECT_GROUP_ID = "project.groupId";
    public static final String PROP_PROJECT_ARTIFACT_ID = "project.artifactId";
    private static final String DEFAULT_PROFILE_ID = "#root";
    private MavenArtifact artifact;
    private String name;
    private String version;
    private String packaging;
    private String description;
    private String url;
    private MavenArtifactVersion parent;
    private List<MavenArtifactVersion> imports;
    private final List<MavenArtifactLicense> licenses = new ArrayList<MavenArtifactLicense>();
    private final List<MavenProfile> profiles = new ArrayList<MavenProfile>();
    private final List<MavenRepository> repositories = new ArrayList<MavenRepository>();
    private IVariableResolver propertyResolver = new IVariableResolver(){

        public String get(String name) {
            switch (name) {
                case "project.version": {
                    return MavenArtifactVersion.this.version;
                }
                case "project.groupId": {
                    return MavenArtifactVersion.this.artifact.getGroupId();
                }
                case "project.artifactId": {
                    return MavenArtifactVersion.this.artifact.getArtifactId();
                }
            }
            MavenArtifactVersion v = MavenArtifactVersion.this;
            while (v != null) {
                for (MavenProfile profile : v.profiles) {
                    String value;
                    if (!profile.isActive() || (value = profile.properties.get(name)) == null) continue;
                    return MavenArtifactVersion.this.evaluateString(value);
                }
                v = v.parent;
            }
            return null;
        }
    };

    MavenArtifactVersion(@NotNull DBRProgressMonitor monitor, @NotNull MavenArtifact artifact, @NotNull String version) throws IOException {
        this.artifact = artifact;
        this.version = CommonUtils.trim((String)version);
        this.loadPOM(monitor);
    }

    @NotNull
    public MavenArtifact getArtifact() {
        return this.artifact;
    }

    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getGroupId() {
        return this.artifact.getGroupId();
    }

    @Override
    @NotNull
    public String getArtifactId() {
        return this.artifact.getArtifactId();
    }

    @Override
    @Nullable
    public String getClassifier() {
        return this.artifact.getClassifier();
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public String getId() {
        return MavenArtifactReference.makeId(this);
    }

    @Nullable
    public String getPackaging() {
        return this.packaging;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public MavenArtifactVersion getParent() {
        return this.parent;
    }

    public List<MavenArtifactLicense> getLicenses() {
        return this.licenses;
    }

    public List<MavenProfile> getProfiles() {
        return this.profiles;
    }

    public List<MavenArtifactDependency> getDependencies() {
        List<MavenArtifactDependency> parentDependencies;
        ArrayList<MavenArtifactDependency> dependencies = new ArrayList<MavenArtifactDependency>();
        for (MavenProfile profile : this.profiles) {
            if (!profile.isActive() || CommonUtils.isEmpty(profile.dependencies)) continue;
            dependencies.addAll(profile.dependencies);
        }
        if (this.parent != null && !CommonUtils.isEmpty(parentDependencies = this.parent.getDependencies())) {
            dependencies.addAll(parentDependencies);
        }
        return dependencies;
    }

    public File getCacheFile() {
        String fileExt = this.getPackagingFileExtension();
        if (this.artifact.getRepository().getType() == MavenRepository.RepositoryType.LOCAL) {
            String externalURL = this.getExternalURL(fileExt);
            try {
                return RuntimeUtils.getLocalFileFromURL((URL)new URL(externalURL));
            }
            catch (Exception e) {
                log.warn((Object)"Bad repository URL", (Throwable)e);
                return new File(externalURL);
            }
        }
        return new File(this.artifact.getRepository().getLocalCacheDir(), String.valueOf(this.artifact.getGroupId()) + "/" + this.artifact.getVersionFileName(this.version, fileExt));
    }

    public String getExternalURL() {
        return this.artifact.getFileURL(this.version, this.getPackagingFileExtension());
    }

    @NotNull
    private String getPackagingFileExtension() {
        String fileExt = this.packaging;
        if (CommonUtils.isEmpty((String)fileExt) || fileExt.equals("bundle")) {
            fileExt = "jar";
        }
        return fileExt;
    }

    public String getExternalURL(String fileType) {
        return this.artifact.getFileURL(this.version, fileType);
    }

    public String getPath() {
        return String.valueOf(this.artifact.toString()) + ":" + this.version;
    }

    public String toString() {
        return this.getPath();
    }

    private File getLocalPOM() {
        if (this.artifact.getRepository().getType() == MavenRepository.RepositoryType.LOCAL) {
            try {
                return new File(GeneralUtils.makeURIFromFilePath((String)this.getRemotePOMLocation()));
            }
            catch (URISyntaxException e) {
                log.warn((Object)e);
            }
        }
        return new File(this.artifact.getRepository().getLocalCacheDir(), String.valueOf(this.artifact.getGroupId()) + "/" + this.artifact.getVersionFileName(this.version, "pom"));
    }

    private String getRemotePOMLocation() {
        return this.artifact.getFileURL(this.version, "pom");
    }

    private void cachePOM(File localPOM) throws IOException {
        if (this.artifact.getRepository().getType() == MavenRepository.RepositoryType.LOCAL) {
            return;
        }
        String pomURL = this.getRemotePOMLocation();
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream is = WebUtils.openConnection((String)pomURL, (DBPAuthInfo)this.artifact.getRepository().getAuthInfo(), null).getInputStream();){
            File folder = localPOM.getParentFile();
            if (!folder.exists() && !folder.mkdirs()) {
                throw new IOException("Can't create cache folder '" + folder.getAbsolutePath() + "'");
            }
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (FileOutputStream os = new FileOutputStream(localPOM);){
                IOUtils.fastCopy((InputStream)is, (OutputStream)os);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void loadPOM(DBRProgressMonitor monitor) throws IOException {
        Element licensesElement;
        Document pomDocument;
        monitor.subTask("Load POM " + this);
        File localPOM = this.getLocalPOM();
        if (!localPOM.exists()) {
            this.cachePOM(localPOM);
        }
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (FileInputStream mdStream = new FileInputStream(localPOM);){
                pomDocument = XMLUtils.parseDocument((InputStream)mdStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (XMLException e) {
            throw new IOException("Error parsing POM", e);
        }
        Element root = pomDocument.getDocumentElement();
        this.name = CommonUtils.trim((String)XMLUtils.getChildElementBody((Element)root, (String)"name"));
        this.url = CommonUtils.trim((String)XMLUtils.getChildElementBody((Element)root, (String)"url"));
        this.version = CommonUtils.trim((String)XMLUtils.getChildElementBody((Element)root, (String)"version"));
        this.packaging = CommonUtils.trim((String)XMLUtils.getChildElementBody((Element)root, (String)"packaging"));
        this.description = CommonUtils.trim((String)XMLUtils.getChildElementBody((Element)root, (String)"description"));
        if (this.description != null) {
            this.description = CommonUtils.compactWhiteSpaces((String)this.description.trim());
        }
        this.repositories.addAll(this.parseRepositories(root));
        Element parentElement = XMLUtils.getChildElement((Element)root, (String)"parent");
        if (parentElement != null) {
            String parentGroupId = CommonUtils.trim((String)XMLUtils.getChildElementBody((Element)parentElement, (String)"groupId"));
            String parentArtifactId = CommonUtils.trim((String)XMLUtils.getChildElementBody((Element)parentElement, (String)"artifactId"));
            String parentVersion = CommonUtils.trim((String)XMLUtils.getChildElementBody((Element)parentElement, (String)"version"));
            if (parentGroupId == null || parentArtifactId == null || parentVersion == null) {
                log.error((Object)("Broken parent reference: " + parentGroupId + ":" + (String)parentArtifactId + ":" + parentVersion));
            } else {
                MavenArtifactReference parentReference = new MavenArtifactReference(parentGroupId, parentArtifactId, null, parentVersion);
                if (this.version == null) {
                    this.version = parentReference.getVersion();
                }
                this.parent = MavenRegistry.getInstance().findArtifact(monitor, this, parentReference);
                if (this.parent == null) {
                    log.error((Object)("Artifact [" + this + "] parent [" + parentReference + "] not found"));
                }
            }
        }
        if ((licensesElement = XMLUtils.getChildElement((Element)root, (String)"licenses")) != null) {
            for (Element prop : XMLUtils.getChildElementList((Element)licensesElement, (String)"license")) {
                this.licenses.add(new MavenArtifactLicense(XMLUtils.getChildElementBody((Element)prop, (String)"name"), XMLUtils.getChildElementBody((Element)prop, (String)"url")));
            }
        }
        MavenProfile defaultProfile = new MavenProfile(DEFAULT_PROFILE_ID);
        defaultProfile.active = true;
        this.profiles.add(defaultProfile);
        this.parseProfile(monitor, defaultProfile, root, true);
        Element licensesElement2 = XMLUtils.getChildElement((Element)root, (String)"profiles");
        if (licensesElement2 != null) {
            for (Element profElement : XMLUtils.getChildElementList((Element)licensesElement2, (String)"profile")) {
                MavenProfile profile = new MavenProfile(XMLUtils.getChildElementBody((Element)profElement, (String)"id"));
                this.profiles.add(profile);
                this.parseProfile(monitor, profile, profElement, false);
            }
        }
        monitor.worked(1);
    }

    private void parseProfile(DBRProgressMonitor monitor, MavenProfile profile, Element element, boolean isDefault) {
        Element dmElement;
        Element activationElement = XMLUtils.getChildElement((Element)element, (String)"activation");
        if (activationElement != null) {
            String propName;
            String jdk;
            String activeByDefault = XMLUtils.getChildElementBody((Element)activationElement, (String)"activeByDefault");
            if (!CommonUtils.isEmpty((String)activeByDefault)) {
                profile.active = CommonUtils.getBoolean((String)activeByDefault);
            }
            if (!CommonUtils.isEmpty((String)(jdk = XMLUtils.getChildElementBody((Element)activationElement, (String)"jdk")))) {
                profile.active = MavenArtifact.versionMatches(System.getProperty("java.version"), jdk);
            }
            Element osElement = XMLUtils.getChildElement((Element)activationElement, (String)"os");
            Element propElement = XMLUtils.getChildElement((Element)activationElement, (String)"property");
            if (propElement != null && (propName = XMLUtils.getChildElementBody((Element)propElement, (String)"name")) != null && propName.startsWith("!")) {
                profile.active = true;
            }
        }
        if (!profile.active) {
            return;
        }
        Element propsElement = XMLUtils.getChildElement((Element)element, (String)"properties");
        if (propsElement != null) {
            for (Element prop : XMLUtils.getChildElementList((Element)propsElement)) {
                profile.properties.put(prop.getTagName(), XMLUtils.getElementBody((Element)prop));
            }
        }
        if (!isDefault) {
            for (MavenRepository repository : this.parseRepositories(element)) {
                profile.addRepository(repository);
            }
        }
        if ((dmElement = XMLUtils.getChildElement((Element)element, (String)"dependencyManagement")) != null) {
            profile.dependencyManagement = this.parseDependencies(monitor, dmElement, true);
        }
        profile.dependencies = this.parseDependencies(monitor, element, false);
    }

    private List<MavenRepository> parseRepositories(Element element) {
        ArrayList<MavenRepository> repositories = new ArrayList<MavenRepository>();
        Element repsElement = XMLUtils.getChildElement((Element)element, (String)"repositories");
        if (repsElement != null) {
            for (Element repElement : XMLUtils.getChildElementList((Element)repsElement, (String)"repository")) {
                boolean enabled;
                MavenRepository repository = new MavenRepository(XMLUtils.getChildElementBody((Element)repElement, (String)"id"), XMLUtils.getChildElementBody((Element)repElement, (String)"name"), XMLUtils.getChildElementBody((Element)repElement, (String)"url"), MavenRepository.RepositoryType.EXTERNAL);
                String layout = XMLUtils.getChildElementBody((Element)repElement, (String)"layout");
                if ("legacy".equals(layout)) {
                    log.debug((Object)("Skip legacy repository [" + repository + "]"));
                    continue;
                }
                Element releasesElement = XMLUtils.getChildElement((Element)repElement, (String)"releases");
                boolean bl = enabled = releasesElement == null || CommonUtils.toBoolean((Object)XMLUtils.getChildElementBody((Element)releasesElement, (String)"enabled"));
                if (!enabled) continue;
                repositories.add(repository);
            }
        }
        return repositories;
    }

    private List<MavenArtifactDependency> parseDependencies(DBRProgressMonitor monitor, Element element, boolean depManagement) {
        ArrayList<MavenArtifactDependency> result = new ArrayList<MavenArtifactDependency>();
        Element dependenciesElement = XMLUtils.getChildElement((Element)element, (String)"dependencies");
        if (dependenciesElement != null) {
            for (Element dep : XMLUtils.getChildElementList((Element)dependenciesElement, (String)"dependency")) {
                List<MavenArtifactReference> dmExclusions;
                String optionalString;
                String groupId = this.evaluateString(XMLUtils.getChildElementBody((Element)dep, (String)"groupId"));
                String artifactId = this.evaluateString(XMLUtils.getChildElementBody((Element)dep, (String)"artifactId"));
                if (groupId == null || artifactId == null) {
                    log.warn((Object)("Broken dependency reference: " + groupId + ":" + artifactId));
                    continue;
                }
                String classifier = this.evaluateString(XMLUtils.getChildElementBody((Element)dep, (String)"classifier"));
                MavenArtifactDependency dmInfo = depManagement ? null : this.findDependencyManagement(groupId, artifactId);
                MavenArtifactDependency.Scope scope = null;
                String scopeName = XMLUtils.getChildElementBody((Element)dep, (String)"scope");
                if (!CommonUtils.isEmpty((String)scopeName)) {
                    try {
                        scope = MavenArtifactDependency.Scope.valueOf(scopeName.toUpperCase(Locale.ENGLISH));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        log.debug((Object)("Bad artifact '" + this.getArtifactId() + "' scope: " + scopeName));
                    }
                }
                if (scope == null && dmInfo != null) {
                    scope = dmInfo.getScope();
                }
                if (scope == null) {
                    scope = MavenArtifactDependency.Scope.COMPILE;
                }
                boolean optional = (optionalString = XMLUtils.getChildElementBody((Element)dep, (String)"optional")) == null ? dmInfo != null && dmInfo.isOptional() : CommonUtils.getBoolean((String)optionalString);
                String version = this.evaluateString(XMLUtils.getChildElementBody((Element)dep, (String)"version"));
                if (depManagement && scope == MavenArtifactDependency.Scope.IMPORT) {
                    if (version == null) {
                        log.error((Object)("Missing imported artifact [" + groupId + ":" + artifactId + "] version. Skip."));
                        continue;
                    }
                    MavenArtifactReference importReference = new MavenArtifactReference(groupId, artifactId, classifier, version);
                    MavenArtifactVersion importedVersion = MavenRegistry.getInstance().findArtifact(monitor, this, importReference);
                    if (importedVersion == null) {
                        log.error((Object)("Imported artifact [" + importReference + "] not found. Skip."));
                    }
                    if (this.imports == null) {
                        this.imports = new ArrayList<MavenArtifactVersion>();
                    }
                    this.imports.add(importedVersion);
                    continue;
                }
                if (!depManagement && (optional || !this.includesScope(scope))) continue;
                if (version == null && dmInfo != null) {
                    version = dmInfo.getVersion();
                }
                if (version == null) {
                    log.error((Object)("Can't resolve artifact [" + groupId + ":" + artifactId + "] version. Skip."));
                    continue;
                }
                MavenArtifactDependency dependency = new MavenArtifactDependency(groupId, artifactId, classifier, version, scope, optional);
                result.add(dependency);
                Element exclusionsElement = XMLUtils.getChildElement((Element)dep, (String)"exclusions");
                if (exclusionsElement != null) {
                    for (Element exclusion : XMLUtils.getChildElementList((Element)exclusionsElement, (String)"exclusion")) {
                        dependency.addExclusion(new MavenArtifactReference(CommonUtils.notEmpty((String)XMLUtils.getChildElementBody((Element)exclusion, (String)"groupId")), CommonUtils.notEmpty((String)XMLUtils.getChildElementBody((Element)exclusion, (String)"artifactId")), null, ""));
                    }
                }
                if (dmInfo == null || (dmExclusions = dmInfo.getExclusions()) == null) continue;
                for (MavenArtifactReference dmEx : dmExclusions) {
                    dependency.addExclusion(dmEx);
                }
            }
        }
        return result;
    }

    private boolean includesScope(MavenArtifactDependency.Scope scope) {
        return scope == MavenArtifactDependency.Scope.COMPILE || scope == MavenArtifactDependency.Scope.RUNTIME;
    }

    private MavenArtifactDependency findDependencyManagement(String groupId, String artifactId) {
        for (MavenProfile profile : this.profiles) {
            if (!profile.isActive() || profile.dependencyManagement == null) continue;
            for (MavenArtifactDependency dmArtifact : profile.dependencyManagement) {
                if (!dmArtifact.getGroupId().equals(groupId) || !dmArtifact.getArtifactId().equals(artifactId)) continue;
                return dmArtifact;
            }
        }
        if (this.imports != null) {
            for (MavenArtifactVersion i : this.imports) {
                MavenArtifactDependency dependencyManagement = i.findDependencyManagement(groupId, artifactId);
                if (dependencyManagement == null) continue;
                return dependencyManagement;
            }
        }
        return this.parent == null ? null : this.parent.findDependencyManagement(groupId, artifactId);
    }

    private String evaluateString(String value) {
        if (value == null) {
            return null;
        }
        return GeneralUtils.replaceVariables((String)value, (IVariableResolver)this.propertyResolver);
    }

    @NotNull
    public Collection<MavenRepository> getActiveRepositories() {
        LinkedHashMap<String, MavenRepository> result = new LinkedHashMap<String, MavenRepository>();
        for (MavenRepository rep : this.repositories) {
            result.put(rep.getId(), rep);
        }
        MavenArtifactVersion v = this;
        while (v != null) {
            for (MavenProfile profile : v.profiles) {
                List<MavenRepository> pr;
                if (!profile.isActive() || (pr = profile.getRepositories()) == null) continue;
                for (MavenRepository repository : pr) {
                    result.put(repository.getId(), repository);
                }
            }
            v = v.parent;
        }
        return result.values();
    }
}

