/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text.codemining.annotation;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.ui.internal.editors.text.codemining.annotation.AnnotationCodeMiningPreferences;
import org.eclipse.ui.texteditor.MarkerAnnotation;

@NonNullByDefault
public class AnnotationCodeMiningFilter {
    private final IAnnotationAccessExtension annotationAccess;
    private final AnnotationCodeMiningPreferences preferences = new AnnotationCodeMiningPreferences();
    private final Stream<Annotation> annotations;

    public AnnotationCodeMiningFilter(IAnnotationAccessExtension annotationAccess, Annotation[] ... annotations) {
        this.annotationAccess = annotationAccess;
        this.annotations = Arrays.stream(annotations).flatMap(Arrays::stream);
    }

    public AnnotationCodeMiningFilter(IAnnotationAccessExtension annotationAccess, Iterator<Annotation> annotations) {
        this.annotationAccess = annotationAccess;
        this.annotations = StreamSupport.stream(Spliterators.spliteratorUnknownSize(annotations, 16), false);
    }

    public boolean isEmpty() {
        return !this.filterReTrigger(this.annotations).findAny().isPresent();
    }

    public Stream<Annotation> sortDistinctLimit(Locator locator) {
        return this.limit(this.distinct(locator, this.sort(locator, this.filterShown(this.filterReTrigger(this.annotations)))));
    }

    private Stream<Annotation> filterReTrigger(Stream<Annotation> anns) {
        return anns.filter(this::isTypeProcessable).filter(this::isPaintable).filter(this::isInScope);
    }

    private boolean isTypeProcessable(Annotation a) {
        return a instanceof MarkerAnnotation || a instanceof IQuickFixableAnnotation || a instanceof IAnnotationPresentation;
    }

    private boolean isPaintable(Annotation a) {
        try {
            return this.annotationAccess.isPaintable(a);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    private boolean isInScope(Annotation a) {
        return this.isError(a) || this.isWarning(a) || this.isInfo(a);
    }

    private Stream<Annotation> filterShown(Stream<Annotation> anns) {
        return anns.filter(a -> !a.isMarkedDeleted()).filter(this::isEnabled);
    }

    private boolean isEnabled(Annotation a) {
        if (this.isError(a)) {
            return this.preferences.isErrorEnabled();
        }
        if (this.isWarning(a)) {
            return this.preferences.isWarningEnabled();
        }
        if (this.isInfo(a)) {
            return this.preferences.isInfoEnabled();
        }
        return false;
    }

    private Stream<Annotation> sort(Locator locator, Stream<Annotation> anns) {
        return anns.sorted((a, b) -> {
            int resultPosition = this.comparePosition(locator, (Annotation)a, (Annotation)b);
            if (resultPosition != 0) {
                return resultPosition;
            }
            int resultLayer = this.compareLayer((Annotation)a, (Annotation)b);
            if (resultLayer != 0) {
                return resultLayer;
            }
            int resultSeverity = this.compareSeverity((Annotation)a, (Annotation)b);
            if (resultSeverity != 0) {
                return resultSeverity;
            }
            return a.getText().compareTo(b.getText());
        });
    }

    private int comparePosition(Locator locator, Annotation a, Annotation b) {
        Integer aOffset = locator.getOffset(a);
        Integer bOffset = locator.getOffset(b);
        if (aOffset == null || bOffset == null) {
            return 0;
        }
        int resultPosition = Integer.compare(aOffset, bOffset);
        return resultPosition;
    }

    private int compareLayer(Annotation a, Annotation b) {
        int resultPriority = Integer.compare(this.annotationAccess.getLayer(a), this.annotationAccess.getLayer(b));
        return resultPriority;
    }

    private int compareSeverity(Annotation a, Annotation b) {
        int resultSeverity = Integer.compare(this.getSeverity(a), this.getSeverity(b));
        return resultSeverity;
    }

    private int getSeverity(Annotation a) {
        if (this.isError(a)) {
            return 2;
        }
        if (this.isWarning(a)) {
            return 1;
        }
        if (this.isInfo(a)) {
            return 0;
        }
        return -1;
    }

    private Stream<Annotation> distinct(Locator locator, Stream<Annotation> anns) {
        return anns.filter(AnnotationCodeMiningFilter.distinctByKey(a -> {
            Integer line = locator.getLine((Annotation)a);
            if (line == null) {
                return null;
            }
            String key = line + a.getText();
            return key;
        })).filter(Objects::nonNull);
    }

    private Stream<Annotation> limit(Stream<Annotation> anns) {
        return anns.limit(this.preferences.getMaxMinings());
    }

    private boolean isInfo(Annotation a) {
        return this.annotationAccess.isSubtype((Object)a.getType(), (Object)"org.eclipse.ui.workbench.texteditor.info");
    }

    private boolean isWarning(Annotation a) {
        return this.annotationAccess.isSubtype((Object)a.getType(), (Object)"org.eclipse.ui.workbench.texteditor.warning");
    }

    private boolean isError(Annotation a) {
        return this.annotationAccess.isSubtype((Object)a.getType(), (Object)"org.eclipse.ui.workbench.texteditor.error");
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        LinkedHashMap seen = new LinkedHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public static interface Locator {
        public @Nullable Integer getOffset(Annotation var1);

        public @Nullable Integer getLine(Annotation var1);
    }
}

