/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.widgets.Display;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.struct.DirectObjectReference;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.model.sql.parser.SQLWordPartDetector;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.runtime.jobs.DataSourceJob;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SQLContextInformer {
    private static final Log log = Log.getLog(SQLContextInformer.class);
    private static final Map<String, Map<String, ObjectLookupCache>> LINKS_CACHE = new HashMap<String, Map<String, ObjectLookupCache>>();
    private final SQLEditorBase editor;
    private SQLSyntaxManager syntaxManager;
    private SQLIdentifierDetector.WordRegion wordRegion;
    private String[] keywords;
    private DBPKeywordType keywordType;
    private List<DBSObjectReference> objectReferences;

    public SQLContextInformer(SQLEditorBase editor, SQLSyntaxManager syntaxManager) {
        this.editor = editor;
        this.syntaxManager = syntaxManager;
    }

    public SQLEditorBase getEditor() {
        return this.editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(SQLSyntaxManager syntaxManager) {
        this.syntaxManager = syntaxManager;
        DBPDataSource dataSource = this.editor.getDataSource();
        if (dataSource != null) {
            Map<String, Map<String, ObjectLookupCache>> map = LINKS_CACHE;
            synchronized (map) {
                LINKS_CACHE.remove(dataSource.getContainer().getId());
            }
        }
    }

    public SQLIdentifierDetector.WordRegion getWordRegion() {
        return this.wordRegion;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public DBPKeywordType getKeywordType() {
        return this.keywordType;
    }

    public synchronized List<DBSObjectReference> getObjectReferences() {
        return this.objectReferences;
    }

    public synchronized boolean hasObjects() {
        return !CommonUtils.isEmpty(this.objectReferences);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchInformation(IRegion region) {
        TextViewer textViewer = this.editor.getTextViewer();
        DBCExecutionContext executionContext = this.editor.getExecutionContext();
        if (region == null || textViewer == null || executionContext == null) {
            return;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return;
        }
        SQLWordPartDetector wordDetector = new SQLWordPartDetector(document, this.syntaxManager, region.getOffset());
        this.wordRegion = wordDetector.detectIdentifier(document, region);
        if (this.wordRegion.word.length() == 0) {
            return;
        }
        String fullName = this.wordRegion.identifier;
        String tableName = this.wordRegion.word;
        boolean caseSensitive = false;
        if (wordDetector.isQuoted(tableName)) {
            tableName = DBUtils.getUnQuotedIdentifier((String)tableName, (String[][])this.syntaxManager.getIdentifierQuoteStrings());
            caseSensitive = true;
        }
        String[] containerNames = null;
        if (!CommonUtils.equalObjects((Object)fullName, (Object)tableName)) {
            String unquotedName;
            int divPos = fullName.indexOf(this.syntaxManager.getStructSeparator());
            if (divPos != -1) {
                Object[] parts = wordDetector.splitIdentifier(fullName);
                tableName = parts[parts.length - 1];
                containerNames = (String[])ArrayUtils.remove(String.class, (Object[])parts, (int)(parts.length - 1));
                int i = 0;
                while (i < containerNames.length) {
                    if (wordDetector.isQuoted(containerNames[i])) {
                        containerNames[i] = DBUtils.getUnQuotedIdentifier((String)containerNames[i], (String[][])this.syntaxManager.getIdentifierQuoteStrings());
                    }
                    containerNames[i] = DBObjectNameCaseTransformer.transformName((DBPDataSource)this.editor.getDataSource(), (String)containerNames[i]);
                    ++i;
                }
                if (wordDetector.isQuoted(tableName)) {
                    tableName = DBUtils.getUnQuotedIdentifier((String)tableName, (String[][])this.syntaxManager.getIdentifierQuoteStrings());
                }
            } else if (wordDetector.isQuoted(fullName) && (unquotedName = DBUtils.getUnQuotedIdentifier((String)tableName, (String[][])this.syntaxManager.getIdentifierQuoteStrings())).equals(tableName)) {
                caseSensitive = true;
            }
        }
        SQLDialect dialect = this.syntaxManager.getDialect();
        this.keywordType = dialect.getKeywordType(fullName);
        if (this.keywordType == DBPKeywordType.KEYWORD && region.getLength() > 1) {
            try {
                fullName = document.get(region.getOffset(), region.getLength());
            }
            catch (BadLocationException e) {
                log.warn((Object)e);
            }
        }
        this.keywords = new String[]{fullName};
        if (this.keywordType == DBPKeywordType.KEYWORD || this.keywordType == DBPKeywordType.FUNCTION) {
            return;
        }
        Map<String, ObjectLookupCache> contextCache = this.getLinksCache();
        if (contextCache == null) {
            return;
        }
        ObjectLookupCache tlc = contextCache.get(fullName);
        if (tlc == null) {
            tlc = new ObjectLookupCache();
            contextCache.put(fullName, tlc);
            DBSStructureAssistant structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)this.editor.getDataSource());
            TablesFinderJob job = new TablesFinderJob(executionContext, structureAssistant, containerNames, tableName, caseSensitive, tlc);
            job.schedule();
        }
        if (tlc.loading) {
            int i = 0;
            while (i < 20) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (!tlc.loading) break;
                Display.getCurrent().readAndDispatch();
                ++i;
            }
        }
        if (!tlc.loading) {
            SQLContextInformer sQLContextInformer = this;
            synchronized (sQLContextInformer) {
                this.objectReferences = tlc.references;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ObjectLookupCache> getLinksCache() {
        DBPDataSource dataSource = this.editor.getDataSource();
        if (dataSource == null) {
            return null;
        }
        final DBPDataSourceContainer container = dataSource.getContainer();
        Map<String, Map<String, ObjectLookupCache>> map = LINKS_CACHE;
        synchronized (map) {
            Map<String, ObjectLookupCache> cacheMap = LINKS_CACHE.get(container.getId());
            if (cacheMap == null) {
                cacheMap = new HashMap<String, ObjectLookupCache>();
                LINKS_CACHE.put(container.getId(), cacheMap);
                final DBPDataSourceRegistry registry = container.getRegistry();
                DBPEventListener dbpEventListener = new DBPEventListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleDataSourceEvent(DBPEvent event) {
                        if (event.getAction() == DBPEvent.Action.OBJECT_UPDATE && Boolean.FALSE.equals(event.getEnabled())) {
                            Map map = LINKS_CACHE;
                            synchronized (map) {
                                LINKS_CACHE.remove(container.getId());
                                registry.removeDataSourceListener((DBPEventListener)this);
                            }
                        }
                    }
                };
                registry.addDataSourceListener(dbpEventListener);
                this.editor.getEditorControl().addDisposeListener(e -> {
                    boolean bl = registry.removeDataSourceListener(dbpEventListener);
                });
            }
            return cacheMap;
        }
    }

    static /* synthetic */ SQLEditorBase access$0(SQLContextInformer sQLContextInformer) {
        return sQLContextInformer.editor;
    }

    static /* synthetic */ Log access$1() {
        return log;
    }

    private static class ObjectLookupCache {
        List<DBSObjectReference> references;
        boolean loading = true;

        private ObjectLookupCache() {
        }
    }

    private class TablesFinderJob
    extends DataSourceJob {
        private final DBSStructureAssistant structureAssistant;
        private final String[] containerNames;
        private final String objectName;
        private final ObjectLookupCache cache;
        private final boolean caseSensitive;

        protected TablesFinderJob(@Nullable DBCExecutionContext executionContext, @Nullable DBSStructureAssistant structureAssistant, @NotNull String[] containerNames, String objectName, @NotNull boolean caseSensitive, ObjectLookupCache cache) {
            super("Find object '" + objectName + "'", executionContext);
            this.structureAssistant = structureAssistant;
            this.containerNames = containerNames;
            this.objectName = objectName;
            this.caseSensitive = caseSensitive;
            this.cache = cache;
            this.setUser(false);
            this.setSystem(true);
        }

        /*
         * Unable to fully structure code
         */
        protected IStatus run(DBRProgressMonitor monitor) {
            this.cache.references = new ArrayList<DBSObjectReference>();
            try {
                block24: {
                    container = null;
                    if (ArrayUtils.isEmpty((Object[])this.containerNames) || (dsContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)this.getExecutionContext().getDataSource())) == null) ** GOTO lbl23
                    contextDefaults = this.getExecutionContext().getContextDefaults();
                    childContainer = dsContainer.getChild(monitor, this.containerNames[0]);
                    if (childContainer == null && contextDefaults != null && contextDefaults.getDefaultCatalog() != null) {
                        childContainer = contextDefaults.getDefaultCatalog().getChild(monitor, this.containerNames[0]);
                    }
                    if (!(childContainer instanceof DBSObjectContainer)) break block24;
                    container = (DBSObjectContainer)childContainer;
                    ** GOTO lbl23
                }
                if (childContainer == null && this.structureAssistant != null && (executionContext = SQLContextInformer.access$0(SQLContextInformer.this).getExecutionContext()) != null) {
                    objReferences = this.structureAssistant.findObjectsByMask(monitor, executionContext, null, this.structureAssistant.getAutoCompleteObjectTypes(), this.containerNames[0], false, true, 1);
                    if (objReferences.size() == 1) {
                        childContainer = ((DBSObjectReference)objReferences.get(0)).resolveObject(monitor);
                    }
                    if (childContainer == null) {
                        var9_10 = Status.CANCEL_STATUS;
                        return var9_10;
                    }
                }
                try {
                    if (childContainer instanceof DBSObjectContainer) {
                        container = (DBSObjectContainer)childContainer;
                    }
lbl23:
                    // 5 sources

                    if (container != null) {
                        if (this.containerNames.length > 1) {
                            i = 1;
                            while (i < this.containerNames.length) {
                                childContainer = container.getChild(monitor, this.containerNames[i]);
                                if (childContainer instanceof DBSObjectContainer) {
                                    container = (DBSObjectContainer)childContainer;
                                    ++i;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            childContainer = container.getChild(monitor, this.containerNames[0]);
                            if (childContainer instanceof DBSObjectContainer) {
                                container = (DBSObjectContainer)childContainer;
                            }
                        }
                    }
                    targetObject = null;
                    if (container != null && (fixedName = DBObjectNameCaseTransformer.transformName((DBPDataSource)this.getExecutionContext().getDataSource(), (String)this.objectName)) != null) {
                        targetObject = container.getChild(monitor, fixedName);
                    }
                    if (targetObject != null) {
                        this.cache.references.add((DBSObjectReference)new DirectObjectReference(container, null, targetObject));
                    } else if (this.structureAssistant != null) {
                        objectTypes = this.structureAssistant.getHyperlinkObjectTypes();
                        executionContext = SQLContextInformer.access$0(SQLContextInformer.this).getExecutionContext();
                        if (executionContext != null && !CommonUtils.isEmpty((Collection)(objects = this.structureAssistant.findObjectsByMask(monitor, executionContext, (DBSObject)container, objectTypes, this.objectName, this.caseSensitive, false, 10)))) {
                            this.cache.references.addAll(objects);
                        }
                    }
                }
                catch (DBException e) {
                    SQLContextInformer.access$1().warn((Object)e);
                }
            }
            finally {
                this.cache.loading = false;
            }
            return Status.OK_STATUS;
        }
    }
}

