/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Index;
import org.jkiss.dbeaver.ext.db2.model.DB2TableBase;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2View;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2IndexColOrder;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2IndexColVirtual;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableIndexColumn;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class DB2IndexColumn
extends AbstractTableIndexColumn {
    private static final String I_DEP = "SELECT BSCHEMA,BNAME FROM SYSCAT.INDEXDEP WHERE INDSCHEMA = ? AND INDNAME = ? AND BTYPE = 'V' WITH UR";
    private DB2Index db2Index;
    private DB2TableColumn tableColumn;
    private Integer colSeq;
    private DB2IndexColOrder colOrder;
    private String collationSchema;
    private String collationNane;
    private DB2IndexColVirtual virtualCol;
    private String virtualColName;
    private String virtualColText;

    public DB2IndexColumn(DBRProgressMonitor monitor, DB2Index db2Index, ResultSet dbResult) throws DBException {
        DB2DataSource db2DataSource = db2Index.getDataSource();
        this.db2Index = db2Index;
        this.colSeq = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"COLSEQ");
        this.colOrder = (DB2IndexColOrder)CommonUtils.valueOf(DB2IndexColOrder.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLORDER"));
        if (db2DataSource.isAtLeastV9_5()) {
            this.collationSchema = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"COLLATIONSCHEMA");
            this.collationNane = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLLATIONNAME");
        }
        if (db2DataSource.isAtLeastV10_1()) {
            this.virtualCol = (DB2IndexColVirtual)CommonUtils.valueOf(DB2IndexColVirtual.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"VIRTUAL"));
            this.virtualColText = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TEXT");
        }
        DB2TableBase db2Table = (DB2TableBase)db2Index.getTable();
        String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLNAME");
        if (this.virtualCol == null || this.virtualCol.isNotVirtual().booleanValue()) {
            this.tableColumn = db2Table.getAttribute(monitor, columnName);
            if (this.tableColumn == null) {
                throw new DBException("Column '" + columnName + "' not found in table '" + db2Table.getName() + "' for index '" + db2Index.getName() + "'");
            }
        } else {
            this.virtualColName = columnName;
            DB2View viewDep = this.getDependentView(monitor, db2DataSource, db2Index.getIndSchema().getName().trim(), db2Index.getName());
            if (viewDep != null) {
                this.tableColumn = viewDep.getAttribute(monitor, columnName);
            }
        }
    }

    public DB2IndexColumn(DB2Index db2Index, DB2TableColumn tableColumn, int ordinalPosition, boolean ascending) {
        this.db2Index = db2Index;
        this.tableColumn = tableColumn;
        this.colSeq = ordinalPosition;
        this.colOrder = ascending ? DB2IndexColOrder.A : DB2IndexColOrder.D;
        this.virtualCol = DB2IndexColVirtual.N;
    }

    /*
     * Exception decompiling
     */
    private DB2View getDependentView(DBRProgressMonitor monitor, DB2DataSource db2DataSource, String indexSchema, String indexName) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    public DB2DataSource getDataSource() {
        return this.db2Index.getDataSource();
    }

    public DB2Index getParentObject() {
        return this.db2Index;
    }

    @NotNull
    public DB2Index getIndex() {
        return this.db2Index;
    }

    @Nullable
    public String getDescription() {
        if (this.virtualCol == null || this.virtualCol.isNotVirtual().booleanValue()) {
            return this.tableColumn.getDescription();
        }
        return this.virtualCol.getName();
    }

    public int getOrdinalPosition() {
        return this.colSeq;
    }

    public boolean isAscending() {
        return this.colOrder.isAscending();
    }

    @NotNull
    public String getName() {
        if (this.virtualCol != null && this.virtualCol.isVirtual().booleanValue()) {
            return this.virtualColName;
        }
        return this.tableColumn.getName();
    }

    @Property(viewable=true, order=1, id="name")
    @Nullable
    public DB2TableColumn getTableColumn() {
        return this.tableColumn;
    }

    @Property(viewable=true, editable=false, order=2, id="indSchema")
    public Integer getColSeq() {
        return this.colSeq;
    }

    @Property(viewable=true, editable=true, order=3, id="table")
    public DB2IndexColOrder getColOrder() {
        return this.colOrder;
    }

    @Property(viewable=true, editable=false, order=4, id="indexType")
    public DB2IndexColVirtual getVirtualCol() {
        return this.virtualCol;
    }

    @Property(viewable=true, editable=false, order=5)
    public String getVirtualColText() {
        return this.virtualColText;
    }

    @Property(viewable=false, editable=false, category="Collation")
    public String getCollationSchema() {
        return this.collationSchema;
    }

    @Property(viewable=false, editable=false, category="Collation")
    public String getCollationNane() {
        return this.collationNane;
    }
}

