/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.MultiStringMatcher;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleDocumentPartitionerExtension;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.internal.console.IOConsolePartition;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class IOConsolePartitioner
implements IConsoleDocumentPartitioner,
IConsoleDocumentPartitionerExtension,
IDocumentPartitionerExtension {
    private static final boolean ASSERT = false;
    private static final Comparator<IRegion> CMP_REGION_BY_OFFSET = Comparator.comparing(IRegion::getOffset);
    private static final String CONTROL_CHARACTERS_PATTERN_STR = "(?:\b+)";
    private static final String CONTROL_CHARACTERS_WITH_CR_PATTERN_STR = "(?:\b+|\r+(?!\n))";
    private IDocument document;
    private final ArrayList<IOConsolePartition> partitions = new ArrayList();
    private final ArrayList<PendingPartition> pendingPartitions = new ArrayList();
    private int pendingSize;
    private final QueueProcessingJob queueJob = new QueueProcessingJob();
    private final TrimJob trimJob = new TrimJob();
    private DocUpdateType updateType = DocUpdateType.INPUT;
    private IRegion changedRegion;
    private ArrayList<IOConsolePartition> inputPartitions;
    private MultiStringMatcher legalLineDelimiterMatcher;
    private int highWaterMark = -1;
    private int lowWaterMark = -1;
    private IOConsole console;
    private volatile boolean streamsClosed;
    private Pattern controlCharacterPattern = null;
    private boolean carriageReturnAsControlCharacter = true;
    private int outputOffset = 0;

    public IOConsolePartitioner(IOConsole console) {
        this.console = Objects.requireNonNull(console);
        this.queueJob.setRule(console.getSchedulingRule());
        this.trimJob.setRule(console.getSchedulingRule());
    }

    public IDocument getDocument() {
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(IDocument doc) {
        if (doc == this.document) {
            return;
        }
        this.disconnect();
        if (doc != null) {
            ArrayList<IOConsolePartition> arrayList = this.partitions;
            synchronized (arrayList) {
                this.inputPartitions = new ArrayList();
                this.document = doc;
                this.legalLineDelimiterMatcher = MultiStringMatcher.create((String[])this.document.getLegalLineDelimiters());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        ArrayList<Object> arrayList = this.pendingPartitions;
        synchronized (arrayList) {
            this.pendingPartitions.clear();
            this.pendingSize = 0;
            this.pendingPartitions.notifyAll();
        }
        arrayList = this.partitions;
        synchronized (arrayList) {
            this.trimJob.cancel();
            this.queueJob.cancel();
            this.legalLineDelimiterMatcher = null;
            this.document = null;
            this.inputPartitions = null;
            this.partitions.clear();
        }
    }

    public int getHighWaterMark() {
        return this.highWaterMark;
    }

    public int getLowWaterMark() {
        return this.lowWaterMark;
    }

    public void setWaterMarks(int low, int high) {
        this.lowWaterMark = low;
        this.highWaterMark = high;
        ConsolePlugin.getStandardDisplay().asyncExec(this::checkBufferSize);
    }

    public void streamsClosed() {
        if (this.streamsClosed) {
            IOConsolePartitioner.log(4, "Streams are already closed.");
            return;
        }
        this.streamsClosed = true;
        this.checkFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFinished() {
        if (this.streamsClosed) {
            boolean morePending;
            ArrayList<PendingPartition> arrayList = this.pendingPartitions;
            synchronized (arrayList) {
                morePending = !this.pendingPartitions.isEmpty();
            }
            if (morePending) {
                this.queueJob.schedule();
            } else {
                this.console.partitionerFinished();
            }
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        return this.documentChanged2(event) != null;
    }

    public String[] getLegalContentTypes() {
        return new String[]{IOConsolePartition.OUTPUT_PARTITION_TYPE, IOConsolePartition.INPUT_PARTITION_TYPE};
    }

    public String getContentType(int offset) {
        return this.getPartition(offset).getType();
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        return this.computeIOPartitioning(offset, length);
    }

    private IOConsolePartition[] computeIOPartitioning(int offset, int length) {
        return this.computePartitioning(offset, length, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IOConsolePartition[] computePartitioning(int offset, int length, boolean includeWritable, boolean includeReadOnly) {
        ArrayList<IOConsolePartition> result = new ArrayList<IOConsolePartition>();
        ArrayList<IOConsolePartition> arrayList = this.partitions;
        synchronized (arrayList) {
            int index = this.findPartitionCandidate(offset);
            if (index < 0) {
                index = 0;
            }
            int end = offset + length;
            while (index < this.partitions.size()) {
                IOConsolePartition partition = this.partitions.get(index);
                if (partition.getOffset() >= end) break;
                if (includeWritable && !partition.isReadOnly() || includeReadOnly && partition.isReadOnly()) {
                    result.add(partition);
                }
                ++index;
            }
        }
        return result.toArray(new IOConsolePartition[0]);
    }

    public ITypedRegion getPartition(int offset) {
        IOConsolePartition partition = this.getIOPartition(offset);
        return partition != null ? partition : new TypedRegion(offset, 0, IOConsolePartition.INPUT_PARTITION_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IOConsolePartition getIOPartition(int offset) {
        ArrayList<IOConsolePartition> arrayList = this.partitions;
        synchronized (arrayList) {
            IOConsolePartition partition;
            int index = this.findPartitionCandidate(offset);
            if (index >= 0 && (partition = this.partitions.get(index)).getOffset() + partition.getLength() > offset) {
                return partition;
            }
            return null;
        }
    }

    private int findPartitionCandidate(int offset) {
        Region target = new Region(offset, 0);
        int index = Collections.binarySearch(this.partitions, target, CMP_REGION_BY_OFFSET);
        if (index >= 0) {
            return index;
        }
        return -index - 2;
    }

    private void checkBufferSize() {
        int length;
        if (this.document != null && this.highWaterMark > 0 && (length = this.document.getLength()) > this.highWaterMark && this.trimJob.getState() == 0) {
            this.trimJob.setOffset(length - this.lowWaterMark);
            this.trimJob.schedule();
        }
    }

    public void clearBuffer() {
        this.trimJob.setOffset(-1);
        this.trimJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRegion documentChanged2(DocumentEvent event) {
        if (this.document != event.getDocument()) {
            IOConsolePartitioner.log(2, "IOConsolePartitioner is connected to wrong document.");
            this.updateType = DocUpdateType.INPUT;
            return null;
        }
        {
            block22: {
                catch (Throwable throwable) {
                    this.updateType = DocUpdateType.INPUT;
                    throw throwable;
                }
                {
                    if (this.document.getLength() != 0) break block22;
                    ArrayList<IOConsolePartition> arrayList = this.partitions;
                    synchronized (arrayList) {
                        this.partitions.clear();
                        this.inputPartitions.clear();
                        this.outputOffset = 0;
                    }
                    Region region = new Region(0, 0);
                    this.updateType = DocUpdateType.INPUT;
                    return region;
                }
            }
            ArrayList<IOConsolePartition> arrayList = this.partitions;
            synchronized (arrayList) {
                try {
                    switch (this.updateType) {
                        case INPUT: {
                            if (event.getOffset() <= this.outputOffset) {
                                this.outputOffset -= Math.min(event.getLength(), this.outputOffset - event.getOffset());
                                if (event.getText() != null) {
                                    this.outputOffset += event.getText().length();
                                }
                            }
                            IRegion iRegion = this.applyUserInput(event);
                            // MONITOREXIT @DISABLED, blocks:[17, 4, 10, 11, 12] lbl35 : MonitorExitStatement: MONITOREXIT : var2_3
                            this.updateType = DocUpdateType.INPUT;
                            return iRegion;
                        }
                        case OUTPUT: {
                            IRegion iRegion = this.changedRegion;
                            // MONITOREXIT @DISABLED, blocks:[17, 4, 10, 11, 13] lbl40 : MonitorExitStatement: MONITOREXIT : var2_3
                            this.updateType = DocUpdateType.INPUT;
                            return iRegion;
                        }
                        case TRIM: {
                            // MONITOREXIT @DISABLED, blocks:[17, 4, 10, 11, 14] lbl44 : MonitorExitStatement: MONITOREXIT : var2_3
                            this.updateType = DocUpdateType.INPUT;
                            return null;
                        }
                    }
                }
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
                IOConsolePartitioner.log(4, "Invalid enum value " + (Object)((Object)this.updateType));
                // MONITOREXIT @DISABLED, blocks:[17, 7, 10] lbl50 : MonitorExitStatement: MONITOREXIT : var2_3
                this.updateType = DocUpdateType.INPUT;
                return null;
            }
        }
    }

    private IRegion applyUserInput(DocumentEvent event) {
        IOConsolePartition partition;
        int eventPartitionIndex;
        int eventTextLength = event.getText() != null ? event.getText().length() : 0;
        int offset = event.getOffset();
        int amountDeleted = event.getLength();
        IOConsoleInputStream inputStream = this.console.getInputStream();
        if (amountDeleted == 0 && eventTextLength == 0) {
            return null;
        }
        int lastPartitionWithValidOffset = eventPartitionIndex = this.findPartitionCandidate(offset);
        if (amountDeleted > 0 && eventPartitionIndex >= 0) {
            int toDelete = amountDeleted;
            int i = eventPartitionIndex;
            while (i < this.partitions.size() && toDelete > 0) {
                partition = this.partitions.get(i);
                int removeLength = Math.min(partition.getLength(), toDelete);
                partition.setLength(partition.getLength() - removeLength);
                toDelete -= removeLength;
                ++i;
            }
            --lastPartitionWithValidOffset;
        }
        if (eventTextLength > 0) {
            int inputPartitionIndex = eventPartitionIndex;
            IOConsolePartition inputPartition = this.getPartitionByIndex(inputPartitionIndex);
            if (inputPartition != null && inputPartition.isReadOnly() && offset == inputPartition.getOffset()) {
                --lastPartitionWithValidOffset;
                inputPartition = this.getPartitionByIndex(--inputPartitionIndex);
            }
            int textOffset = 0;
            while (textOffset < eventTextLength) {
                MultiStringMatcher.Match nextNewline = this.legalLineDelimiterMatcher.indexOf((CharSequence)event.getText(), textOffset);
                int newTextOffset = nextNewline != null ? nextNewline.getOffset() + nextNewline.getText().length() : eventTextLength;
                int inputLength = newTextOffset - textOffset;
                if (inputPartition == null || inputPartition.isReadOnly()) {
                    int inputOffset = offset + textOffset;
                    if (inputPartition != null && inputOffset < inputPartition.getOffset() + inputPartition.getLength()) {
                        this.splitPartition(inputOffset);
                    }
                    inputPartition = new IOConsolePartition(inputOffset, inputStream);
                    this.partitions.add(++inputPartitionIndex, inputPartition);
                    this.inputPartitions.add(inputPartition);
                    ++lastPartitionWithValidOffset;
                }
                inputPartition.setLength(inputPartition.getLength() + inputLength);
                if (nextNewline != null) {
                    this.inputPartitions.sort(CMP_REGION_BY_OFFSET);
                    StringBuilder inputLine = new StringBuilder();
                    for (IOConsolePartition p : this.inputPartitions) {
                        try {
                            String fragment = this.document.get(p.getOffset(), p.getLength());
                            inputLine.append(fragment);
                        }
                        catch (BadLocationException e) {
                            IOConsolePartitioner.log(e);
                        }
                        p.setReadOnly();
                    }
                    this.inputPartitions.clear();
                    if (inputStream != null) {
                        inputStream.appendData(inputLine.toString());
                    }
                }
                Assert.isTrue((newTextOffset > textOffset ? 1 : 0) != 0);
                textOffset = newTextOffset;
            }
        }
        int newOffset = 0;
        if (lastPartitionWithValidOffset >= 0) {
            IOConsolePartition partition2 = this.partitions.get(lastPartitionWithValidOffset);
            newOffset = partition2.getOffset() + partition2.getLength();
        }
        ListIterator<IOConsolePartition> it = this.partitions.listIterator(lastPartitionWithValidOffset + 1);
        while (it.hasNext()) {
            partition = (IOConsolePartition)it.next();
            if (partition.getLength() <= 0) {
                it.remove();
                if (!IOConsolePartitioner.isInputPartition(partition)) continue;
                boolean bl = this.inputPartitions.remove(partition);
                continue;
            }
            partition.setOffset(newOffset);
            newOffset += partition.getLength();
        }
        return new Region(0, this.document.getLength());
    }

    private IOConsolePartition splitPartition(int offset) {
        IOConsolePartition newPartition;
        int partitionIndex = this.findPartitionCandidate(offset);
        IOConsolePartition existingPartition = this.partitions.get(partitionIndex);
        if (IOConsolePartitioner.isInputPartition(existingPartition)) {
            newPartition = new IOConsolePartition(offset, existingPartition.getInputStream());
            if (existingPartition.isReadOnly()) {
                newPartition.setReadOnly();
            }
            if (this.inputPartitions.contains(existingPartition)) {
                this.inputPartitions.add(newPartition);
            }
        } else {
            newPartition = new IOConsolePartition(offset, existingPartition.getOutputStream());
        }
        newPartition.setLength(existingPartition.getOffset() + existingPartition.getLength() - offset);
        existingPartition.setLength(offset - existingPartition.getOffset());
        this.partitions.add(partitionIndex + 1, newPartition);
        return newPartition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamAppended(IOConsoleOutputStream stream, String s) throws IOException {
        if (this.document == null) {
            throw new IOException("Document is closed");
        }
        if (s == null) {
            return;
        }
        ArrayList<PendingPartition> arrayList = this.pendingPartitions;
        synchronized (arrayList) {
            PendingPartition lastPending;
            PendingPartition pendingPartition = lastPending = this.pendingPartitions.size() > 0 ? this.pendingPartitions.get(this.pendingPartitions.size() - 1) : null;
            if (lastPending != null && lastPending.stream == stream) {
                lastPending.append(s);
            } else {
                this.pendingPartitions.add(new PendingPartition(stream, s));
            }
            if (this.pendingSize > 1000) {
                this.queueJob.schedule();
            } else {
                this.queueJob.schedule(50L);
            }
            if (this.pendingSize > 160000) {
                if (Display.getCurrent() == null) {
                    try {
                        this.pendingPartitions.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    this.processPendingPartitions();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingPartitions() {
        int size;
        ArrayList<PendingPartition> pendingCopy;
        ArrayList<Object> arrayList = this.pendingPartitions;
        synchronized (arrayList) {
            pendingCopy = new ArrayList<PendingPartition>(this.pendingPartitions);
            size = this.pendingSize;
            this.pendingPartitions.clear();
            this.pendingSize = 0;
            this.pendingPartitions.notifyAll();
        }
        arrayList = this.partitions;
        synchronized (arrayList) {
            if (this.isHandleControlCharacters()) {
                this.applyStreamOutput(pendingCopy, size);
            } else {
                StringBuilder addedContent = new StringBuilder(size);
                IOConsolePartition lastPartition = this.getPartitionByIndex(this.partitions.size() - 1);
                int nextOffset = this.document.getLength();
                for (PendingPartition pendingPartition : pendingCopy) {
                    if (lastPartition == null || lastPartition.getOutputStream() != pendingPartition.stream) {
                        lastPartition = new IOConsolePartition(nextOffset, pendingPartition.stream);
                        this.partitions.add(lastPartition);
                    }
                    int pendingLength = pendingPartition.text.length();
                    lastPartition.setLength(lastPartition.getLength() + pendingLength);
                    nextOffset += pendingLength;
                    addedContent.append((CharSequence)pendingPartition.text);
                }
                try {
                    this.updateType = DocUpdateType.OUTPUT;
                    this.document.replace(this.document.getLength(), 0, addedContent.toString());
                    this.outputOffset += addedContent.length();
                }
                catch (BadLocationException e) {
                    IOConsolePartitioner.log(e);
                }
            }
        }
        this.checkFinished();
        this.checkBufferSize();
    }

    private void applyStreamOutput(List<PendingPartition> pendingCopy, int sizeHint) {
        Pattern controlPattern = this.controlCharacterPattern;
        int nextWriteOffset = this.outputOffset;
        StringBuilder content = new StringBuilder(sizeHint);
        int replaceLength = 0;
        IOConsolePartition atOutputPartition = null;
        int atOutputPartitionIndex = -1;
        for (PendingPartition pending : pendingCopy) {
            Matcher controlCharacterMatcher = controlPattern != null ? controlPattern.matcher(pending.text) : null;
            int textOffset = 0;
            while (textOffset < pending.text.length()) {
                boolean foundControlCharacter;
                int partEnd;
                if (controlCharacterMatcher != null && controlCharacterMatcher.find()) {
                    partEnd = controlCharacterMatcher.start();
                    foundControlCharacter = true;
                } else {
                    partEnd = pending.text.length();
                    foundControlCharacter = false;
                }
                while (textOffset < partEnd) {
                    if (this.outputOffset >= this.document.getLength()) {
                        if (atOutputPartition == null) {
                            atOutputPartitionIndex = this.partitions.size() - 1;
                            atOutputPartition = this.getPartitionByIndex(atOutputPartitionIndex);
                        }
                        if (atOutputPartition == null || atOutputPartition.getOutputStream() != pending.stream) {
                            atOutputPartition = new IOConsolePartition(this.outputOffset, pending.stream);
                            this.partitions.add(atOutputPartition);
                            atOutputPartitionIndex = this.partitions.size() - 1;
                        }
                        int appendedLength = partEnd - textOffset;
                        content.append(pending.text, textOffset, partEnd);
                        atOutputPartition.setLength(atOutputPartition.getLength() + appendedLength);
                        this.outputOffset += appendedLength;
                        textOffset = partEnd;
                        continue;
                    }
                    if (atOutputPartition == null && (atOutputPartition = this.getPartitionByIndex(atOutputPartitionIndex = this.findPartitionCandidate(this.outputOffset))) == null) {
                        atOutputPartition = new IOConsolePartition(this.outputOffset, pending.stream);
                        this.partitions.add(++atOutputPartitionIndex, atOutputPartition);
                    }
                    if (IOConsolePartitioner.isInputPartition(atOutputPartition)) {
                        this.outputOffset = atOutputPartition.getOffset() + atOutputPartition.getLength();
                        atOutputPartition = this.getPartitionByIndex(++atOutputPartitionIndex);
                        this.applyOutputToDocument(content.toString(), nextWriteOffset, replaceLength);
                        content.setLength(0);
                        replaceLength = 0;
                        nextWriteOffset = this.outputOffset;
                        continue;
                    }
                    int chunkLength = Math.min(partEnd - textOffset, atOutputPartition.getLength() - (this.outputOffset - atOutputPartition.getOffset()));
                    Assert.isTrue((chunkLength > 0 ? 1 : 0) != 0);
                    if (atOutputPartition.getOutputStream() != pending.stream) {
                        IOConsolePartition outputPartition = null;
                        if (atOutputPartition.getOffset() == this.outputOffset) {
                            outputPartition = this.getPartitionByIndex(atOutputPartitionIndex - 1);
                        } else {
                            atOutputPartition = this.splitPartition(this.outputOffset);
                            ++atOutputPartitionIndex;
                        }
                        if (outputPartition == null || outputPartition.getOutputStream() != pending.stream) {
                            outputPartition = new IOConsolePartition(this.outputOffset, pending.stream);
                            this.partitions.add(atOutputPartitionIndex, outputPartition);
                            ++atOutputPartitionIndex;
                        }
                        outputPartition.setLength(outputPartition.getLength() + chunkLength);
                        atOutputPartition.setOffset(atOutputPartition.getOffset() + chunkLength);
                        atOutputPartition.setLength(atOutputPartition.getLength() - chunkLength);
                        if (atOutputPartition.getLength() == 0) {
                            this.partitions.remove(atOutputPartitionIndex);
                            atOutputPartition = this.getPartitionByIndex(atOutputPartitionIndex);
                        }
                    }
                    content.append(pending.text, textOffset, textOffset + chunkLength);
                    replaceLength += chunkLength;
                    textOffset += chunkLength;
                    this.outputOffset += chunkLength;
                    if (atOutputPartition == null || this.outputOffset != atOutputPartition.getOffset() + atOutputPartition.getLength()) continue;
                    atOutputPartition = this.getPartitionByIndex(++atOutputPartitionIndex);
                }
                if (controlCharacterMatcher == null || !foundControlCharacter) continue;
                this.applyOutputToDocument(content.toString(), nextWriteOffset, replaceLength);
                content.setLength(0);
                replaceLength = 0;
                String controlCharacterMatch = controlCharacterMatcher.group();
                char controlCharacter = controlCharacterMatch.charAt(0);
                switch (controlCharacter) {
                    case '\b': {
                        int outputLineStartOffset = this.findOutputLineStartOffset(this.outputOffset);
                        int backStepCount = controlCharacterMatch.length();
                        if (this.partitions.size() == 0) {
                            this.outputOffset = 0;
                            break;
                        }
                        if (atOutputPartition == null) {
                            atOutputPartitionIndex = this.partitions.size() - 1;
                            atOutputPartition = this.getPartitionByIndex(atOutputPartitionIndex);
                        }
                        while (backStepCount > 0 && this.outputOffset > outputLineStartOffset) {
                            if (atOutputPartition != null && IOConsolePartitioner.isInputPartition(atOutputPartition)) {
                                do {
                                    this.outputOffset = atOutputPartition.getOffset() - 1;
                                } while ((atOutputPartition = this.getPartitionByIndex(--atOutputPartitionIndex)) != null && IOConsolePartitioner.isInputPartition(atOutputPartition));
                                --backStepCount;
                            }
                            if (atOutputPartition == null) {
                                this.outputOffset = 0;
                                break;
                            }
                            int backSteps = Math.min(this.outputOffset - atOutputPartition.getOffset(), backStepCount);
                            this.outputOffset -= backSteps;
                            backStepCount -= backSteps;
                            atOutputPartition = this.getPartitionByIndex(--atOutputPartitionIndex);
                        }
                        this.outputOffset = Math.max(this.outputOffset, outputLineStartOffset);
                        break;
                    }
                    case '\r': {
                        this.outputOffset = this.findOutputLineStartOffset(this.outputOffset);
                        atOutputPartitionIndex = -1;
                        atOutputPartition = null;
                        break;
                    }
                    default: {
                        IOConsolePartitioner.log(4, "No implementation to handle control character 0x" + Integer.toHexString(controlCharacter));
                    }
                }
                nextWriteOffset = this.outputOffset;
                textOffset = controlCharacterMatcher.end();
            }
        }
        this.applyOutputToDocument(content.toString(), nextWriteOffset, replaceLength);
    }

    private int findOutputLineStartOffset(int outOffset) {
        int outputLineStartOffset = 0;
        try {
            int lineIndex = this.document.getLineOfOffset(outOffset);
            while (lineIndex >= 0) {
                outputLineStartOffset = this.document.getLineOffset(lineIndex);
                IOConsolePartition lineBreakPartition = this.getIOPartition(outputLineStartOffset - 1);
                if (lineBreakPartition != null && IOConsolePartitioner.isInputPartition(lineBreakPartition)) {
                    --lineIndex;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            IOConsolePartitioner.log(e);
            outputLineStartOffset = 0;
        }
        return outputLineStartOffset;
    }

    private void applyOutputToDocument(String content, int offset, int replaceLength) {
        if (content.length() > 0 || replaceLength > 0) {
            try {
                this.updateType = DocUpdateType.OUTPUT;
                this.document.replace(offset, replaceLength, content);
            }
            catch (BadLocationException e) {
                IOConsolePartitioner.log(e);
            }
        }
    }

    @Override
    public boolean isReadOnly(int offset) {
        IOConsolePartition partition = this.getIOPartition(offset);
        return partition != null ? partition.isReadOnly() : true;
    }

    @Override
    public StyleRange[] getStyleRanges(int offset, int length) {
        IOConsolePartition[] computedPartitions = this.computeIOPartitioning(offset, length);
        StyleRange[] styles = new StyleRange[computedPartitions.length];
        int i = 0;
        while (i < computedPartitions.length) {
            int overflow;
            int rangeStart = computedPartitions[i].getOffset();
            int rangeLength = computedPartitions[i].getLength();
            int underflow = offset - rangeStart;
            if (underflow > 0) {
                rangeStart += underflow;
                rangeLength -= underflow;
            }
            if ((overflow = rangeStart + rangeLength - (offset + length)) > 0) {
                rangeLength -= overflow;
            }
            styles[i] = computedPartitions[i].getStyleRange(rangeStart, rangeLength);
            ++i;
        }
        return styles;
    }

    @Override
    public ITypedRegion[] computeReadOnlyPartitions() {
        if (this.document == null) {
            return new IOConsolePartition[0];
        }
        return this.computeReadOnlyPartitions(0, this.document.getLength());
    }

    @Override
    public ITypedRegion[] computeReadOnlyPartitions(int offset, int length) {
        return this.computePartitioning(offset, length, false, true);
    }

    @Override
    public ITypedRegion[] computeWritablePartitions() {
        if (this.document == null) {
            return new IOConsolePartition[0];
        }
        return this.computeWritablePartitions(0, this.document.getLength());
    }

    @Override
    public ITypedRegion[] computeWritablePartitions(int offset, int length) {
        return this.computePartitioning(offset, length, true, false);
    }

    @Override
    public boolean isReadOnly(int offset, int length) {
        ITypedRegion[] readOnlyRegions = this.computeReadOnlyPartitions(offset, length);
        int o = offset;
        int end = offset + length;
        ITypedRegion[] iTypedRegionArray = readOnlyRegions;
        int n = readOnlyRegions.length;
        int n2 = 0;
        while (n2 < n) {
            ITypedRegion readOnlyRegion = iTypedRegionArray[n2];
            if (o < readOnlyRegion.getOffset()) {
                return false;
            }
            if ((o += readOnlyRegion.getLength()) >= end) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean containsReadOnly(int offset, int length) {
        return this.computeReadOnlyPartitions(offset, length).length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPreviousOffsetByState(int offset, boolean searchWritable) {
        ArrayList<IOConsolePartition> arrayList = this.partitions;
        synchronized (arrayList) {
            int partitionIndex = this.findPartitionCandidate(offset);
            while (partitionIndex >= 0) {
                IOConsolePartition partition = this.partitions.get(partitionIndex);
                if (partition.isReadOnly() != searchWritable) {
                    return Math.min(partition.getOffset() + partition.getLength() - 1, offset);
                }
                --partitionIndex;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNextOffsetByState(int offset, boolean searchWritable) {
        ArrayList<IOConsolePartition> arrayList = this.partitions;
        synchronized (arrayList) {
            int partitionIndex = this.findPartitionCandidate(offset);
            if (partitionIndex >= 0) {
                while (partitionIndex < this.partitions.size()) {
                    IOConsolePartition partition = this.partitions.get(partitionIndex);
                    if (partition.isReadOnly() != searchWritable) {
                        return Math.max(partition.getOffset(), offset);
                    }
                    ++partitionIndex;
                }
            }
        }
        return this.document != null ? this.document.getLength() : 0;
    }

    public boolean isHandleControlCharacters() {
        return this.controlCharacterPattern != null;
    }

    public void setHandleControlCharacters(boolean handleControlCharacters) {
        this.controlCharacterPattern = handleControlCharacters ? Pattern.compile(this.carriageReturnAsControlCharacter ? CONTROL_CHARACTERS_WITH_CR_PATTERN_STR : CONTROL_CHARACTERS_PATTERN_STR) : null;
    }

    public boolean isCarriageReturnAsControlCharacter() {
        return this.carriageReturnAsControlCharacter;
    }

    public void setCarriageReturnAsControlCharacter(boolean carriageReturnAsControlCharacter) {
        this.carriageReturnAsControlCharacter = carriageReturnAsControlCharacter;
        this.setHandleControlCharacters(this.isHandleControlCharacters());
    }

    private IOConsolePartition getPartitionByIndex(int index) {
        return index >= 0 && index < this.partitions.size() ? this.partitions.get(index) : null;
    }

    private static boolean isInputPartition(IOConsolePartition partition) {
        return IOConsolePartition.INPUT_PARTITION_TYPE.equals(partition.getType());
    }

    private static void log(Throwable t) {
        ConsolePlugin.log(t);
    }

    private static void log(int status, String msg) {
        ConsolePlugin.log((IStatus)new Status(status, ConsolePlugin.getUniqueIdentifier(), msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPartitions() {
        if (this.document == null) {
            return;
        }
        ArrayList<IOConsolePartition> arrayList = this.partitions;
        synchronized (arrayList) {
            ArrayList<IOConsolePartition> knownInputPartitions = new ArrayList<IOConsolePartition>(this.inputPartitions);
            int offset = 0;
            for (IOConsolePartition partition : this.partitions) {
                Assert.isTrue((offset == partition.getOffset() ? 1 : 0) != 0);
                Assert.isTrue((partition.getLength() > 0 ? 1 : 0) != 0);
                offset += partition.getLength();
                if (!IOConsolePartitioner.isInputPartition(partition) || partition.isReadOnly()) continue;
                Assert.isTrue((boolean)knownInputPartitions.remove(partition));
            }
            Assert.isTrue((offset == this.document.getLength() ? 1 : 0) != 0);
            Assert.isTrue((boolean)knownInputPartitions.isEmpty());
        }
    }

    private static enum DocUpdateType {
        INPUT,
        OUTPUT,
        TRIM;

    }

    private class PendingPartition {
        StringBuilder text = new StringBuilder(8192);
        IOConsoleOutputStream stream;

        PendingPartition(IOConsoleOutputStream stream, String text) {
            this.stream = stream;
            this.append(text);
        }

        void append(String moreText) {
            this.text.append(moreText);
            IOConsolePartitioner iOConsolePartitioner = IOConsolePartitioner.this;
            iOConsolePartitioner.pendingSize = iOConsolePartitioner.pendingSize + moreText.length();
        }
    }

    private class QueueProcessingJob
    extends UIJob {
        QueueProcessingJob() {
            super("IOConsole Updater");
            this.setSystem(true);
            this.setPriority(10);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            IOConsolePartitioner.this.processPendingPartitions();
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldRun() {
            ArrayList arrayList = IOConsolePartitioner.this.pendingPartitions;
            synchronized (arrayList) {
                boolean shouldRun = IOConsolePartitioner.this.pendingPartitions.size() > 0;
                return shouldRun;
            }
        }
    }

    private class TrimJob
    extends WorkbenchJob {
        private int truncateOffset;

        TrimJob() {
            super("Trim Job");
            this.setSystem(true);
        }

        public void setOffset(int offset) {
            this.truncateOffset = offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            ArrayList arrayList = IOConsolePartitioner.this.partitions;
            synchronized (arrayList) {
                if (IOConsolePartitioner.this.document == null) {
                    return Status.OK_STATUS;
                }
                int length = IOConsolePartitioner.this.document.getLength();
                if (this.truncateOffset < length) {
                    try {
                        if (this.truncateOffset < 0) {
                            IOConsolePartitioner.this.updateType = DocUpdateType.TRIM;
                            IOConsolePartitioner.this.document.set("");
                        } else {
                            int cutoffLine = IOConsolePartitioner.this.document.getLineOfOffset(this.truncateOffset);
                            int cutOffset = IOConsolePartitioner.this.document.getLineOffset(cutoffLine);
                            IOConsolePartition partition = (IOConsolePartition)IOConsolePartitioner.this.getPartition(cutOffset);
                            partition.setLength(partition.getOffset() + partition.getLength() - cutOffset);
                            IOConsolePartitioner.this.updateType = DocUpdateType.TRIM;
                            IOConsolePartitioner.this.document.replace(0, cutOffset, "");
                            int index = IOConsolePartitioner.this.partitions.indexOf(partition);
                            int i = 0;
                            while (i < index) {
                                IOConsolePartitioner.this.partitions.remove(0);
                                ++i;
                            }
                            int offset = 0;
                            for (IOConsolePartition p : IOConsolePartitioner.this.partitions) {
                                p.setOffset(offset);
                                offset += p.getLength();
                            }
                            int removedLength = cutOffset;
                            IOConsolePartitioner.this.outputOffset = Math.max(IOConsolePartitioner.this.outputOffset - removedLength, 0);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            return Status.OK_STATUS;
        }
    }
}

