/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedValueObject;
import org.jkiss.dbeaver.ui.ImageUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public abstract class ObjectViewerRenderer {
    public static final int ES_CENTERED = 1;
    public static final int ES_LEFT = 2;
    private boolean isTree;
    private transient Item selectedItem;
    private transient Item lastClickItem;
    private transient int selectedColumn = -1;
    private ColumnViewer itemsViewer;
    private final TextLayout linkLayout;
    private final Cursor linkCursor;
    private final Cursor arrowCursor;
    private final Color selectionBackgroundColor;

    public ObjectViewerRenderer(ColumnViewer viewer) {
        this.itemsViewer = viewer;
        this.isTree = this.itemsViewer instanceof AbstractTreeViewer;
        Display display = this.itemsViewer.getControl().getDisplay();
        this.linkLayout = new TextLayout((Device)display);
        this.selectionBackgroundColor = display.getSystemColor(26);
        this.linkCursor = display.getSystemCursor(21);
        this.arrowCursor = display.getSystemCursor(0);
        this.itemsViewer.getControl().setCursor(this.arrowCursor);
        CellTrackListener actionsListener = new CellTrackListener();
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Item item = (Item)e.item;
                ObjectViewerRenderer.this.lastClickItem = item;
                ObjectViewerRenderer.this.selectedItem = item;
            }
        };
        if (this.isTree) {
            this.getTree().addSelectionListener((SelectionListener)selectionAdapter);
        } else {
            this.getTable().addSelectionListener((SelectionListener)selectionAdapter);
        }
        this.itemsViewer.getControl().addMouseListener((org.eclipse.swt.events.MouseListener)new MouseListener());
        this.itemsViewer.getControl().addMouseTrackListener((MouseTrackListener)actionsListener);
        this.itemsViewer.getControl().addMouseMoveListener((MouseMoveListener)actionsListener);
        this.itemsViewer.getControl().addKeyListener((KeyListener)actionsListener);
    }

    public boolean isTree() {
        return this.isTree;
    }

    private TableItem detectTableItem(int x, int y) {
        this.selectedItem = null;
        this.selectedColumn = -1;
        Point pt = new Point(x, y);
        this.selectedItem = this.getTable().getItem(pt);
        if (this.selectedItem == null) {
            return null;
        }
        this.selectedColumn = UIUtils.getColumnAtPos((TableItem)this.selectedItem, x, y);
        return (TableItem)this.selectedItem;
    }

    private TreeItem detectTreeItem(int x, int y) {
        this.selectedItem = null;
        this.selectedColumn = -1;
        Point pt = new Point(x, y);
        this.selectedItem = this.getTree().getItem(pt);
        if (this.selectedItem == null) {
            return null;
        }
        this.selectedColumn = UIUtils.getColumnAtPos((TreeItem)this.selectedItem, x, y);
        return (TreeItem)this.selectedItem;
    }

    public String getSelectedText() {
        if (this.lastClickItem == null || this.selectedColumn == -1) {
            return null;
        }
        Object cellValue = this.getCellValue(this.lastClickItem.getData(), this.selectedColumn);
        return ObjectViewerRenderer.getCellString(cellValue, false);
    }

    protected ColumnViewer getItemsViewer() {
        return this.itemsViewer;
    }

    public Composite getControl() {
        return (Composite)this.itemsViewer.getControl();
    }

    public void dispose() {
        UIUtils.dispose((Resource)this.linkLayout);
    }

    private Tree getTree() {
        return ((TreeViewer)this.itemsViewer).getTree();
    }

    private Table getTable() {
        return ((TableViewer)this.itemsViewer).getTable();
    }

    private Rectangle getCellLinkBounds(Item item, int column, Object cellValue) {
        this.prepareLinkStyle(cellValue, null);
        Rectangle itemBounds = this.isTree ? ((TreeItem)item).getTextBounds(column) : ((TableItem)item).getTextBounds(column);
        Rectangle linkBounds = this.linkLayout.getBounds();
        linkBounds.x += itemBounds.x;
        linkBounds.y += itemBounds.y + 1;
        linkBounds.height -= 2;
        return linkBounds;
    }

    public void paintCell(Event event, Object element, Object cellValue, Widget item, Class<?> propDataType, int columnIndex, boolean editable, boolean selected) {
        GC gc = event.gc;
        if (Boolean.class == propDataType || Boolean.TYPE == propDataType) {
            Rectangle columnBounds;
            boolean boolValue = CommonUtils.getBoolean((Object)cellValue, (boolean)false);
            Image image = editable ? (boolValue ? ImageUtils.getImageCheckboxEnabledOn() : ImageUtils.getImageCheckboxEnabledOff()) : (boolValue ? ImageUtils.getImageCheckboxDisabledOn() : ImageUtils.getImageCheckboxDisabledOff());
            Rectangle imageBounds = image.getBounds();
            Rectangle rectangle = columnBounds = this.isTree ? ((TreeItem)item).getBounds(columnIndex) : ((TableItem)item).getBounds(columnIndex);
            if (this.getBooleanEditStyle() == 1) {
                gc.drawImage(image, event.x + (columnBounds.width - imageBounds.width) / 2, event.y);
            } else {
                gc.drawImage(image, event.x, event.y + (columnBounds.height - imageBounds.height) / 2);
            }
            event.doit = false;
        } else if (cellValue != null && this.isHyperlink(cellValue)) {
            this.prepareLinkStyle(cellValue, selected ? gc.getForeground() : JFaceColors.getHyperlinkText((Display)event.item.getDisplay()));
            Rectangle textBounds = event.item instanceof TreeItem ? ((TreeItem)event.item).getTextBounds(event.index) : ((TableItem)event.item).getTextBounds(event.index);
            this.linkLayout.draw(gc, textBounds.x, textBounds.y);
        }
    }

    protected int getBooleanEditStyle() {
        return 1;
    }

    private void prepareLinkStyle(Object cellValue, Color foreground) {
        TextStyle linkStyle = new TextStyle(this.getControl().getFont(), foreground, null);
        linkStyle.underline = true;
        linkStyle.underlineStyle = 4;
        String text = ObjectViewerRenderer.getCellString(cellValue, false);
        this.linkLayout.setText(text);
        this.linkLayout.setIndent(0);
        this.linkLayout.setStyle(linkStyle, 0, text.length());
    }

    public static String getCellString(@Nullable Object value, boolean nameColumn) {
        if (value == null) {
            return "";
        }
        if (!nameColumn && value instanceof DBPNamedValueObject) {
            value = ((DBPNamedValueObject)value).getObjectValue();
        } else if (value instanceof DBPNamedObject) {
            value = ((DBPNamedObject)value).getName();
        }
        return GeneralUtils.makeDisplayString((Object)value).toString();
    }

    public boolean isHyperlink(@Nullable Object cellValue) {
        return false;
    }

    public void navigateHyperlink(Object cellValue) {
    }

    @Nullable
    public abstract Object getCellValue(Object var1, int var2);

    class CellTrackListener
    implements MouseTrackListener,
    MouseMoveListener,
    KeyListener {
        CellTrackListener() {
        }

        public void mouseEnter(MouseEvent e) {
        }

        public void mouseExit(MouseEvent e) {
            this.resetCursor();
        }

        public void mouseHover(MouseEvent e) {
        }

        private void resetCursor() {
            ObjectViewerRenderer.this.getItemsViewer().getControl().setCursor(ObjectViewerRenderer.this.arrowCursor);
        }

        public void mouseMove(MouseEvent e) {
            this.updateCursor(e.x, e.y, e.stateMask);
        }

        private void updateCursor(int x, int y, int stateMask) {
            Object hoverItem = ObjectViewerRenderer.this.isTree ? ObjectViewerRenderer.this.detectTreeItem(x, y) : ObjectViewerRenderer.this.detectTableItem(x, y);
            if (hoverItem == null || ObjectViewerRenderer.this.selectedColumn < 0) {
                this.resetCursor();
            } else {
                int checkColumn;
                Object element = hoverItem.getData();
                Object cellValue = ObjectViewerRenderer.this.getCellValue(element, checkColumn = ObjectViewerRenderer.this.selectedColumn);
                if (cellValue == null) {
                    this.resetCursor();
                } else {
                    boolean ctrlPRessed;
                    boolean bl = ctrlPRessed = (stateMask & 0x40000) != 0 || (stateMask & 0x10000) != 0;
                    if (ctrlPRessed && ObjectViewerRenderer.this.isHyperlink(cellValue) && ObjectViewerRenderer.this.getCellLinkBounds((Item)hoverItem, checkColumn, cellValue).contains(x, y)) {
                        ObjectViewerRenderer.this.getItemsViewer().getControl().setCursor(ObjectViewerRenderer.this.linkCursor);
                    } else {
                        this.resetCursor();
                    }
                }
            }
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 262144 || e.keyCode == 65536) {
                Point mousePoint = ObjectViewerRenderer.this.itemsViewer.getControl().getDisplay().getCursorLocation();
                mousePoint = ObjectViewerRenderer.this.itemsViewer.getControl().getDisplay().map(null, ObjectViewerRenderer.this.itemsViewer.getControl(), mousePoint);
                this.updateCursor(mousePoint.x, mousePoint.y, e.keyCode);
            } else {
                ObjectViewerRenderer.this.selectedColumn = 0;
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 262144 || e.keyCode == 65536) {
                Point mousePoint = ObjectViewerRenderer.this.itemsViewer.getControl().getDisplay().getCursorLocation();
                mousePoint = ObjectViewerRenderer.this.itemsViewer.getControl().getDisplay().map(null, ObjectViewerRenderer.this.itemsViewer.getControl(), mousePoint);
                this.updateCursor(mousePoint.x, mousePoint.y, 0);
            }
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        public void mouseDown(MouseEvent e) {
            int checkColumn;
            Object element;
            Object cellValue;
            Object hoverItem = ObjectViewerRenderer.this.isTree ? ObjectViewerRenderer.this.detectTreeItem(e.x, e.y) : ObjectViewerRenderer.this.detectTableItem(e.x, e.y);
            ObjectViewerRenderer.this.lastClickItem = (Item)hoverItem;
            if ((e.stateMask & 0x40000) == 0 && (e.stateMask & 0x10000) == 0) {
                return;
            }
            if (hoverItem != null && ObjectViewerRenderer.this.selectedColumn >= 0 && e.button == 1 && ObjectViewerRenderer.this.isHyperlink(cellValue = ObjectViewerRenderer.this.getCellValue(element = hoverItem.getData(), checkColumn = ObjectViewerRenderer.this.selectedColumn)) && ObjectViewerRenderer.this.getCellLinkBounds((Item)hoverItem, checkColumn, cellValue).contains(e.x, e.y)) {
                ObjectViewerRenderer.this.navigateHyperlink(cellValue);
            }
        }
    }
}

