/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.registry.task.TaskTypeDescriptor;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigurator;
import org.jkiss.utils.CommonUtils;

public class TaskConfiguratorDescriptor
extends AbstractContextDescriptor {
    private final TaskTypeDescriptor type;
    private final IConfigurationElement config;
    private final AbstractDescriptor.ObjectType implType;
    private final boolean supportsPanel;

    TaskConfiguratorDescriptor(TaskTypeDescriptor type, IConfigurationElement config) {
        super(config);
        this.type = type;
        this.config = config;
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config, "class");
        this.supportsPanel = CommonUtils.getBoolean((String)config.getAttribute("supportsPanel"), (boolean)true);
    }

    @NotNull
    public String getId() {
        return this.config.getAttribute("id");
    }

    @NotNull
    public String getName() {
        return this.config.getAttribute("name");
    }

    @NotNull
    public TaskTypeDescriptor getType() {
        return this.type;
    }

    @NotNull
    public DBTTaskConfigurator createConfigurator() throws DBException {
        return (DBTTaskConfigurator)this.implType.createInstance(DBTTaskConfigurator.class);
    }

    public String toString() {
        return this.implType.getImplName();
    }

    public boolean supportsPanel() {
        return this.supportsPanel;
    }
}

