/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.List;
import java.util.Optional;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TabFolder;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public abstract class ConnectionPageWithAuth
extends ConnectionPageAbstract {
    private static final Log log = Log.getLog(DataSourceProviderRegistry.class);
    private List<? extends DBPAuthModelDescriptor> allAuthModels;
    private DBPAuthModelDescriptor selectedAuthModel;
    private Composite modelConfigPlaceholder;
    private IObjectPropertyConfigurator<DBPDataSourceContainer> authModelConfigurator;

    protected void createAuthPanel(Composite parent, int hSpan) {
        this.modelConfigPlaceholder = UIUtils.createControlGroup((Composite)parent, (String)UIConnectionMessages.dialog_connection_auth_group, (int)2, (int)768, (int)0);
        ((GridData)this.modelConfigPlaceholder.getLayoutData()).horizontalSpan = hSpan;
    }

    protected Composite getAuthPanelComposite() {
        return this.modelConfigPlaceholder;
    }

    @Override
    public void loadSettings() {
        super.loadSettings();
        DBPDataSourceContainer activeDataSource = this.getSite().getActiveDataSource();
        this.allAuthModels = DataSourceProviderRegistry.getInstance().getApplicableAuthModels(activeDataSource);
        this.allAuthModels.sort((o1, o2) -> "native".equals(o1.getId()) ? -1 : ("native".equals(o2.getId()) ? 1 : o1.getName().compareTo(o2.getName())));
        String dsModelId = activeDataSource.getConnectionConfiguration().getAuthModelId();
        if (dsModelId != null) {
            Optional<DBPAuthModelDescriptor> dsModel = this.allAuthModels.stream().filter(o -> o.getId().equals(dsModelId)).findFirst();
            if (dsModel.isPresent()) {
                this.selectedAuthModel = dsModel.get();
            } else {
                log.error((Object)("Model '" + dsModelId + "' not found"));
            }
        }
        if (this.selectedAuthModel == null) {
            String defaultAuthModelId = this.getDefaultAuthModelId(activeDataSource);
            for (DBPAuthModelDescriptor dBPAuthModelDescriptor : this.allAuthModels) {
                if (!dBPAuthModelDescriptor.getId().equals(defaultAuthModelId)) continue;
                this.selectedAuthModel = dBPAuthModelDescriptor;
                break;
            }
            if (this.selectedAuthModel == null) {
                this.selectedAuthModel = this.allAuthModels.get(0);
            }
        }
        this.changeAuthModel();
    }

    @NotNull
    protected String getDefaultAuthModelId(DBPDataSourceContainer dataSource) {
        return "native";
    }

    private void changeAuthModel() {
        this.showAuthModelSettings();
    }

    protected void showAuthModelSettings() {
        TabFolder parentFolder = (TabFolder)UIUtils.getParentOfType((Control)this.modelConfigPlaceholder, TabFolder.class);
        this.modelConfigPlaceholder.setRedraw(false);
        UIUtils.disposeChildControls((Composite)this.modelConfigPlaceholder);
        Label authModelLabel = UIUtils.createControlLabel((Composite)this.modelConfigPlaceholder, (String)UIConnectionMessages.dialog_connection_auth_group);
        final Combo authModelCombo = new Combo(this.modelConfigPlaceholder, 12);
        authModelCombo.setLayoutData((Object)new GridData(32));
        authModelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBPAuthModelDescriptor newAuthModel = (DBPAuthModelDescriptor)ConnectionPageWithAuth.this.allAuthModels.get(authModelCombo.getSelectionIndex());
                if (ConnectionPageWithAuth.this.selectedAuthModel != newAuthModel) {
                    ConnectionPageWithAuth.this.selectedAuthModel = newAuthModel;
                    ConnectionPageWithAuth.this.showAuthModelSettings();
                }
                ConnectionPageWithAuth.this.modelConfigPlaceholder.setFocus();
            }
        });
        for (DBPAuthModelDescriptor dBPAuthModelDescriptor : this.allAuthModels) {
            authModelCombo.add(dBPAuthModelDescriptor.getName());
        }
        if (this.selectedAuthModel != null) {
            authModelCombo.select(this.allAuthModels.indexOf(this.selectedAuthModel));
        }
        boolean bl = this.allAuthModels.size() >= 2;
        authModelLabel.setVisible(bl);
        ((GridData)authModelLabel.getLayoutData()).exclude = !bl;
        authModelCombo.setVisible(bl);
        ((GridData)authModelCombo.getLayoutData()).exclude = !bl;
        ((Group)this.modelConfigPlaceholder).setText(bl ? UIConnectionMessages.dialog_connection_auth_group : String.valueOf(UIConnectionMessages.dialog_connection_auth_group) + " (" + this.selectedAuthModel.getName() + ")");
        this.authModelConfigurator = null;
        UIPropertyConfiguratorDescriptor uiConfiguratorDescriptor = UIPropertyConfiguratorRegistry.getInstance().getDescriptor(this.selectedAuthModel.getImplClassName());
        if (uiConfiguratorDescriptor != null) {
            try {
                this.authModelConfigurator = uiConfiguratorDescriptor.createConfigurator();
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        if (this.authModelConfigurator != null) {
            this.authModelConfigurator.createControl(this.modelConfigPlaceholder, () -> this.getSite().updateButtons());
            this.authModelConfigurator.loadSettings((Object)this.getSite().getActiveDataSource());
        } else if (this.selectedAuthModel != null && !CommonUtils.isEmpty((String)this.selectedAuthModel.getDescription())) {
            Label descLabel = new Label(this.modelConfigPlaceholder, 0);
            descLabel.setText(this.selectedAuthModel.getDescription());
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            descLabel.setLayoutData((Object)gd);
        }
        this.modelConfigPlaceholder.setRedraw(true);
        if (this.modelConfigPlaceholder.getSize().x > 0 && parentFolder != null) {
            parentFolder.layout(true, true);
        }
    }

    @Override
    public void saveSettings(DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        dataSource.getConnectionConfiguration().setAuthModelId(this.selectedAuthModel == null ? null : this.selectedAuthModel.getId());
        if (this.authModelConfigurator != null) {
            this.authModelConfigurator.saveSettings((Object)dataSource);
        }
    }

    public boolean isComplete() {
        return this.authModelConfigurator == null || this.authModelConfigurator.isComplete();
    }
}

