/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.lang.reflect.Type;
import java.util.function.Function;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.C;

public class Callback {
    Object object;
    String method;
    String signature;
    int argCount;
    long address;
    long errorResult;
    boolean isStatic;
    boolean isArrayBased;
    static final boolean is32Bit = C.PTR_SIZEOF == 4;
    static final String PTR_SIGNATURE = is32Bit ? "I" : "J";
    static final String SIGNATURE_0 = Callback.getSignature(0);
    static final String SIGNATURE_1 = Callback.getSignature(1);
    static final String SIGNATURE_2 = Callback.getSignature(2);
    static final String SIGNATURE_3 = Callback.getSignature(3);
    static final String SIGNATURE_4 = Callback.getSignature(4);
    static final String SIGNATURE_N = "([" + PTR_SIGNATURE + ")" + PTR_SIGNATURE;

    public Callback(Object object, String method, int argCount) {
        this(object, method, argCount, false);
    }

    public Callback(Object object, String method, int argCount, boolean isArrayBased) {
        this(object, method, argCount, isArrayBased, 0L);
    }

    public Callback(Object object, String method, int argCount, boolean isArrayBased, long errorResult) {
        this.object = object;
        this.method = method;
        this.argCount = argCount;
        this.isStatic = object instanceof Class;
        this.isArrayBased = isArrayBased;
        this.errorResult = errorResult;
        if (isArrayBased) {
            this.signature = SIGNATURE_N;
        } else {
            switch (argCount) {
                case 0: {
                    this.signature = SIGNATURE_0;
                    break;
                }
                case 1: {
                    this.signature = SIGNATURE_1;
                    break;
                }
                case 2: {
                    this.signature = SIGNATURE_2;
                    break;
                }
                case 3: {
                    this.signature = SIGNATURE_3;
                    break;
                }
                case 4: {
                    this.signature = SIGNATURE_4;
                    break;
                }
                default: {
                    this.signature = Callback.getSignature(argCount);
                }
            }
        }
        this.address = Callback.bind(this, object, method, this.signature, argCount, this.isStatic, isArrayBased, errorResult);
        if (this.address == 0L) {
            SWT.error(3);
        }
    }

    public Callback(Object object, String method, Type returnType, Type[] arguments) {
        this.object = object;
        this.method = method;
        this.argCount = arguments != null ? arguments.length : 0;
        this.isStatic = object instanceof Class;
        this.isArrayBased = false;
        this.errorResult = 0L;
        Function<Type, String> getTypeLetter = type -> {
            if (Integer.TYPE.equals(type)) {
                return "I";
            }
            if (Long.TYPE.equals(type)) {
                return "J";
            }
            if (Void.TYPE.equals(type)) {
                return "V";
            }
            if (Byte.TYPE.equals(type)) {
                return "B";
            }
            if (Character.TYPE.equals(type)) {
                return "C";
            }
            if (Double.TYPE.equals(type)) {
                return "D";
            }
            if (Float.TYPE.equals(type)) {
                return "F";
            }
            if (Short.TYPE.equals(type)) {
                return "S";
            }
            if (Boolean.TYPE.equals(type)) {
                return "Z";
            }
            SWT.error(5, null, String.valueOf(type.toString()) + "Not supported");
            return null;
        };
        StringBuilder signature = new StringBuilder("(");
        Type[] typeArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Type t = typeArray[n2];
            if (t.equals(Void.TYPE)) {
                SWT.error(5, null, "void is not a valid argument");
            }
            signature.append(getTypeLetter.apply(t));
            ++n2;
        }
        signature.append(")");
        signature.append(getTypeLetter.apply(returnType));
        this.signature = signature.toString();
        if (is32Bit) {
            this.signature = this.signature.replace("J", "I");
        }
        this.address = Callback.bind(this, this.object, this.method, this.signature, this.argCount, this.isStatic, this.isArrayBased, this.errorResult);
        if (this.address == 0L) {
            SWT.error(3);
        }
    }

    static synchronized native long bind(Callback var0, Object var1, String var2, String var3, int var4, boolean var5, boolean var6, long var7);

    public void dispose() {
        if (this.object == null) {
            return;
        }
        Callback.unbind(this);
        this.signature = null;
        this.method = null;
        this.object = null;
        this.address = 0L;
    }

    public long getAddress() {
        return this.address;
    }

    public static native String getPlatform();

    public static native int getEntryCount();

    static String getSignature(int argCount) {
        String signature = "(";
        int i = 0;
        while (i < argCount) {
            signature = String.valueOf(signature) + PTR_SIGNATURE;
            ++i;
        }
        signature = String.valueOf(signature) + ")" + PTR_SIGNATURE;
        return signature;
    }

    public static final synchronized native void setEnabled(boolean var0);

    public static final synchronized native boolean getEnabled();

    @Deprecated
    static final void ignoreCallbacks(boolean ignore) {
        Callback.setEnabled(!ignore);
    }

    public static final synchronized native void reset();

    static final synchronized native void unbind(Callback var0);
}

