/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.ui.views;

import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.exasol.ui.ExasolActivator;
import org.jkiss.dbeaver.ext.exasol.ui.internal.ExasolMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class ExasolConnectionPage
extends ConnectionPageWithAuth
implements ICompositeDialogPage {
    private Label backupHostLabel;
    private Text hostText;
    private Text backupHostText;
    private Text portText;
    private Button useBackupHostList;
    private boolean showBackupHosts = false;
    private Button encryptCommunication;
    private static ImageDescriptor EXASOL_LOGO_IMG = ExasolActivator.getImageDescriptor("icons/exasol.png");

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        this.setImageDescriptor(EXASOL_LOGO_IMG);
        Composite control = new Composite(composite, 0);
        control.setLayout((Layout)new GridLayout(1, false));
        control.setLayoutData((Object)new GridData(1808));
        ModifyListener textListener = e -> this.evaluateURL();
        Group addrGroup = UIUtils.createControlGroup((Composite)control, (String)ExasolMessages.label_database, (int)2, (int)0, (int)0);
        GridData gd = new GridData(768);
        addrGroup.setLayoutData((Object)gd);
        this.hostText = UIUtils.createLabelText((Composite)addrGroup, (String)ExasolMessages.label_host_list, null, (int)2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        this.hostText.addModifyListener(textListener);
        this.backupHostLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)ExasolMessages.label_backup_host_list);
        gd = new GridData(32);
        this.backupHostLabel.setLayoutData((Object)gd);
        this.backupHostLabel.setEnabled(this.showBackupHosts);
        Composite bhPlaceholder = UIUtils.createComposite((Composite)addrGroup, (int)2);
        bhPlaceholder.setLayoutData((Object)new GridData(768));
        this.backupHostText = new Text(bhPlaceholder, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.backupHostText.setLayoutData((Object)gd);
        this.backupHostText.addModifyListener(textListener);
        this.useBackupHostList = UIUtils.createCheckbox((Composite)bhPlaceholder, (String)ExasolMessages.label_use_backup_host_list, null, (boolean)this.showBackupHosts, (int)1);
        this.useBackupHostList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExasolConnectionPage.this.backupHostLabel.setEnabled(ExasolConnectionPage.this.useBackupHostList.getSelection());
                ExasolConnectionPage.this.backupHostText.setEnabled(ExasolConnectionPage.this.useBackupHostList.getSelection());
                if (!ExasolConnectionPage.this.useBackupHostList.getSelection()) {
                    ExasolConnectionPage.this.backupHostText.setText("");
                }
            }
        });
        this.portText = UIUtils.createLabelText((Composite)addrGroup, (String)ExasolMessages.dialog_connection_port, null, (int)2048);
        gd = new GridData(2);
        gd.widthHint = 40;
        this.portText.setLayoutData((Object)gd);
        this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.portText.addModifyListener(textListener);
        this.encryptCommunication = UIUtils.createCheckbox((Composite)addrGroup, (String)ExasolMessages.label_encrypt, null, (boolean)false, (int)2);
        this.createAuthPanel(control, 1);
        this.createDriverPanel(control);
        this.setControl((Control)control);
    }

    public boolean isComplete() {
        return super.isComplete() && this.hostText != null && this.portText != null && !CommonUtils.isEmpty((String)this.hostText.getText()) && !CommonUtils.isEmpty((String)this.portText.getText());
    }

    public void loadSettings() {
        String backupHostText;
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText(connectionInfo.getHostName());
            } else {
                this.hostText.setText("");
            }
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(connectionInfo.getHostPort());
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("8563");
            }
        }
        if (!CommonUtils.isEmpty((String)(backupHostText = connectionInfo.getProviderProperty("@dbeaver-backupHostList")))) {
            this.backupHostLabel.setEnabled(true);
            this.backupHostText.setText(backupHostText);
            this.backupHostText.setEnabled(true);
            this.useBackupHostList.setSelection(true);
        } else {
            this.backupHostLabel.setEnabled(false);
            this.backupHostText.setEnabled(false);
            this.useBackupHostList.setSelection(false);
        }
        String encryptComm = connectionInfo.getProviderProperty("@dbeaver-encrypt");
        if (encryptComm != null && "1".equals(encryptComm)) {
            this.encryptCommunication.setEnabled(true);
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        connectionInfo.setProviderProperty("@dbeaver-backupHostList", this.backupHostText.getText());
        if (this.encryptCommunication.getSelection()) {
            connectionInfo.setProviderProperty("@dbeaver-encrypt", "1");
        }
        super.saveSettings(dataSource);
    }

    private void evaluateURL() {
        this.site.updateButtons();
    }

    public IDialogPage[] getSubPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

