/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.CommonMenuManager;
import org.eclipse.team.internal.ui.mapping.MergeAction;
import org.eclipse.team.internal.ui.mapping.MergeIncomingChangesAction;
import org.eclipse.team.internal.ui.mapping.ModelSelectionDropDownAction;
import org.eclipse.team.internal.ui.synchronize.actions.OpenInCompareAction;
import org.eclipse.team.internal.ui.synchronize.actions.SyncViewerShowPreferencesAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;

public class ModelSynchronizeParticipantActionGroup
extends SynchronizePageActionGroup {
    public static final String MERGE_ACTION_GROUP = "merge";
    public static final String OTHER_ACTION_GROUP = "other";
    protected static final String MERGE_ALL_ACTION_ID = "org.eclipse.team.ui.mergeAll";
    private MergeIncomingChangesAction updateToolbarAction;
    private ModelSelectionDropDownAction modelPicker;
    private SyncViewerShowPreferencesAction showPreferences;
    private OpenInCompareAction openInCompareAction;
    private MergeAction merge;
    private MergeAction overwrite;
    private MergeAction markAsMerged;

    @Override
    public void initialize(ISynchronizePageConfiguration configuration) {
        super.initialize(configuration);
        ModelSynchronizeParticipant participant = (ModelSynchronizeParticipant)configuration.getParticipant();
        if (participant.isMergingEnabled()) {
            this.updateToolbarAction = new MergeIncomingChangesAction(configuration);
            this.configureMergeAction(MERGE_ALL_ACTION_ID, (Action)this.updateToolbarAction);
            this.appendToGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", MERGE_ACTION_GROUP, (IAction)this.updateToolbarAction);
        }
        this.modelPicker = new ModelSelectionDropDownAction(configuration);
        this.appendToGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", "navigate", (IAction)this.modelPicker);
        ISynchronizePageSite site = configuration.getSite();
        IWorkbenchSite ws = site.getWorkbenchSite();
        if (ws instanceof IViewSite) {
            this.showPreferences = new SyncViewerShowPreferencesAction(configuration);
            this.openInCompareAction = new OpenInCompareAction(configuration);
            configuration.setProperty("org.eclipse.team.ui.P_OPEN_ACTION", new Action(){

                public void run() {
                    ModelSynchronizeParticipantActionGroup.this.openInCompareAction.run();
                }
            });
        }
    }

    @Override
    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        if (actionBars != null && this.showPreferences != null) {
            IMenuManager menu = actionBars.getMenuManager();
            this.appendToGroup((IContributionManager)menu, "preferences", (IAction)this.showPreferences);
        }
    }

    @Override
    public void fillContextMenu(IMenuManager menu) {
        IContributionItem fileGroup;
        Object[] elements;
        super.fillContextMenu(menu);
        if (menu instanceof CommonMenuManager) {
            CommonMenuManager cmm = (CommonMenuManager)menu;
            this.addMergeActions(cmm);
        }
        if ((elements = ((IStructuredSelection)this.getContext().getSelection()).toArray()).length > 0 && this.openInCompareAction != null && (fileGroup = this.findGroup((IContributionManager)menu, "file")) != null) {
            ModelSynchronizeParticipant msp = (ModelSynchronizeParticipant)this.getConfiguration().getParticipant();
            boolean allElementsHaveCompareInput = true;
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (!msp.hasCompareInputFor(element)) {
                    allElementsHaveCompareInput = false;
                    break;
                }
                ++n2;
            }
            if (allElementsHaveCompareInput) {
                menu.appendToGroup(fileGroup.getId(), (IAction)this.openInCompareAction);
            }
        }
    }

    private void addMergeActions(CommonMenuManager cmm) {
        ModelSynchronizeParticipant participant = (ModelSynchronizeParticipant)this.getConfiguration().getParticipant();
        if (participant.isMergingEnabled()) {
            if (!this.isTwoWayMerge()) {
                if (this.merge == null) {
                    this.merge = new MergeAction("org.eclipse.team.ui.mergeAction", cmm, this.getConfiguration());
                    this.configureMergeAction("org.eclipse.team.ui.mergeAction", this.merge);
                    this.registerActionWithWorkbench((IAction)this.merge);
                }
                this.merge.update();
                this.addToContextMenu("org.eclipse.team.ui.mergeAction", this.merge, (IMenuManager)cmm);
            }
            if (this.overwrite == null) {
                this.overwrite = new MergeAction("org.eclipse.team.ui.overwriteAction", cmm, this.getConfiguration());
                this.configureMergeAction("org.eclipse.team.ui.overwriteAction", this.overwrite);
                this.registerActionWithWorkbench((IAction)this.overwrite);
            }
            this.overwrite.update();
            this.addToContextMenu("org.eclipse.team.ui.overwriteAction", this.overwrite, (IMenuManager)cmm);
            if (!this.isTwoWayMerge()) {
                if (this.markAsMerged == null) {
                    this.markAsMerged = new MergeAction("org.eclipse.team.ui.markAsMergeAction", cmm, this.getConfiguration());
                    this.configureMergeAction("org.eclipse.team.ui.markAsMergeAction", this.markAsMerged);
                }
                this.markAsMerged.update();
                this.addToContextMenu("org.eclipse.team.ui.markAsMergeAction", this.markAsMerged, (IMenuManager)cmm);
                this.registerActionWithWorkbench((IAction)this.markAsMerged);
            }
        }
    }

    private void registerActionWithWorkbench(IAction action) {
        ISynchronizePageSite site = this.getConfiguration().getSite();
        String id = action.getId();
        if (id != null) {
            site.getActionBars().setGlobalActionHandler(id, action);
            IKeyBindingService keyBindingService = site.getKeyBindingService();
            if (keyBindingService != null) {
                keyBindingService.registerAction(action);
            }
        }
    }

    protected void configureMergeAction(String mergeActionId, Action action) {
        if (mergeActionId == "org.eclipse.team.ui.mergeAction") {
            Utils.initAction((IAction)action, "action.merge.");
        } else if (mergeActionId == "org.eclipse.team.ui.overwriteAction") {
            if (this.isTwoWayMerge()) {
                Utils.initAction((IAction)action, "action.replace.");
            } else {
                Utils.initAction((IAction)action, "action.overwrite.");
            }
        } else if (mergeActionId == "org.eclipse.team.ui.markAsMergeAction") {
            Utils.initAction((IAction)action, "action.markAsMerged.");
        } else if (mergeActionId == MERGE_ALL_ACTION_ID) {
            if (this.isTwoWayMerge()) {
                Utils.initAction((IAction)action, "action.replaceAll.");
            } else {
                Utils.initAction((IAction)action, "action.mergeAll.");
            }
        }
    }

    private boolean isTwoWayMerge() {
        ModelSynchronizeParticipant participant = (ModelSynchronizeParticipant)this.getConfiguration().getParticipant();
        ISynchronizationContext context = participant.getContext();
        if (context instanceof IMergeContext) {
            IMergeContext mc = (IMergeContext)context;
            return mc.getMergeType() == 2;
        }
        return false;
    }

    protected void addToContextMenu(String mergeActionId, Action action, IMenuManager manager) {
        IContributionItem group = null;
        if (mergeActionId == "org.eclipse.team.ui.mergeAction") {
            group = manager.find(MERGE_ACTION_GROUP);
        } else if (mergeActionId == "org.eclipse.team.ui.overwriteAction") {
            group = manager.find(MERGE_ACTION_GROUP);
        } else if (mergeActionId == "org.eclipse.team.ui.markAsMergeAction") {
            group = manager.find(OTHER_ACTION_GROUP);
        }
        if (group != null) {
            manager.appendToGroup(group.getId(), (IAction)action);
        } else {
            manager.add((IAction)action);
        }
    }

    @Override
    public void dispose() {
        if (this.modelPicker != null) {
            this.modelPicker.dispose();
        }
        if (this.merge != null) {
            this.merge.dispose();
        }
        if (this.overwrite != null) {
            this.overwrite.dispose();
        }
        if (this.markAsMerged != null) {
            this.markAsMerged.dispose();
        }
        if (this.updateToolbarAction != null) {
            this.updateToolbarAction.dispose();
        }
        super.dispose();
    }
}

