/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.sql.script;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.utils.CommonUtils;

class SQLScriptTaskDataSourceSelectorDialog
extends BaseDialog {
    private DBNProject projectNode;
    private DatabaseNavigatorTree dataSourceTree;
    private List<DBNDataSource> selectedDataSources = new ArrayList<DBNDataSource>();

    SQLScriptTaskDataSourceSelectorDialog(Shell parentShell, DBNProject projectNode) {
        super(parentShell, DTMessages.sql_script_task_page_settings_group_connections, null);
        this.projectNode = projectNode;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        INavigatorFilter dsFilter = new INavigatorFilter(){

            public boolean filterFolders() {
                return true;
            }

            public boolean isLeafObject(Object object) {
                return object instanceof DBNDataSource;
            }

            public boolean select(Object element) {
                return element instanceof DBNProject || element instanceof DBNProjectDatabases || element instanceof DBNLocalFolder || element instanceof DBNDataSource;
            }
        };
        this.dataSourceTree = new DatabaseNavigatorTree(dialogArea, (DBNNode)this.projectNode.getDatabases(), 2084, false, dsFilter);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 400;
        this.dataSourceTree.setLayoutData((Object)gd);
        this.dataSourceTree.getViewer().addSelectionChangedListener(event -> this.updateSelectedDataSources());
        return dialogArea;
    }

    private void updateSelectedDataSources() {
        this.selectedDataSources.clear();
        Object[] objectArray = this.dataSourceTree.getCheckboxViewer().getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof DBNDataSource) {
                this.selectedDataSources.add((DBNDataSource)element);
            }
            ++n2;
        }
        this.getButton(0).setEnabled(!this.selectedDataSources.isEmpty());
    }

    public List<DBNDataSource> getSelectedDataSources() {
        return this.selectedDataSources;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    static void createScriptColumns(ColumnViewer viewer) {
        final ILabelProvider mainLabelProvider = (ILabelProvider)viewer.getLabelProvider();
        ViewerColumnController columnController = new ViewerColumnController("sqlTaskScriptViewer", viewer);
        columnController.setForceAutoSize(true);
        columnController.addColumn(ModelMessages.model_navigator_Name, "Script", 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return mainLabelProvider.getText(element);
            }

            public Image getImage(Object element) {
                return mainLabelProvider.getImage(element);
            }

            public String getToolTipText(Object element) {
                if (mainLabelProvider instanceof IToolTipProvider) {
                    return ((IToolTipProvider)mainLabelProvider).getToolTipText(element);
                }
                return null;
            }
        });
        columnController.addColumn(ModelMessages.model_navigator_Connection, "Script datasource", 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Collection containers;
                if (element instanceof DBNResource && !CommonUtils.isEmpty((Collection)(containers = ((DBNResource)element).getAssociatedDataSources()))) {
                    StringBuilder text = new StringBuilder();
                    for (DBPDataSourceContainer container : containers) {
                        if (text.length() > 0) {
                            text.append(", ");
                        }
                        text.append(container.getName());
                    }
                    return text.toString();
                }
                return "";
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        columnController.createColumns(true);
    }
}

