/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.sql.script;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;
import org.jkiss.utils.CommonUtils;

class SQLScriptTaskScriptSelectorDialog
extends BaseDialog {
    private DBNProject projectNode;
    private DatabaseNavigatorTree scriptsTree;
    private List<DBNResource> selectedScripts = new ArrayList<DBNResource>();

    SQLScriptTaskScriptSelectorDialog(Shell parentShell, DBNProject projectNode) {
        super(parentShell, DTMessages.sql_script_task_page_settings_group_files, null);
        this.projectNode = projectNode;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        INavigatorFilter scriptFilter = new INavigatorFilter(){

            public boolean filterFolders() {
                return true;
            }

            public boolean isLeafObject(Object object) {
                return object instanceof DBNResource && ((DBNResource)object).getResource() instanceof IFile;
            }

            public boolean select(Object element) {
                return element instanceof DBNLocalFolder || element instanceof DBNResource;
            }
        };
        this.scriptsTree = new DatabaseNavigatorTree(dialogArea, (DBNNode)this.projectNode, 2084, false, scriptFilter);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 400;
        this.scriptsTree.setLayoutData((Object)gd);
        this.scriptsTree.getViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof TreeNodeSpecial) {
                    return true;
                }
                if (element instanceof DBNResource) {
                    return SQLScriptTaskScriptSelectorDialog.this.isResourceApplicable((DBNResource)element);
                }
                return false;
            }
        });
        this.scriptsTree.getViewer().addSelectionChangedListener(event -> this.updateSelectedScripts());
        this.scriptsTree.getViewer().expandToLevel(2);
        this.scriptsTree.getViewer().getTree().setHeaderVisible(true);
        SQLScriptTaskScriptSelectorDialog.createScriptColumns((ColumnViewer)this.scriptsTree.getViewer());
        return dialogArea;
    }

    private void updateSelectedScripts() {
        this.selectedScripts.clear();
        Object[] objectArray = this.scriptsTree.getCheckboxViewer().getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof DBNResource && ((DBNResource)element).getResource() instanceof IFile) {
                this.selectedScripts.add((DBNResource)element);
            }
            ++n2;
        }
        this.getButton(0).setEnabled(!this.selectedScripts.isEmpty());
    }

    public List<DBNResource> getSelectedScripts() {
        return this.selectedScripts;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    static void createScriptColumns(ColumnViewer viewer) {
        final ILabelProvider mainLabelProvider = (ILabelProvider)viewer.getLabelProvider();
        ViewerColumnController columnController = new ViewerColumnController("sqlTaskScriptViewer", viewer);
        columnController.setForceAutoSize(true);
        columnController.addColumn(ModelMessages.model_navigator_Name, "Script", 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return mainLabelProvider.getText(element);
            }

            public Image getImage(Object element) {
                return mainLabelProvider.getImage(element);
            }

            public String getToolTipText(Object element) {
                if (mainLabelProvider instanceof IToolTipProvider) {
                    return ((IToolTipProvider)mainLabelProvider).getToolTipText(element);
                }
                return null;
            }
        });
        columnController.addColumn(ModelMessages.model_navigator_Connection, "Script datasource", 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Collection containers;
                if (element instanceof DBNResource && !CommonUtils.isEmpty((Collection)(containers = ((DBNResource)element).getAssociatedDataSources()))) {
                    StringBuilder text = new StringBuilder();
                    for (DBPDataSourceContainer container : containers) {
                        if (text.length() > 0) {
                            text.append(", ");
                        }
                        text.append(container.getName());
                    }
                    return text.toString();
                }
                return "";
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        columnController.createColumns(true);
    }

    private boolean isResourceApplicable(DBNResource element) {
        IResource resource = element.getResource();
        if (resource instanceof IFolder) {
            return "script folder".equals(element.getNodeType());
        }
        return resource instanceof IContainer || resource instanceof IFile && "sql".equals(resource.getFileExtension());
    }
}

