/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.sql;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigPanel;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigurator;
import org.jkiss.dbeaver.tasks.ui.sql.SQLToolTaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;

public class SQLToolTaskConfigurator
implements DBTTaskConfigurator {
    private static final Log log = Log.getLog(SQLToolTaskConfigurator.class);

    public ConfigPanel createInputConfigurator(DBRRunnableContext runnableContext, @NotNull DBTTaskType taskType) {
        return new ConfigPanel(runnableContext, taskType);
    }

    public TaskConfigurationWizard createTaskConfigWizard(@NotNull DBTTask taskConfiguration) {
        return new SQLToolTaskConfigurationWizard(taskConfiguration);
    }

    private static class ConfigPanel
    implements DBTTaskConfigPanel {
        private DBRRunnableContext runnableContext;
        private DBTTaskType taskType;
        private Table objectsTable;
        private DBPProject currentProject;
        private SQLToolTaskConfigurationWizard dtWizard;

        ConfigPanel(DBRRunnableContext runnableContext, DBTTaskType taskType) {
            this.runnableContext = runnableContext;
            this.taskType = taskType;
        }

        public void createControl(Composite parent, TaskConfigurationWizard wizard, Runnable propertyChangeListener) {
            this.dtWizard = (SQLToolTaskConfigurationWizard)wizard;
        }

        public void loadSettings() {
        }

        public void saveSettings() {
        }

        public boolean isComplete() {
            return this.objectsTable.getItemCount() > 0;
        }

        public String getErrorMessage() {
            if (this.objectsTable.getItemCount() == 0) {
                return "No objects selected";
            }
            return null;
        }
    }
}

