/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.manager;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2TableBase;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DB2TableColumnManager
extends SQLTableColumnManager<DB2TableColumn, DB2TableBase>
implements DBEObjectRenamer<DB2TableColumn> {
    private static final String SQL_ALTER = "ALTER TABLE %s ALTER COLUMN %s ";
    private static final String SQL_COMMENT = "COMMENT ON COLUMN %s.%s IS '%s'";
    private static final String SQL_REORG = "CALL SYSPROC.ADMIN_CMD('REORG TABLE %s')";
    private static final String CLAUSE_SET_TYPE = " SET DATA TYPE ";
    private static final String CLAUSE_SET_NULL = " SET NOT NULL";
    private static final String CLAUSE_DROP_NULL = " DROP NOT NULL";
    private static final String CMD_ALTER = "Alter Column";
    private static final String CMD_COMMENT = "Comment on Column";
    private static final String CMD_REORG = "Reorg table";
    private static final String LINE_SEPARATOR = GeneralUtils.getDefaultLineSeparator();

    @Nullable
    public DBSObjectCache<? extends DBSObject, DB2TableColumn> getObjectsCache(DB2TableColumn object) {
        return ((DB2Schema)((DB2TableBase)object.getParentObject()).getContainer()).getTableCache().getChildrenCache((DB2Table)object.getParentObject());
    }

    public boolean canEditObject(DB2TableColumn object) {
        DB2TableBase db2TableBase = (DB2TableBase)object.getParentObject();
        return db2TableBase != null & db2TableBase.getClass().equals(DB2Table.class);
    }

    protected DB2TableColumn createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        DB2TableColumn column = new DB2TableColumn((DB2TableBase)container);
        column.setName(this.getNewColumnName(monitor, context, (DBSEntity)((DB2TableBase)container)));
        return column;
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        String deltaSQL;
        DB2TableColumn db2Column = (DB2TableColumn)command.getObject();
        boolean hasColumnChanges = false;
        if (!command.getProperties().isEmpty() && !(deltaSQL = this.computeDeltaSQL(command)).isEmpty()) {
            hasColumnChanges = true;
            String sqlAlterColumn = String.format(SQL_ALTER, ((DB2TableBase)db2Column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL), deltaSQL);
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(CMD_ALTER, sqlAlterColumn));
        }
        if (CommonUtils.isNotEmpty((String)db2Column.getDescription())) {
            actionList.add(this.buildCommentAction(db2Column));
        }
        if (hasColumnChanges) {
            actionList.add(this.buildReorgAction(db2Column));
        }
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        super.addObjectCreateActions(monitor, executionContext, actions, command, options);
        if (!CommonUtils.isEmpty((String)((DB2TableColumn)command.getObject()).getDescription())) {
            actions.add(this.buildCommentAction((DB2TableColumn)command.getObject()));
        }
    }

    private String computeDeltaSQL(SQLObjectEditor.ObjectChangeCommand command) {
        if (command.getProperties().isEmpty() || command.getProperties().size() == 1 && command.getProperty((Object)"description") != null) {
            return "";
        }
        DB2TableColumn column = (DB2TableColumn)command.getObject();
        StringBuilder sb = new StringBuilder(128);
        sb.append(column.getName());
        Boolean required = (Boolean)command.getProperty((Object)"required");
        if (required != null) {
            sb.append(LINE_SEPARATOR);
            if (required.booleanValue()) {
                sb.append(CLAUSE_SET_NULL);
            } else {
                sb.append(CLAUSE_DROP_NULL);
            }
        }
        if (command.hasProperty((Object)"dataType") || command.hasProperty((Object)"maxLength") || command.hasProperty((Object)"scale")) {
            sb.append(LINE_SEPARATOR);
            sb.append(CLAUSE_SET_TYPE);
            sb.append(DBUtils.getFullTypeName((DBSTypedObject)column));
        }
        return sb.toString();
    }

    private DBEPersistAction buildCommentAction(DB2TableColumn db2Column) {
        String tableName = ((DB2TableBase)db2Column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL);
        String columnName = db2Column.getName();
        String comment = db2Column.getDescription();
        String commentSQL = String.format(SQL_COMMENT, tableName, columnName, comment);
        return new SQLDatabasePersistAction(CMD_COMMENT, commentSQL);
    }

    private DBEPersistAction buildReorgAction(DB2TableColumn db2Column) {
        String tableName = ((DB2TableBase)db2Column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL);
        String reorgSQL = String.format(SQL_REORG, tableName);
        return new SQLDatabasePersistAction(CMD_REORG, reorgSQL);
    }

    public void renameObject(DBECommandContext commandContext, DB2TableColumn object, String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        DB2TableColumn column = (DB2TableColumn)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "ALTER TABLE " + ((DB2TableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " RENAME COLUMN " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getNewName())));
    }
}

