/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.ui.tools.maintenance;

import java.util.Collection;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.ui.internal.DB2Messages;
import org.jkiss.dbeaver.ext.db2.ui.tools.maintenance.DB2BaseTableToolDialog;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.ui.UIUtils;

public class DB2ReorgIndexDialog
extends DB2BaseTableToolDialog {
    private Button dlgAccessNo;
    private Button dlgAccessReadOnly;
    private Button dlgAccessReadWrite;
    private Button dlgCleanupKeysAndpages;
    private Button dlgCleanupPagesOnly;

    public DB2ReorgIndexDialog(IWorkbenchPartSite partSite, Collection<DB2Table> selectedTables) {
        super(partSite, DB2Messages.dialog_table_tools_runstats_title, selectedTables);
    }

    protected void createControls(Composite parent) {
        Group optionsGroup = UIUtils.createControlGroup((Composite)parent, (String)DB2Messages.dialog_table_tools_options, (int)1, (int)0, (int)0);
        optionsGroup.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite((Composite)optionsGroup, 2);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        UIUtils.createLabel((Composite)composite, (String)DB2Messages.dialog_table_tools_reorgix_access_title).setLayoutData((Object)new GridData(2));
        Composite groupAccess = new Composite(composite, 0);
        groupAccess.setLayout((Layout)new RowLayout(512));
        Button dlgAccessDefault = new Button(groupAccess, 16);
        dlgAccessDefault.setText(DB2Messages.dialog_table_tools_reorgix_access_default);
        dlgAccessDefault.addSelectionListener(this.SQL_CHANGE_LISTENER);
        this.dlgAccessNo = new Button(groupAccess, 16);
        this.dlgAccessNo.setText(DB2Messages.dialog_table_tools_reorgix_access_no);
        this.dlgAccessNo.addSelectionListener(this.SQL_CHANGE_LISTENER);
        this.dlgAccessReadOnly = new Button(groupAccess, 16);
        this.dlgAccessReadOnly.setText(DB2Messages.dialog_table_tools_reorgix_access_read);
        this.dlgAccessReadOnly.addSelectionListener(this.SQL_CHANGE_LISTENER);
        this.dlgAccessReadWrite = new Button(groupAccess, 16);
        this.dlgAccessReadWrite.setText(DB2Messages.dialog_table_tools_reorgix_access_readwrite);
        this.dlgAccessReadWrite.addSelectionListener(this.SQL_CHANGE_LISTENER);
        UIUtils.createLabel((Composite)composite, (String)DB2Messages.dialog_table_tools_reorgix_options_title).setLayoutData((Object)new GridData(2));
        Composite groupCleanup = new Composite(composite, 0);
        groupCleanup.setLayout((Layout)new RowLayout(512));
        Button dlgFullIndex = new Button(groupCleanup, 16);
        dlgFullIndex.setText(DB2Messages.dialog_table_tools_reorgix_options_full);
        dlgFullIndex.addSelectionListener(this.SQL_CHANGE_LISTENER);
        dlgFullIndex.setSelection(true);
        this.dlgCleanupKeysAndpages = new Button(groupCleanup, 16);
        this.dlgCleanupKeysAndpages.setText(DB2Messages.dialog_table_tools_reorgix_options_cleanup_keys);
        this.dlgCleanupKeysAndpages.addSelectionListener(this.SQL_CHANGE_LISTENER);
        this.dlgCleanupPagesOnly = new Button(groupCleanup, 16);
        this.dlgCleanupPagesOnly.setText(DB2Messages.dialog_table_tools_reorgix_options_cleanup_pages);
        this.dlgCleanupPagesOnly.addSelectionListener(this.SQL_CHANGE_LISTENER);
        this.createObjectsSelector(parent);
    }

    protected void generateObjectCommand(List<String> lines, DB2Table db2Table) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("CALL SYSPROC.ADMIN_CMD('");
        sb.append("REORG INDEXES ALL FOR TABLE ").append(db2Table.getFullyQualifiedName(DBPEvaluationContext.DDL));
        if (this.dlgAccessNo.getSelection()) {
            sb.append(" ALLOW NO ACCESS");
        }
        if (this.dlgAccessReadOnly.getSelection()) {
            sb.append(" ALLOW READ ACCESS");
        }
        if (this.dlgAccessReadWrite.getSelection()) {
            sb.append(" ALLOW WRITE ACCESS");
        }
        if (this.dlgCleanupKeysAndpages.getSelection()) {
            sb.append("  CLEANUP ALL");
        }
        if (this.dlgCleanupPagesOnly.getSelection()) {
            sb.append(" CLEANUP PAGES");
        }
        sb.append("')");
        lines.add(sb.toString());
    }
}

