/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tools;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractToolWizard;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractToolWizardPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseAuthDialog;

abstract class MySQLWizardPageSettings<WIZARD extends AbstractToolWizard>
extends AbstractToolWizardPage<WIZARD> {
    MySQLWizardPageSettings(WIZARD wizard, String title) {
        super(wizard, title);
    }

    public void createSecurityGroup(Composite parent) {
        DBPConnectionConfiguration connectionInfo = this.wizard.getSettings().getDataSourceContainer().getActualConnectionConfiguration();
        if (connectionInfo != null) {
            Group securityGroup = UIUtils.createControlGroup((Composite)parent, (String)"Security", (int)2, (int)32, (int)0);
            Label infoLabel = new Label((Composite)securityGroup, 0);
            infoLabel.setText("Override user credentials (" + connectionInfo.getUserName() + ") for objects '" + this.wizard.getObjectsName() + "'.\nExternal tools like 'mysqldump' may require different set of permissions.");
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            infoLabel.setLayoutData((Object)gd);
            Button authButton = new Button((Composite)securityGroup, 8);
            authButton.setText("Authentication");
            authButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BaseAuthDialog authDialog = new BaseAuthDialog(MySQLWizardPageSettings.this.getShell(), "Authentication", false, true);
                    authDialog.setUserName(MySQLWizardPageSettings.this.wizard.getSettings().getToolUserName());
                    authDialog.setUserPassword(MySQLWizardPageSettings.this.wizard.getSettings().getToolUserPassword());
                    authDialog.setSavePassword(true);
                    if (authDialog.open() == 0) {
                        MySQLWizardPageSettings.this.wizard.getSettings().setToolUserName(authDialog.getUserName());
                        MySQLWizardPageSettings.this.wizard.getSettings().setToolUserPassword(authDialog.getUserPassword());
                    }
                }
            });
            Button resetButton = new Button((Composite)securityGroup, 8);
            resetButton.setText("Reset to default");
            resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MySQLWizardPageSettings.this.wizard.getSettings().setToolUserName(null);
                    MySQLWizardPageSettings.this.wizard.getSettings().setToolUserPassword(null);
                }
            });
        }
    }
}

