/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.exec;

import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeType;
import org.jkiss.dbeaver.model.data.DBDPseudoReferrer;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.net.DBWForwarder;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.jobs.InvalidateJob;
import org.jkiss.dbeaver.runtime.net.GlobalProxyAuthenticator;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DBExecUtils {
    public static final int DEFAULT_READ_FETCH_SIZE = 10000;
    private static final Log log = Log.getLog(DBExecUtils.class);
    private static final ThreadLocal<DBPDataSourceContainer> ACTIVE_CONTEXT = new ThreadLocal();
    private static final List<DBPDataSourceContainer> ACTIVE_CONTEXTS = new ArrayList<DBPDataSourceContainer>();
    public static final boolean BROWSE_LAZY_ASSOCIATIONS = false;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse;

    public static DBPDataSourceContainer getCurrentThreadContext() {
        return ACTIVE_CONTEXT.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DBPDataSourceContainer> getActiveContexts() {
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            return new ArrayList<DBPDataSourceContainer>(ACTIVE_CONTEXTS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startContextInitiation(DBPDataSourceContainer context) {
        ACTIVE_CONTEXT.set(context);
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            ACTIVE_CONTEXTS.add(context);
        }
        boolean hasProxy = false;
        for (DBWHandlerConfiguration handler : context.getConnectionConfiguration().getHandlers()) {
            if (!handler.isEnabled() || handler.getType() != DBWHandlerType.PROXY) continue;
            hasProxy = true;
            break;
        }
        if (hasProxy) {
            Authenticator.setDefault(new GlobalProxyAuthenticator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishContextInitiation(DBPDataSourceContainer context) {
        ACTIVE_CONTEXT.remove();
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            ACTIVE_CONTEXTS.remove(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBPDataSourceContainer findConnectionContext(String host, int port, String path) {
        DBPDataSourceContainer curContext = DBExecUtils.getCurrentThreadContext();
        if (curContext != null) {
            return DBExecUtils.contextMatches(host, port, curContext) ? curContext : null;
        }
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            for (DBPDataSourceContainer ctx : ACTIVE_CONTEXTS) {
                if (!DBExecUtils.contextMatches(host, port, ctx)) continue;
                return ctx;
            }
        }
        return null;
    }

    private static boolean contextMatches(String host, int port, DBPDataSourceContainer ctx) {
        DBPConnectionConfiguration cfg = ctx.getConnectionConfiguration();
        if (CommonUtils.equalObjects((Object)cfg.getHostName(), (Object)host) && String.valueOf(port).equals(cfg.getHostPort())) {
            return true;
        }
        DBWNetworkHandler[] dBWNetworkHandlerArray = ctx.getActiveNetworkHandlers();
        int n = dBWNetworkHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBWNetworkHandler networkHandler = dBWNetworkHandlerArray[n2];
            if (networkHandler instanceof DBWForwarder && ((DBWForwarder)((Object)networkHandler)).matchesParameters(host, port)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @NotNull
    public static DBPErrorAssistant.ErrorType discoverErrorType(@NotNull DBPDataSource dataSource, @NotNull Throwable error) {
        DBPErrorAssistant errorAssistant = DBUtils.getAdapter(DBPErrorAssistant.class, dataSource);
        if (errorAssistant != null) {
            return ((DBPErrorAssistant)((Object)dataSource)).discoverErrorType(error);
        }
        return DBPErrorAssistant.ErrorType.NORMAL;
    }

    public static <T> boolean tryExecuteRecover(@NotNull T param, @NotNull DBPDataSource dataSource, @NotNull DBRRunnableParametrized<T> runnable) throws DBException {
        int tryCount = 1;
        boolean recoverEnabled = dataSource.getContainer().getPreferenceStore().getBoolean("execute.recover.enabled");
        if (recoverEnabled) {
            tryCount += dataSource.getContainer().getPreferenceStore().getInt("execute.recover.retryCount");
        }
        Throwable lastError = null;
        int i = 0;
        while (i < tryCount) {
            try {
                runnable.run(param);
                lastError = null;
                break;
            }
            catch (InvocationTargetException e) {
                DBPErrorAssistant.ErrorType errorType;
                lastError = e.getTargetException();
                if (!recoverEnabled || (errorType = DBExecUtils.discoverErrorType(dataSource, lastError)) != DBPErrorAssistant.ErrorType.TRANSACTION_ABORTED && errorType != DBPErrorAssistant.ErrorType.CONNECTION_LOST) break;
                DBRProgressMonitor monitor = param instanceof DBRProgressMonitor ? (DBRProgressMonitor)param : (param instanceof DBCSession ? ((DBCSession)param).getProgressMonitor() : new VoidProgressMonitor());
                if (!monitor.isCanceled()) {
                    if (errorType == DBPErrorAssistant.ErrorType.TRANSACTION_ABORTED) {
                        DBCExecutionContext executionContext = null;
                        if (lastError instanceof DBCException) {
                            executionContext = ((DBCException)lastError).getExecutionContext();
                        }
                        if (executionContext != null) {
                            log.debug("Invalidate context [" + executionContext.getDataSource().getContainer().getName() + "/" + executionContext.getContextName() + "] transactions");
                        } else {
                            log.debug("Invalidate datasource [" + dataSource.getContainer().getName() + "] transactions");
                        }
                        InvalidateJob.invalidateTransaction(monitor, dataSource, executionContext);
                    } else {
                        log.debug("Invalidate datasource '" + dataSource.getContainer().getName() + "' connections...");
                        InvalidateJob.invalidateDataSource(monitor, dataSource, false, true, () -> DBWorkbench.getPlatformUI().openConnectionEditor(dataSource.getContainer()));
                        if (i < tryCount - 1) {
                            log.error("Operation failed. Retry count remains = " + (tryCount - i - 1), lastError);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                log.error("Operation interrupted");
                return false;
            }
            ++i;
        }
        if (lastError != null) {
            if (lastError instanceof DBException) {
                throw (DBException)lastError;
            }
            throw new DBException(lastError, dataSource);
        }
        return true;
    }

    public static void setStatementFetchSize(DBCStatement dbStat, long firstRow, long maxRows, int fetchSize) {
        boolean useFetchSize;
        boolean bl = useFetchSize = fetchSize > 0 || dbStat.getSession().getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.fetch.size");
        if (useFetchSize) {
            if (fetchSize <= 0) {
                fetchSize = 10000;
            }
            try {
                dbStat.setResultsFetchSize(firstRow < 0L || maxRows <= 0L ? fetchSize : (int)(firstRow + maxRows));
            }
            catch (Exception e) {
                log.warn(e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static void executeScript(DBRProgressMonitor monitor, DBCExecutionContext executionContext, String jobName, List<DBEPersistAction> persistActions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void checkSmartAutoCommit(DBCSession session, String queryText) {
        DBCTransactionManager txnManager = DBUtils.getTransactionManager(session.getExecutionContext());
        if (txnManager != null) {
            try {
                if (!txnManager.isAutoCommit()) {
                    return;
                }
                SQLDialect sqlDialect = SQLUtils.getDialectFromDataSource(session.getDataSource());
                if (!sqlDialect.isTransactionModifyingQuery(queryText)) {
                    return;
                }
                if (txnManager.isAutoCommit()) {
                    txnManager.setAutoCommit(session.getProgressMonitor(), false);
                }
            }
            catch (DBCException e) {
                log.warn(e);
            }
        }
    }

    public static void setExecutionContextDefaults(DBRProgressMonitor monitor, DBPDataSource dataSource, DBCExecutionContext executionContext, @Nullable String newInstanceName, @Nullable String curInstanceName, @Nullable String newObjectName) throws DBException {
        DBSObjectContainer rootContainer = DBUtils.getAdapter(DBSObjectContainer.class, dataSource);
        if (rootContainer == null) {
            return;
        }
        DBCExecutionContextDefaults contextDefaults = null;
        if (executionContext != null) {
            contextDefaults = executionContext.getContextDefaults();
        }
        if (contextDefaults != null && (contextDefaults.supportsSchemaChange() || contextDefaults.supportsCatalogChange())) {
            DBExecUtils.changeDefaultObject(monitor, rootContainer, contextDefaults, newInstanceName, curInstanceName, newObjectName);
        }
    }

    public static void changeDefaultObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectContainer rootContainer, @NotNull DBCExecutionContextDefaults contextDefaults, @Nullable String newCatalogName, @Nullable String curCatalogName, @Nullable String newObjectName) throws DBException {
        boolean changeCatalog;
        DBSObject newInstance;
        DBSObjectContainer newCatalog = null;
        DBSSchema newSchema = null;
        if (newCatalogName != null && (newInstance = rootContainer.getChild(monitor, newCatalogName)) instanceof DBSCatalog) {
            newCatalog = (DBSCatalog)newInstance;
        }
        if (newObjectName != null) {
            DBSObject newObject = newCatalog == null ? rootContainer.getChild(monitor, newObjectName) : newCatalog.getChild(monitor, newObjectName);
            if (newObject instanceof DBSSchema) {
                newSchema = (DBSSchema)newObject;
            } else if (newObject instanceof DBSCatalog) {
                newCatalog = (DBSCatalog)newObject;
            }
        }
        boolean bl = curCatalogName != null ? !CommonUtils.equalObjects((Object)curCatalogName, (Object)newCatalogName) : (changeCatalog = newCatalog != null);
        if (newCatalog != null && newSchema != null && changeCatalog) {
            contextDefaults.setDefaultCatalog(monitor, newCatalog, newSchema);
        } else if (newSchema != null) {
            contextDefaults.setDefaultSchema(monitor, newSchema);
        } else if (newCatalog != null && changeCatalog) {
            contextDefaults.setDefaultCatalog(monitor, newCatalog, null);
        }
    }

    public static void recoverSmartCommit(DBCExecutionContext executionContext) {
        DBCTransactionManager transactionManager;
        DBPPreferenceStore preferenceStore = executionContext.getDataSource().getContainer().getPreferenceStore();
        if (preferenceStore.getBoolean("transaction.smart.commit") && preferenceStore.getBoolean("transaction.smart.commit.recover") && (transactionManager = DBUtils.getTransactionManager(executionContext)) != null) {
            new AbstractJob("Recover smart commit mode"){

                @Override
                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        if (!transactionManager.isAutoCommit()) {
                            transactionManager.setAutoCommit(monitor, true);
                        }
                    }
                    catch (DBCException e) {
                        return GeneralUtils.makeExceptionStatus(e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static DBSEntityConstraint getBestIdentifier(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity table, DBDAttributeBinding[] bindings, boolean readMetaData) throws DBException {
        ArrayList<DBSEntityConstraint> identifiers = new ArrayList<DBSEntityConstraint>(2);
        if (!(!readMetaData || table instanceof DBSTable && ((DBSTable)table).isView())) {
            Collection<? extends DBSEntityConstraint> constraints;
            block16: {
                if (table instanceof DBSTable) {
                    try {
                        Collection<? extends DBSTableIndex> indexes = ((DBSTable)table).getIndexes(monitor);
                        if (CommonUtils.isEmpty(indexes)) break block16;
                        for (DBSTableIndex dBSTableIndex : indexes) {
                            if (!dBSTableIndex.isPrimary() || !DBUtils.isIdentifierIndex(monitor, dBSTableIndex)) continue;
                            identifiers.add(dBSTableIndex);
                            break;
                        }
                        for (DBSTableIndex dBSTableIndex : indexes) {
                            if (!DBUtils.isIdentifierIndex(monitor, dBSTableIndex)) continue;
                            identifiers.add(dBSTableIndex);
                            break;
                        }
                    }
                    catch (Exception e) {
                        log.debug(e);
                    }
                }
            }
            if ((constraints = table.getConstraints(monitor)) != null) {
                for (DBSEntityConstraint dBSEntityConstraint : constraints) {
                    if (!DBUtils.isIdentifierConstraint(monitor, dBSEntityConstraint)) continue;
                    identifiers.add(dBSEntityConstraint);
                }
            }
        }
        if (CommonUtils.isEmpty(identifiers)) {
            void var6_16;
            DBDAttributeBinding[] dBDAttributeBindingArray = bindings;
            int n = bindings.length;
            boolean bl = false;
            while (var6_16 < n) {
                DBDPseudoAttribute pseudoAttribute;
                DBDAttributeBinding column = dBDAttributeBindingArray[var6_16];
                DBDPseudoAttribute dBDPseudoAttribute = pseudoAttribute = column instanceof DBDAttributeBindingMeta ? ((DBDAttributeBindingMeta)column).getPseudoAttribute() : null;
                if (pseudoAttribute != null && pseudoAttribute.getType() == DBDPseudoAttributeType.ROWID) {
                    identifiers.add(new DBDPseudoReferrer(table, column));
                    break;
                }
                ++var6_16;
            }
        }
        if (CommonUtils.isEmpty(identifiers)) {
            DBVEntity virtualEntity = DBVUtils.getVirtualEntity(table, true);
            identifiers.add(virtualEntity.getBestIdentifier());
        }
        if (!CommonUtils.isEmpty(identifiers)) {
            DBSEntityConstraint uniqueId = null;
            for (DBSEntityConstraint dBSEntityConstraint : identifiers) {
                if (dBSEntityConstraint instanceof DBSEntityReferrer) {
                    DBSEntityReferrer referrer = (DBSEntityReferrer)dBSEntityConstraint;
                    if (!DBExecUtils.isGoodReferrer(monitor, bindings, referrer)) continue;
                    if (referrer.getConstraintType() == DBSEntityConstraintType.PRIMARY_KEY) {
                        return referrer;
                    }
                    if (uniqueId != null || !referrer.getConstraintType().isUnique() && (!(referrer instanceof DBSTableIndex) || !((DBSTableIndex)referrer).isUnique())) continue;
                    uniqueId = referrer;
                    continue;
                }
                uniqueId = dBSEntityConstraint;
            }
            return uniqueId;
        }
        return null;
    }

    private static boolean isGoodReferrer(DBRProgressMonitor monitor, DBDAttributeBinding[] bindings, DBSEntityReferrer referrer) throws DBException {
        if (referrer instanceof DBDPseudoReferrer) {
            return true;
        }
        List<? extends DBSEntityAttributeRef> references = referrer.getAttributeReferences(monitor);
        if (references == null || references.isEmpty()) {
            return referrer instanceof DBVEntityConstraint;
        }
        for (DBSEntityAttributeRef dBSEntityAttributeRef : references) {
            DBDAttributeBinding[] dBDAttributeBindingArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
                if (binding.matches(dBSEntityAttributeRef.getAttribute(), false)) {
                    return true;
                }
                ++n2;
            }
        }
        return true;
    }

    public static DBSEntityAssociation getAssociationByAttribute(DBDAttributeBinding attr) throws DBException {
        List<DBSEntityReferrer> referrers = attr.getReferrers();
        if (referrers != null) {
            for (DBSEntityReferrer referrer : referrers) {
                if (!(referrer instanceof DBSEntityAssociation)) continue;
                return (DBSEntityAssociation)((Object)referrer);
            }
        }
        throw new DBException("Association not found in attribute [" + attr.getName() + "]");
    }

    public static boolean equalAttributes(DBCAttributeMetaData attr1, DBCAttributeMetaData attr2) {
        return attr1 != null && attr2 != null && SQLUtils.compareAliases(attr1.getLabel(), attr2.getLabel()) && SQLUtils.compareAliases(attr1.getName(), attr2.getName()) && CommonUtils.equalObjects((Object)attr1.getEntityMetaData(), (Object)attr2.getEntityMetaData()) && attr1.getOrdinalPosition() == attr2.getOrdinalPosition() && attr1.isRequired() == attr2.isRequired() && attr1.getMaxLength() == attr2.getMaxLength() && CommonUtils.equalObjects((Object)attr1.getPrecision(), (Object)attr2.getPrecision()) && CommonUtils.equalObjects((Object)attr1.getScale(), (Object)attr2.getScale()) && attr1.getTypeID() == attr2.getTypeID() && CommonUtils.equalObjects((Object)attr1.getTypeName(), (Object)attr2.getTypeName());
    }

    public static double makeNumericValue(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public static void bindAttributes(@NotNull DBCSession session, @Nullable DBSEntity sourceEntity, @Nullable DBCResultSet resultSet, @NotNull DBDAttributeBinding[] bindings, @Nullable List<Object[]> rows) throws DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        DBPDataSource dataSource = session.getDataSource();
        boolean readMetaData = dataSource.getContainer().getPreferenceStore().getBoolean("resultset.read.metadata");
        if (!readMetaData && sourceEntity == null) {
            return;
        }
        boolean readReferences = dataSource.getContainer().getPreferenceStore().getBoolean("resultset.read.references");
        IdentityHashMap<DBCEntityMetaData, DBSEntity> entityBindingMap = new IdentityHashMap<DBCEntityMetaData, DBSEntity>();
        monitor.beginTask("Discover resultset metadata", 3);
        try {
            DBDAttributeBinding binding;
            DBCStatement sourceStatement;
            SQLQuery sqlQuery = null;
            DBSEntity entity = null;
            if (sourceEntity != null) {
                entity = sourceEntity;
            } else if (resultSet != null && (sourceStatement = resultSet.getSourceStatement()) != null && sourceStatement.getStatementSource() != null) {
                DBCExecutionSource executionSource = sourceStatement.getStatementSource();
                monitor.subTask("Discover owner entity");
                DBSDataContainer dataContainer = executionSource.getDataContainer();
                if (dataContainer instanceof DBSEntity) {
                    entity = (DBSEntity)((Object)dataContainer);
                }
                DBCEntityMetaData entityMeta = null;
                if (entity == null) {
                    Object sourceDescriptor = executionSource.getSourceDescriptor();
                    if (sourceDescriptor instanceof SQLQuery) {
                        sqlQuery = (SQLQuery)sourceDescriptor;
                        entityMeta = sqlQuery.getSingleSource();
                    }
                    if (entityMeta != null && (entity = DBUtils.getEntityFromMetaData(monitor, session.getExecutionContext(), entityMeta)) != null) {
                        entityBindingMap.put(entityMeta, entity);
                    }
                }
            }
            IdentityHashMap<DBSEntity, DBDRowIdentifier> locatorMap = new IdentityHashMap<DBSEntity, DBDRowIdentifier>();
            monitor.subTask("Discover attributes");
            DBDAttributeBinding[] dBDAttributeBindingArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                binding = dBDAttributeBindingArray[n2];
                monitor.subTask("Discover attribute '" + binding.getName() + "'");
                DBCAttributeMetaData attrMeta = binding.getMetaAttribute();
                if (attrMeta != null) {
                    DBSEntity attrEntity = null;
                    DBCEntityMetaData attrEntityMeta = attrMeta.getEntityMetaData();
                    if (attrEntityMeta != null) {
                        attrEntity = (DBSEntity)entityBindingMap.get(attrEntityMeta);
                        if (attrEntity == null) {
                            attrEntity = entity != null && entity instanceof DBSTable && ((DBSTable)entity).isView() ? entity : DBUtils.getEntityFromMetaData(monitor, session.getExecutionContext(), attrEntityMeta);
                        }
                        if (attrEntity != null) {
                            entityBindingMap.put(attrEntityMeta, attrEntity);
                        }
                    }
                    if (attrEntity == null) {
                        attrEntity = entity;
                    }
                    if (attrEntity == null) {
                        if (attrEntityMeta != null) {
                            log.debug("Table '" + DBUtils.getSimpleQualifiedName(attrEntityMeta.getCatalogName(), attrEntityMeta.getSchemaName(), attrEntityMeta.getEntityName()) + "' not found in metadata catalog");
                        }
                    } else if (binding instanceof DBDAttributeBindingMeta) {
                        DBSEntityAttribute tableColumn;
                        DBDAttributeBindingMeta bindingMeta = (DBDAttributeBindingMeta)binding;
                        DBDPseudoAttribute pseudoAttribute = DBUtils.getPseudoAttribute(attrEntity, attrMeta.getName());
                        if (pseudoAttribute != null) {
                            bindingMeta.setPseudoAttribute(pseudoAttribute);
                        }
                        if ((tableColumn = bindingMeta.getPseudoAttribute() != null ? bindingMeta.getPseudoAttribute().createFakeAttribute(attrEntity, attrMeta) : attrEntity.getAttribute(monitor, attrMeta.getName())) != null && (bindingMeta.getMetaAttribute().getEntityMetaData() != null || !bindingMeta.getDataSource().getInfo().supportsDuplicateColumnsInResults()) && bindingMeta.setEntityAttribute(tableColumn, (sqlQuery == null || tableColumn.getTypeID() != attrMeta.getTypeID()) && rows != null)) {
                            try {
                                int pos = attrMeta.getOrdinalPosition();
                                for (Object[] row : rows) {
                                    row[pos] = binding.getValueHandler().getValueFromObject(session, tableColumn, row[pos], false, false);
                                }
                            }
                            catch (DBCException e) {
                                log.warn("Error resolving attribute '" + binding.getName() + "' values", e);
                            }
                        }
                    }
                }
                ++n2;
            }
            monitor.worked(1);
            monitor.subTask("Detect unique identifiers");
            dBDAttributeBindingArray = bindings;
            n = bindings.length;
            n2 = 0;
            while (n2 < n) {
                binding = dBDAttributeBindingArray[n2];
                if (binding instanceof DBDAttributeBindingMeta) {
                    DBDAttributeBindingMeta bindingMeta = (DBDAttributeBindingMeta)binding;
                    DBSEntityAttribute attr = binding.getEntityAttribute();
                    if (attr == null) {
                        bindingMeta.setRowIdentifierStatus("No corresponding table column");
                    } else {
                        DBSEntity attrEntity = attr.getParentObject();
                        if (attrEntity != null) {
                            DBDRowIdentifier rowIdentifier = (DBDRowIdentifier)locatorMap.get(attrEntity);
                            if (rowIdentifier == null) {
                                DBSEntityConstraint entityIdentifier = DBExecUtils.getBestIdentifier(monitor, attrEntity, bindings, readMetaData);
                                if (entityIdentifier != null) {
                                    rowIdentifier = new DBDRowIdentifier(attrEntity, entityIdentifier);
                                    locatorMap.put(attrEntity, rowIdentifier);
                                } else {
                                    bindingMeta.setRowIdentifierStatus("Cannot determine unique row identifier");
                                }
                            }
                            bindingMeta.setRowIdentifier(rowIdentifier);
                        }
                    }
                }
                ++n2;
            }
            monitor.worked(1);
            if (readMetaData && readReferences && rows != null) {
                monitor.subTask("Read results metadata");
                dBDAttributeBindingArray = bindings;
                n = bindings.length;
                n2 = 0;
                while (n2 < n) {
                    binding = dBDAttributeBindingArray[n2];
                    binding.lateBinding(session, rows);
                    ++n2;
                }
            }
            monitor.subTask("Complete metadata load");
            for (DBDRowIdentifier rowIdentifier : locatorMap.values()) {
                rowIdentifier.reloadAttributes(monitor, bindings);
            }
        }
        finally {
            monitor.done();
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse() {
        if ($SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse != null) {
            return $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse;
        }
        int[] nArray = new int[DBPPlatformUI.UserResponse.values().length];
        try {
            nArray[DBPPlatformUI.UserResponse.CANCEL.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.IGNORE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.IGNORE_ALL.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.OK.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.RETRY.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.STOP.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse = nArray;
        return nArray;
    }
}

