/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskSettings;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DataTransferSettings
implements DBTTaskSettings<DBPObject> {
    private static final Log log = Log.getLog(DataTransferSettings.class);
    public static final int DEFAULT_THREADS_NUM = 1;
    private List<DataTransferPipe> dataPipes;
    private DataTransferNodeDescriptor producer;
    private DataTransferNodeDescriptor consumer;
    private final Map<DataTransferNodeDescriptor, IDataTransferSettings> nodeSettings = new HashMap<DataTransferNodeDescriptor, IDataTransferSettings>();
    private DataTransferProcessorDescriptor processor;
    private Map<DataTransferProcessorDescriptor, Map<Object, Object>> processorPropsHistory = new HashMap<DataTransferProcessorDescriptor, Map<Object, Object>>();
    private boolean producerProcessor;
    private IDataTransferProducer[] initProducers;
    @Nullable
    private IDataTransferConsumer[] initConsumers;
    private final List<DBSObject> initObjects = new ArrayList<DBSObject>();
    private boolean consumerOptional;
    private boolean producerOptional;
    private int maxJobCount = 1;
    private transient int curPipeNum = 0;
    private boolean showFinalMessage = true;

    public DataTransferSettings(@NotNull DBRRunnableContext runnableContext, @Nullable Collection<IDataTransferProducer> producers, @Nullable Collection<IDataTransferConsumer> consumers, @NotNull Map<String, Object> configuration, boolean selectDefaultNodes, boolean isExport) {
        this.initializePipes(producers, consumers, isExport);
        this.loadSettings(runnableContext, configuration);
        if (!selectDefaultNodes) {
            this.producer = null;
            this.consumer = null;
            this.processor = null;
        }
    }

    public DataTransferSettings(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Log taskLog, @NotNull Map<String, Object> configuration) {
        this(runnableContext, DataTransferSettings.getNodesFromLocation(runnableContext, task, taskLog, "producers", IDataTransferProducer.class), DataTransferSettings.getNodesFromLocation(runnableContext, task, taskLog, "consumers", IDataTransferConsumer.class), DataTransferSettings.getTaskOrSavedSettings(task, configuration), !task.getProperties().isEmpty(), DataTransferSettings.isExportTask(task));
    }

    public static boolean isExportTask(DBTTask task) {
        return task.getType().getId().equals("dataExport");
    }

    private static Map<String, Object> getTaskOrSavedSettings(@NotNull DBTTask task, @NotNull Map<String, Object> savedSettings) {
        Map taskSettings = JSONUtils.getObject((Map)task.getProperties(), (String)"configuration");
        if (taskSettings.isEmpty() && !savedSettings.isEmpty()) {
            return savedSettings;
        }
        return taskSettings;
    }

    private void initializePipes(@Nullable Collection<IDataTransferProducer> producers, @Nullable Collection<IDataTransferConsumer> consumers, boolean isExport) {
        int n;
        IDataTransferNode<SETTINGS>[] iDataTransferNodeArray;
        this.initProducers = producers == null ? null : producers.toArray(new IDataTransferProducer[0]);
        this.initConsumers = consumers == null ? null : consumers.toArray(new IDataTransferConsumer[0]);
        this.dataPipes = new ArrayList<DataTransferPipe>();
        this.initObjects.clear();
        this.consumerOptional = false;
        this.producerOptional = false;
        DataTransferRegistry registry = DataTransferRegistry.getInstance();
        if (!ArrayUtils.isEmpty((Object[])this.initProducers) && !ArrayUtils.isEmpty((Object[])this.initConsumers)) {
            if (this.initProducers.length != this.initConsumers.length) {
                throw new IllegalArgumentException("Producers number must match consumers number");
            }
            int i = 0;
            while (i < this.initProducers.length) {
                if (this.initProducers[i].getDatabaseObject() != null) {
                    this.initObjects.add(this.initProducers[i].getDatabaseObject());
                }
                this.dataPipes.add(new DataTransferPipe(this.initProducers[i], this.initConsumers[i]));
                ++i;
            }
            this.consumerOptional = isExport;
            boolean bl = this.producerOptional = !isExport;
            if (this.producerOptional && this.consumerOptional) {
                this.producerOptional = false;
            }
        } else if (!ArrayUtils.isEmpty((Object[])this.initProducers)) {
            iDataTransferNodeArray = this.initProducers;
            n = this.initProducers.length;
            int n2 = 0;
            while (n2 < n) {
                IDataTransferNode source = iDataTransferNodeArray[n2];
                if (source.getDatabaseObject() != null) {
                    this.initObjects.add(source.getDatabaseObject());
                }
                this.dataPipes.add(new DataTransferPipe((IDataTransferProducer)source, null));
                ++n2;
            }
            Class<?> producerType = this.dataPipes.get(0).getProducer().getClass();
            DataTransferNodeDescriptor producerDesc = registry.getNodeByType(producerType);
            if (producerDesc != null) {
                this.selectProducer(producerDesc);
                this.consumerOptional = true;
            } else {
                DBWorkbench.getPlatformUI().showError(DTMessages.data_transfer_settings_title_find_producer, DTMessages.data_transfer_settings_message_find_data_producer);
            }
        } else if (!ArrayUtils.isEmpty((Object[])this.initConsumers)) {
            iDataTransferNodeArray = this.initConsumers;
            n = this.initConsumers.length;
            int producerDesc = 0;
            while (producerDesc < n) {
                IDataTransferNode target = iDataTransferNodeArray[producerDesc];
                if (target.getDatabaseObject() != null) {
                    this.initObjects.add(target.getDatabaseObject());
                }
                this.dataPipes.add(new DataTransferPipe(null, (IDataTransferConsumer)target));
                ++producerDesc;
            }
            Class<?> consumerType = this.dataPipes.get(0).getConsumer().getClass();
            DataTransferNodeDescriptor consumerDesc = registry.getNodeByType(consumerType);
            if (consumerDesc != null) {
                this.selectConsumer(consumerDesc, null, false);
                this.consumerOptional = false;
            } else {
                DBWorkbench.getPlatformUI().showError(DTMessages.data_transfer_settings_title_find_consumer, DTMessages.data_transfer_settings_message_find_data_consumer);
            }
            this.producerOptional = true;
        } else {
            this.consumerOptional = true;
            this.producerOptional = true;
        }
        if (!ArrayUtils.isEmpty((Object[])this.initConsumers)) {
            iDataTransferNodeArray = this.initConsumers;
            n = this.initConsumers.length;
            int n3 = 0;
            while (n3 < n) {
                IDataTransferNode target = iDataTransferNodeArray[n3];
                DataTransferNodeDescriptor node = registry.getNodeByType(target.getClass());
                if (node != null) {
                    this.consumer = node;
                }
                ++n3;
            }
        }
    }

    public void loadSettings(DBRRunnableContext runnableContext, Map<String, Object> config) {
        String processorId;
        DataTransferNodeDescriptor producerNode;
        String producerId;
        DataTransferNodeDescriptor consumerNode;
        this.setMaxJobCount(CommonUtils.toInt((Object)config.get("maxJobCount"), (int)1));
        this.setShowFinalMessage(CommonUtils.getBoolean((Object)config.get("showFinalMessage"), (boolean)this.isShowFinalMessage()));
        DataTransferNodeDescriptor savedConsumer = null;
        DataTransferNodeDescriptor savedProducer = null;
        DataTransferNodeDescriptor processorNode = null;
        String consumerId = CommonUtils.toString((Object)config.get("consumer"));
        if (!CommonUtils.isEmpty((String)consumerId) && (consumerNode = DataTransferRegistry.getInstance().getNodeById(consumerId)) != null) {
            if (this.consumer == null) {
                savedConsumer = consumerNode;
                this.setConsumer(consumerNode);
            } else {
                savedConsumer = this.consumer;
            }
            if (this.isConsumerOptional()) {
                processorNode = consumerNode;
            }
        }
        if (!CommonUtils.isEmpty((String)(producerId = CommonUtils.toString((Object)config.get("producer")))) && (producerNode = DataTransferRegistry.getInstance().getNodeById(producerId)) != null) {
            if (this.producer == null) {
                savedProducer = producerNode;
                this.setProducer(producerNode);
            } else {
                savedProducer = this.producer;
            }
            if (this.isProducerOptional()) {
                processorNode = producerNode;
            }
        }
        DataTransferProcessorDescriptor savedProcessor = null;
        if (processorNode != null && !CommonUtils.isEmpty((String)(processorId = CommonUtils.toString((Object)config.get("processor"))))) {
            savedProcessor = processorNode.getProcessor(processorId);
        }
        if (this.consumerOptional && savedConsumer != null) {
            this.selectConsumer(savedConsumer, savedProcessor, false);
        }
        if (this.producerOptional && savedProducer != null) {
            this.selectProducer(savedProducer, savedProcessor, false);
        }
        Map processorsSection = JSONUtils.getObject(config, (String)"processors");
        for (Map.Entry procIter : processorsSection.entrySet()) {
            int divPos;
            Map procSection = (Map)procIter.getValue();
            String processorId2 = (String)procIter.getKey();
            String nodeId = CommonUtils.toString(procSection.get("@node"));
            if (CommonUtils.isEmpty((String)nodeId) && (divPos = processorId2.indexOf(58)) != -1) {
                nodeId = processorId2.substring(0, divPos);
                processorId2 = processorId2.substring(divPos + 1);
            }
            String propNamesId = CommonUtils.toString(procSection.get("@propNames"));
            DataTransferNodeDescriptor node = DataTransferRegistry.getInstance().getNodeById(nodeId);
            if (node == null) continue;
            HashMap props = new HashMap();
            DataTransferProcessorDescriptor nodeProcessor = node.getProcessor(processorId2);
            if (nodeProcessor == null) continue;
            for (String prop : CommonUtils.splitString((String)propNamesId, (char)',')) {
                props.put(prop, procSection.get(prop));
            }
            this.processorPropsHistory.put(nodeProcessor, props);
        }
        LinkedHashMap<String, DataTransferNodeDescriptor> nodeNames = new LinkedHashMap<String, DataTransferNodeDescriptor>();
        if (this.producer != null) {
            nodeNames.put(this.producer.getNodeClass().getSimpleName(), this.producer);
        }
        if (this.consumer != null) {
            nodeNames.put(this.consumer.getNodeClass().getSimpleName(), this.consumer);
        }
        for (Map.Entry node : nodeNames.entrySet()) {
            Map nodeSection = JSONUtils.getObject(config, (String)((String)node.getKey()));
            IDataTransferSettings nodeSettings = this.getNodeSettings((DataTransferNodeDescriptor)((Object)node.getValue()));
            if (nodeSettings == null) continue;
            nodeSettings.loadSettings(runnableContext, this, nodeSection);
        }
    }

    public boolean isConsumerOptional() {
        return this.consumerOptional;
    }

    public boolean isProducerOptional() {
        return this.producerOptional;
    }

    public IDataTransferProducer[] getInitProducers() {
        return this.initProducers;
    }

    @Nullable
    public IDataTransferConsumer[] getInitConsumers() {
        return this.initConsumers;
    }

    public List<DBSObject> getSourceObjects() {
        return this.initObjects;
    }

    @Nullable
    public IDataTransferSettings getNodeSettings(DataTransferNodeDescriptor node) {
        IDataTransferSettings settings = this.nodeSettings.get((Object)node);
        if (settings == null) {
            try {
                settings = node.createSettings();
            }
            catch (DBException e) {
                log.error((Object)e);
                return null;
            }
            this.nodeSettings.put(node, settings);
        }
        return settings;
    }

    public Map<DataTransferProcessorDescriptor, Map<Object, Object>> getProcessorPropsHistory() {
        return this.processorPropsHistory;
    }

    public Map<Object, Object> getProcessorProperties() {
        if (this.processor == null) {
            log.debug((Object)"No processor selected - no properties");
            return null;
        }
        return this.processorPropsHistory.get((Object)this.processor);
    }

    public void setProcessorProperties(Map<Object, Object> properties) {
        if (this.processor == null) {
            throw new IllegalStateException("No processor selected");
        }
        this.processorPropsHistory.put(this.processor, properties);
    }

    public List<DataTransferPipe> getDataPipes() {
        return this.dataPipes;
    }

    public synchronized DataTransferPipe acquireDataPipe(DBRProgressMonitor monitor) {
        if (this.curPipeNum >= this.dataPipes.size()) {
            if (!this.dataPipes.isEmpty()) {
                this.dataPipes.get(this.dataPipes.size() - 1).getConsumer().finishTransfer(monitor, true);
            }
            return null;
        }
        DataTransferPipe result = this.dataPipes.get(this.curPipeNum);
        ++this.curPipeNum;
        return result;
    }

    public DataTransferNodeDescriptor getProducer() {
        return this.producer;
    }

    public void setProducer(DataTransferNodeDescriptor producer) {
        this.producer = producer;
    }

    public DataTransferNodeDescriptor getConsumer() {
        return this.consumer;
    }

    public void setConsumer(DataTransferNodeDescriptor consumer) {
        this.consumer = consumer;
    }

    public DataTransferProcessorDescriptor getProcessor() {
        return this.processor;
    }

    public boolean isProducerProcessor() {
        return this.producerProcessor;
    }

    private void selectProducer(DataTransferNodeDescriptor producer) {
        this.producer = producer;
    }

    public void selectConsumer(DataTransferNodeDescriptor consumer, DataTransferProcessorDescriptor processor, boolean rewrite) {
        this.consumer = consumer;
        this.processor = processor;
        this.producerProcessor = false;
        if (consumer != null && processor != null && !this.processorPropsHistory.containsKey((Object)processor)) {
            this.processorPropsHistory.put(processor, new HashMap());
        }
        int i = 0;
        while (i < this.dataPipes.size()) {
            DataTransferPipe pipe = this.dataPipes.get(i);
            if (rewrite || pipe.getConsumer() == null) {
                if (consumer != null) {
                    try {
                        IDataTransferConsumer consumerNode = (IDataTransferConsumer)consumer.createNode();
                        pipe.setConsumer(consumerNode);
                    }
                    catch (DBException e) {
                        log.error((Object)e);
                        pipe.setConsumer(null);
                    }
                } else {
                    pipe.setConsumer(null);
                }
            }
            ++i;
        }
    }

    public void selectProducer(DataTransferNodeDescriptor producer, DataTransferProcessorDescriptor processor, boolean rewrite) {
        this.producer = producer;
        this.processor = processor;
        if (producer != null && processor != null) {
            this.producerProcessor = true;
            if (!this.processorPropsHistory.containsKey((Object)processor)) {
                this.processorPropsHistory.put(processor, new HashMap());
            }
        }
        for (DataTransferPipe pipe : this.dataPipes) {
            if (!rewrite && pipe.getProducer() != null) continue;
            if (producer != null) {
                try {
                    pipe.setProducer((IDataTransferProducer)producer.createNode());
                }
                catch (DBException e) {
                    log.error((Object)e);
                    pipe.setProducer(null);
                }
                continue;
            }
            pipe.setProducer(null);
        }
    }

    public int getMaxJobCount() {
        return this.maxJobCount;
    }

    public void setMaxJobCount(int maxJobCount) {
        if (maxJobCount > 0) {
            this.maxJobCount = maxJobCount;
        }
    }

    public boolean isShowFinalMessage() {
        return this.showFinalMessage;
    }

    public void setShowFinalMessage(boolean showFinalMessage) {
        this.showFinalMessage = showFinalMessage;
    }

    public static void saveNodesLocation(DBRRunnableContext runnableContext, DBTTask task, Map<String, Object> state, Collection<IDataTransferNode> nodes, String nodeType) {
        if (nodes != null) {
            ArrayList<Map> inputObjects = new ArrayList<Map>();
            for (IDataTransferNode inputObject : nodes) {
                inputObjects.add(JSONUtils.serializeObject((DBRRunnableContext)runnableContext, (Object)task, (Object)inputObject));
            }
            state.put(nodeType, inputObjects);
        }
    }

    public static <T> List<T> getNodesFromLocation(@NotNull DBRRunnableContext runnableContext, DBTTask task, Log taskLog, String nodeType, Class<T> nodeClass) {
        Map config = task.getProperties();
        ArrayList<T> result = new ArrayList<T>();
        Object nodeList = config.get(nodeType);
        if (nodeList instanceof Collection) {
            for (Object nodeObj : (Collection)nodeList) {
                if (!(nodeObj instanceof Map)) continue;
                try {
                    Object node = JSONUtils.deserializeObject((DBRRunnableContext)runnableContext, (Object)task, (Map)((Map)nodeObj));
                    if (!nodeClass.isInstance(node)) continue;
                    result.add(nodeClass.cast(node));
                }
                catch (DBCException e) {
                    if (!DBWorkbench.getPlatform().getApplication().isHeadlessMode()) {
                        DBWorkbench.getPlatformUI().showError(DTMessages.data_transfer_settings_title_configuration_error, DTMessages.data_transfer_settings_message_error_reading_task_configuration, (Throwable)e);
                    }
                    taskLog.error((Object)e);
                }
            }
        }
        return result;
    }

    public void clearDataPipes() {
        this.dataPipes.clear();
        this.initObjects.clear();
        this.initProducers = new IDataTransferProducer[0];
        this.initConsumers = new IDataTransferConsumer[0];
    }

    public void setDataPipes(List<DataTransferPipe> dataPipes, boolean isExport) {
        this.dataPipes = dataPipes;
        DataTransferRegistry registry = DataTransferRegistry.getInstance();
        this.consumerOptional = isExport;
        this.producerOptional = !isExport;
        this.producer = null;
        this.consumer = null;
        if (!dataPipes.isEmpty()) {
            DataTransferPipe pipe = dataPipes.get(0);
            this.producer = pipe.getProducer() == null ? null : registry.getNodeByType(pipe.getProducer().getClass());
            this.consumer = pipe.getConsumer() == null ? null : registry.getNodeByType(pipe.getConsumer().getClass());
        }
        DataTransferProcessorDescriptor savedProcessor = this.processor;
        if (this.consumerOptional && this.consumer != null) {
            this.selectConsumer(this.consumer, savedProcessor, false);
        }
        if (this.producerOptional && this.producer != null) {
            this.selectProducer(this.producer, savedProcessor, false);
        }
        this.initObjects.clear();
        for (DataTransferPipe pipe : dataPipes) {
            DBSObject object;
            DBSObject dBSObject = object = isExport ? pipe.getProducer().getDatabaseObject() : pipe.getConsumer().getDatabaseObject();
            if (object == null) continue;
            this.initObjects.add(object);
        }
    }
}

