/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.generator;

import java.util.Collection;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.generator.SQLGeneratorResultSet;

public class SQLGeneratorInsertFromData
extends SQLGeneratorResultSet {
    @Override
    public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, IResultSetController object) {
        for (ResultSetRow firstRow : this.getSelectedRows()) {
            Collection<? extends DBSAttributeBase> allAttributes = this.getAllAttributes(monitor, object);
            sql.append("INSERT INTO ").append(this.getEntityName(this.getSingleEntity()));
            sql.append(this.getLineSeparator()).append("(");
            boolean hasAttr = false;
            for (DBSAttributeBase dBSAttributeBase : allAttributes) {
                if (DBUtils.isPseudoAttribute((DBSAttributeBase)dBSAttributeBase) || DBUtils.isHiddenObject((Object)dBSAttributeBase)) continue;
                if (hasAttr) {
                    sql.append(", ");
                }
                sql.append(DBUtils.getObjectFullName((DBPNamedObject)dBSAttributeBase, (DBPEvaluationContext)DBPEvaluationContext.DML));
                hasAttr = true;
            }
            sql.append(")").append(this.getLineSeparator()).append("VALUES(");
            hasAttr = false;
            for (DBSAttributeBase dBSAttributeBase : allAttributes) {
                DBDAttributeBinding binding;
                if (DBUtils.isPseudoAttribute((DBSAttributeBase)dBSAttributeBase) || DBUtils.isHiddenObject((Object)dBSAttributeBase)) continue;
                if (hasAttr) {
                    sql.append(", ");
                }
                if ((binding = this.getController().getModel().getAttributeBinding(dBSAttributeBase)) == null) {
                    this.appendDefaultValue(sql, dBSAttributeBase);
                } else {
                    this.appendAttributeValue(this.getController(), sql, binding, firstRow);
                }
                hasAttr = true;
            }
            sql.append(");\n");
        }
    }
}

