/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.AuthModelPgPassCredentials;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class AuthModelPgPass
extends AuthModelDatabaseNative<AuthModelPgPassCredentials> {
    private static final Log log = Log.getLog(AuthModelPgPass.class);
    public static final String PGPASSFILE_ENV_VARIABLE = "PGPASSFILE";

    @NotNull
    public AuthModelPgPassCredentials createCredentials() {
        return new AuthModelPgPassCredentials();
    }

    @NotNull
    public AuthModelPgPassCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        AuthModelPgPassCredentials credentials = (AuthModelPgPassCredentials)super.loadCredentials(dataSource, configuration);
        try {
            this.loadPasswordFromPgPass(credentials, configuration);
            credentials.setParseError(null);
        }
        catch (DBException e) {
            credentials.setParseError((Exception)((Object)e));
        }
        return credentials;
    }

    public void initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, AuthModelPgPassCredentials credentials, DBPConnectionConfiguration configuration, @NotNull Properties connectProps) throws DBException {
        if (credentials.getParseError() != null) {
            throw new DBCException("Couldn't get password from PGPASS file", (Throwable)credentials.getParseError());
        }
        super.initAuthentication(monitor, dataSource, (AuthModelDatabaseNativeCredentials)credentials, configuration, connectProps);
    }

    /*
     * Unable to fully structure code
     */
    private void loadPasswordFromPgPass(AuthModelPgPassCredentials credentials, DBPConnectionConfiguration configuration) throws DBException {
        pgPassPath = System.getenv("PGPASSFILE");
        if (CommonUtils.isEmpty((String)pgPassPath)) {
            if (RuntimeUtils.isPlatformWindows()) {
                appData = System.getenv("AppData");
                if (appData == null) {
                    appData = System.getProperty("user.home");
                }
                pgPassPath = String.valueOf(appData) + "/postgresql/pgpass.conf";
            } else {
                pgPassPath = String.valueOf(System.getProperty("user.home")) + "/.pgpass";
            }
        }
        if (!(pgPassFile = new File(pgPassPath)).exists()) {
            throw new DBException("PgPass file '" + pgPassFile.getAbsolutePath() + "' not found");
        }
        try {
            var5_5 = null;
            var6_8 = null;
            try {
                r = new InputStreamReader((InputStream)new FileInputStream(pgPassFile), GeneralUtils.UTF8_CHARSET);
                try {
                    passString = IOUtils.readToString((Reader)r);
                    var13_13 = lines = passString.split("\n");
                    var12_14 = lines.length;
                    var11_15 = 0;
                    while (true) {
                        line = var13_13[var11_15];
                        if (!(line = line.trim()).isEmpty() && !line.startsWith("#") && (params = line.split(":")).length >= 5) {
                            host = params[0];
                            port = params[1];
                            database = params[2];
                            user = params[3];
                            password = params[4];
                            if (AuthModelPgPass.matchParam(configuration.getHostName(), host) && AuthModelPgPass.matchParam(configuration.getHostPort(), port) && AuthModelPgPass.matchParam(configuration.getDatabaseName(), database) && AuthModelPgPass.matchParam(configuration.getUserName(), user)) {
                                if (!user.equals("*")) {
                                    configuration.setUserName(user);
                                }
                                credentials.setUserPassword(password);
                                return;
                            }
                        }
                        ++var11_15;
                        break;
                    }
                }
                finally {
                    if (var11_15 < var12_14) ** continue;
                }
            }
            catch (Throwable var6_9) {
                if (var5_5 == null) {
                    var5_5 = var6_9;
                } else if (var5_5 != var6_9) {
                    var5_5.addSuppressed(var6_9);
                }
                throw var5_5;
            }
        }
        catch (IOException e) {
            throw new DBException("Error reading pgpass", (Throwable)e);
        }
        throw new DBException("No matches in pgpass");
    }

    private static boolean matchParam(String cfgParam, String passParam) {
        return passParam.equals("*") || passParam.equalsIgnoreCase(cfgParam);
    }
}

