/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.requests;

import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class AlignmentRequest
extends ChangeBoundsRequest {
    private int alignment;
    private Rectangle alignmentRect;

    public AlignmentRequest() {
    }

    public AlignmentRequest(Object type) {
        super(type);
    }

    private void doNormalAlignment(Rectangle result, Rectangle reference) {
        switch (this.alignment) {
            case 1: {
                result.x = reference.x;
                break;
            }
            case 4: {
                result.x = reference.x + reference.width - result.width;
                break;
            }
            case 8: {
                result.y = reference.y;
                break;
            }
            case 32: {
                result.y = reference.y + reference.height - result.height;
                break;
            }
            case 2: {
                result.x = reference.x + reference.width / 2 - result.width / 2;
                break;
            }
            case 16: {
                result.y = reference.y + reference.height / 2 - result.height / 2;
            }
        }
    }

    private void doPrecisionAlignment(PrecisionRectangle result, PrecisionRectangle reference) {
        switch (this.alignment) {
            case 1: {
                result.setPreciseX(reference.preciseX());
                break;
            }
            case 4: {
                result.setPreciseX(reference.preciseX() + reference.preciseWidth() - result.preciseWidth());
                break;
            }
            case 8: {
                result.setPreciseY(reference.preciseY());
                break;
            }
            case 32: {
                result.setPreciseY(reference.preciseY() + reference.preciseHeight() - result.preciseHeight());
                break;
            }
            case 2: {
                result.setPreciseX(reference.preciseX() + reference.preciseWidth() / 2.0 - result.preciseWidth() / 2.0);
                break;
            }
            case 16: {
                result.setPreciseY(reference.preciseY() + reference.preciseHeight() / 2.0 - result.preciseHeight() / 2.0);
            }
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public Rectangle getAlignmentRectangle() {
        return this.alignmentRect;
    }

    public Rectangle getTransformedRectangle(Rectangle rect) {
        Rectangle result = rect.getCopy();
        Rectangle reference = this.getAlignmentRectangle();
        if (result instanceof PrecisionRectangle) {
            if (reference instanceof PrecisionRectangle) {
                this.doPrecisionAlignment((PrecisionRectangle)result, (PrecisionRectangle)reference);
            } else {
                this.doPrecisionAlignment((PrecisionRectangle)result, new PrecisionRectangle(reference));
            }
        } else {
            this.doNormalAlignment(result, reference);
        }
        return result;
    }

    public void setAlignment(int align) {
        this.alignment = align;
    }

    public void setAlignmentRectangle(Rectangle rect) {
        this.alignmentRect = rect;
    }
}

