/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.util.Date;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.utils.CommonUtils;

public class DataExporterTXT
extends StreamExporterAbstract {
    private static final String PROP_MAX_COLUMN_LENGTH = "maxColumnLength";
    private static final String PROP_SHOW_NULLS = "showNulls";
    private static final String PROP_DELIM_LEADING = "delimLeading";
    private static final String PROP_DELIM_HEADER = "delimHeader";
    private static final String PROP_DELIM_TRAILING = "delimTrailing";
    private DBDAttributeBinding[] columns;
    private String tableName;
    private int maxColumnSize = 100;
    private int minColumnSize = 3;
    private boolean showNulls;
    private boolean delimLeading;
    private boolean delimHeader;
    private boolean delimTrailing;
    private int[] colWidths;

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        super.init(site);
        Map<String, Object> properties = site.getProperties();
        this.maxColumnSize = CommonUtils.toInt((Object)properties.get(PROP_MAX_COLUMN_LENGTH), (int)100);
        this.showNulls = CommonUtils.getBoolean((Object)properties.get(PROP_SHOW_NULLS), (boolean)false);
        this.delimLeading = CommonUtils.getBoolean((Object)properties.get(PROP_DELIM_LEADING), (boolean)true);
        this.delimHeader = CommonUtils.getBoolean((Object)properties.get(PROP_DELIM_HEADER), (boolean)true);
        this.delimTrailing = CommonUtils.getBoolean((Object)properties.get(PROP_DELIM_TRAILING), (boolean)true);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void exportHeader(DBCSession session) {
        this.columns = this.getSite().getAttributes();
        this.printHeader();
    }

    private static String getAttributeName(DBDAttributeBinding attr) {
        if (CommonUtils.isEmpty((String)attr.getLabel())) {
            return attr.getName();
        }
        return attr.getLabel();
    }

    private void printHeader() {
        this.colWidths = new int[this.columns.length];
        int i = 0;
        while (i < this.columns.length) {
            DBDAttributeBinding attr = this.columns[i];
            int maxLength = (int)attr.getMaxLength();
            if (attr.getDataKind() == DBPDataKind.DATETIME) {
                maxLength = this.getCellString(attr, new Date(), DBDDisplayFormat.EDIT).length();
            }
            this.colWidths[i] = Math.max(DataExporterTXT.getAttributeName(attr).length(), maxLength);
            ++i;
        }
        i = 0;
        while (i < this.colWidths.length) {
            if (this.colWidths[i] > this.maxColumnSize) {
                this.colWidths[i] = this.maxColumnSize;
            } else if (this.colWidths[i] < this.minColumnSize) {
                this.colWidths[i] = this.minColumnSize;
            }
            ++i;
        }
        StringBuilder txt = new StringBuilder();
        if (this.delimLeading) {
            txt.append("|");
        }
        int i2 = 0;
        while (i2 < this.columns.length) {
            if (i2 > 0) {
                txt.append("|");
            }
            DBDAttributeBinding attr = this.columns[i2];
            String attrName = DataExporterTXT.getAttributeName(attr);
            txt.append(attrName);
            int k = this.colWidths[i2] - attrName.length();
            while (k > 0) {
                txt.append(" ");
                --k;
            }
            ++i2;
        }
        if (this.delimTrailing) {
            txt.append("|");
        }
        txt.append("\n");
        if (this.delimHeader) {
            if (this.delimLeading) {
                txt.append("|");
            }
            i2 = 0;
            while (i2 < this.columns.length) {
                if (i2 > 0) {
                    txt.append("|");
                }
                int k = this.colWidths[i2];
                while (k > 0) {
                    txt.append("-");
                    --k;
                }
                ++i2;
            }
            if (this.delimTrailing) {
                txt.append("|");
            }
            txt.append("\n");
        }
        this.getWriter().print(txt);
    }

    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) {
        StringBuilder txt = new StringBuilder();
        if (this.delimLeading) {
            txt.append("|");
        }
        int k = 0;
        while (k < this.columns.length) {
            DBDAttributeBinding attr;
            String displayString;
            if (k > 0) {
                txt.append("|");
            }
            if ((displayString = this.getCellString(attr = this.columns[k], row[k], DBDDisplayFormat.EDIT)).length() > this.colWidths[k]) {
                displayString = CommonUtils.truncateString((String)displayString, (int)this.colWidths[k]);
            }
            txt.append(displayString);
            int j = this.colWidths[k] - displayString.length();
            while (j > 0) {
                txt.append(" ");
                --j;
            }
            ++k;
        }
        if (this.delimTrailing) {
            txt.append("|");
        }
        txt.append("\n");
        this.getWriter().print(txt);
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) {
    }

    private String getCellString(DBDAttributeBinding attr, Object value, DBDDisplayFormat displayFormat) {
        String displayString = attr.getValueHandler().getValueDisplayString((DBSTypedObject)attr, value, displayFormat);
        if (this.showNulls && displayString.isEmpty() && DBUtils.isNullValue((Object)value)) {
            return "[NULL]";
        }
        return CommonUtils.getSingleLineString((String)displayString);
    }
}

