/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.runtime;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.BlockCanceler;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractJob
extends Job {
    private static final Log log = Log.getLog(AbstractJob.class);
    public static final int TIMEOUT_BEFORE_BLOCK_CANCEL = 250;
    private DBRProgressMonitor progressMonitor;
    private volatile boolean finished = false;
    private volatile boolean blockCanceled = false;
    private volatile long cancelTimestamp = -1L;
    private AbstractJob attachedJob = null;
    protected static final ThreadLocal<AbstractJob> CURRENT_JOB = new ThreadLocal();

    protected AbstractJob(String name) {
        super(name);
    }

    public boolean isFinished() {
        return this.finished;
    }

    protected Thread getActiveThread() {
        Thread thread = this.getThread();
        return thread == null ? Thread.currentThread() : thread;
    }

    public void setAttachedJob(AbstractJob attachedJob) {
        this.attachedJob = attachedJob;
    }

    public final IStatus runDirectly(DBRProgressMonitor monitor) {
        this.progressMonitor = monitor;
        this.blockCanceled = false;
        try {
            IStatus result;
            this.finished = false;
            try {
                result = this.run(this.progressMonitor);
            }
            catch (Throwable e) {
                result = GeneralUtils.makeExceptionStatus(e);
            }
            IStatus iStatus = result;
            return iStatus;
        }
        finally {
            this.finished = true;
        }
    }

    protected final IStatus run(IProgressMonitor monitor) {
        this.progressMonitor = RuntimeUtils.makeMonitor(monitor);
        this.blockCanceled = false;
        CURRENT_JOB.set(this);
        Thread currentThread = Thread.currentThread();
        String oldThreadName = currentThread.getName();
        try {
            this.finished = false;
            RuntimeUtils.setThreadName(this.getName());
            IStatus result = this.run(this.progressMonitor);
            if (!this.logErrorStatus(result) && !result.isOK() && result != Status.CANCEL_STATUS) {
                log.error("Error running job '" + this.getName() + "' execution: " + result.getMessage());
            }
            IStatus iStatus = result;
            return iStatus;
        }
        catch (Throwable e) {
            log.error(e);
            IStatus iStatus = GeneralUtils.makeExceptionStatus(e);
            return iStatus;
        }
        finally {
            CURRENT_JOB.remove();
            this.finished = true;
            currentThread.setName(oldThreadName);
        }
    }

    private boolean logErrorStatus(IStatus status) {
        if (status.getException() != null) {
            log.error("Error during job '" + this.getName() + "' execution", status.getException());
            return true;
        }
        if (status instanceof MultiStatus) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus cStatus = iStatusArray[n2];
                if (this.logErrorStatus(cStatus)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected abstract IStatus run(DBRProgressMonitor var1);

    public boolean isCanceled() {
        return this.cancelTimestamp > 0L;
    }

    public long getCancelTimestamp() {
        return this.cancelTimestamp;
    }

    protected void canceling() {
        if (this.cancelTimestamp == -1L) {
            this.cancelTimestamp = System.currentTimeMillis();
        }
        if (this.attachedJob != null) {
            this.attachedJob.canceling();
            return;
        }
        if (!this.blockCanceled) {
            this.runBlockCanceler();
        }
    }

    private void runBlockCanceler() {
        final ArrayList activeBlocks = new ArrayList(CommonUtils.safeList(this.progressMonitor.getActiveBlocks()));
        if (activeBlocks.isEmpty()) {
            return;
        }
        DBRBlockingObject lastBlock = (DBRBlockingObject)activeBlocks.remove(activeBlocks.size() - 1);
        try {
            new JobCanceler(lastBlock).schedule();
        }
        catch (Exception e) {
            log.debug(e);
        }
        if (!activeBlocks.isEmpty()) {
            DBPPreferenceStore preferenceStore;
            if (activeBlocks.get(0) instanceof DBCSession) {
                DBPDataSource dataSource = ((DBCSession)activeBlocks.get(0)).getDataSource();
                if (dataSource == null) {
                    return;
                }
                preferenceStore = dataSource.getContainer().getPreferenceStore();
            } else {
                preferenceStore = ModelPreferences.getPreferences();
            }
            final int cancelCheckTimeout = preferenceStore.getInt("execute.cancel.checkTimeout");
            if (cancelCheckTimeout > 0) {
                Job cancelChecker = new Job("Cancel checker block"){
                    {
                        super($anonymous0);
                        this.setSystem(true);
                        this.setUser(false);
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        if (!AbstractJob.this.finished) {
                            DBRBlockingObject nextBlock = (DBRBlockingObject)activeBlocks.remove(activeBlocks.size() - 1);
                            new JobCanceler(nextBlock).schedule();
                            if (!activeBlocks.isEmpty()) {
                                this.schedule(cancelCheckTimeout);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                cancelChecker.schedule((long)cancelCheckTimeout);
            }
        }
    }

    private class JobCanceler
    extends Job {
        private final DBRBlockingObject block;

        public JobCanceler(DBRBlockingObject block) {
            super("Cancel block " + block);
            this.block = block;
            this.setSystem(true);
            this.setUser(false);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (!AbstractJob.this.finished) {
                try {
                    BlockCanceler.cancelBlock(AbstractJob.this.progressMonitor, this.block, AbstractJob.this.getActiveThread());
                }
                catch (DBException e) {
                    log.debug("Block cancel error", e);
                    return GeneralUtils.makeExceptionStatus(e);
                }
                catch (Throwable e) {
                    log.debug("Block cancel internal error", e);
                    return Status.CANCEL_STATUS;
                }
                AbstractJob.this.blockCanceled = true;
            }
            return Status.OK_STATUS;
        }
    }
}

