/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui.editors;

import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTrigger;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.editors.sql.SQLSourceViewer;
import org.jkiss.utils.CommonUtils;

public class PostgreSourceViewEditor
extends SQLSourceViewer<PostgreScriptObject> {
    private static final String PROP_SHOW_PERMISSIONS = "pg.source.editor.showPermissions";
    private static final String PROP_COLUMN_COMMENTS = "pg.source.editor.showColumnComments";
    private static final String PROP_FULL_DDL = "pg.source.editor.showFullDDL";
    private Boolean showPermissions;
    private Boolean showColumnComments;
    private Boolean showFullDDL;

    protected boolean isReadOnly() {
        PostgreScriptObject sourceObject = (PostgreScriptObject)this.getSourceObject();
        return !(sourceObject instanceof PostgreProcedure) && !(sourceObject instanceof PostgreTrigger) && !(sourceObject instanceof PostgreViewBase);
    }

    private boolean getShowPermissions() {
        if (this.showPermissions == null) {
            this.showPermissions = this.getPreferenceStore().getBoolean(PROP_SHOW_PERMISSIONS);
        }
        return this.showPermissions;
    }

    private Boolean getShowColumnComments() {
        if (this.showColumnComments == null) {
            this.showColumnComments = this.getPreferenceStore().getBoolean(PROP_COLUMN_COMMENTS);
        }
        return this.showColumnComments;
    }

    private Boolean getShowFullDDL() {
        if (this.showFullDDL == null) {
            this.showFullDDL = this.getPreferenceStore().getBoolean(PROP_FULL_DDL);
        }
        return this.showFullDDL;
    }

    protected boolean isAnnotationRulerVisible() {
        return this.getSourceObject() instanceof PostgreProcedure;
    }

    protected void setSourceText(DBRProgressMonitor monitor, String sourceText) {
        this.getInputPropertySource().setPropertyValue(monitor, "objectDefinitionText", (Object)sourceText);
    }

    protected void contributeEditorCommands(IContributionManager contributionManager) {
        super.contributeEditorCommands(contributionManager);
        PostgreScriptObject sourceObject = (PostgreScriptObject)this.getSourceObject();
        if (sourceObject instanceof PostgreSchema) {
            contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action("Show full DDL", 2){
                {
                    this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_TABLE_EXTERNAL));
                    this.setToolTipText("Show DDL for all schema objects");
                    this.setChecked(PostgreSourceViewEditor.this.getShowFullDDL());
                }

                public void run() {
                    PostgreSourceViewEditor.this.showFullDDL = this.isChecked();
                    PostgreSourceViewEditor.this.getPreferenceStore().setValue(PostgreSourceViewEditor.PROP_FULL_DDL, PostgreSourceViewEditor.this.showFullDDL.booleanValue());
                    PostgreSourceViewEditor.this.refreshPart((Object)PostgreSourceViewEditor.this, true);
                }
            }, (boolean)true));
        }
        if (sourceObject instanceof PostgreProcedure) {
            contributionManager.add((IContributionItem)new Separator());
            contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action("Show header", 2){
                {
                    this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_PROCEDURE));
                    this.setToolTipText("Shows auto-generated function header");
                    this.setChecked(!PostgreSourceViewEditor.this.isInDebugMode());
                }

                public void run() {
                    PostgreSourceViewEditor.this.getDatabaseEditorInput().setAttribute("debugger.source", (Object)(!this.isChecked() ? 1 : 0));
                    PostgreSourceViewEditor.this.refreshPart((Object)PostgreSourceViewEditor.this, true);
                }
            }, (boolean)true));
        }
        if (sourceObject instanceof PostgrePrivilegeOwner) {
            contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action("Show permissions", 2){
                {
                    this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_PERMISSIONS));
                    this.setToolTipText("Shows object permission grants");
                    this.setChecked(PostgreSourceViewEditor.this.getShowPermissions());
                }

                public void run() {
                    PostgreSourceViewEditor.this.showPermissions = this.isChecked();
                    PostgreSourceViewEditor.this.getPreferenceStore().setValue(PostgreSourceViewEditor.PROP_SHOW_PERMISSIONS, PostgreSourceViewEditor.this.showPermissions.booleanValue());
                    PostgreSourceViewEditor.this.refreshPart((Object)PostgreSourceViewEditor.this, true);
                }
            }, (boolean)true));
        }
        if (sourceObject instanceof PostgreTableBase || sourceObject instanceof PostgreSchema) {
            contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action("Show comments", 2){
                {
                    this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TYPE_TEXT));
                    this.setToolTipText("Show column comments in table definition");
                    this.setChecked(PostgreSourceViewEditor.this.getShowColumnComments());
                }

                public void run() {
                    PostgreSourceViewEditor.this.showColumnComments = this.isChecked();
                    PostgreSourceViewEditor.this.getPreferenceStore().setValue(PostgreSourceViewEditor.PROP_COLUMN_COMMENTS, PostgreSourceViewEditor.this.showPermissions.booleanValue());
                    PostgreSourceViewEditor.this.refreshPart((Object)PostgreSourceViewEditor.this, true);
                }
            }, (boolean)true));
        }
    }

    protected Map<String, Object> getSourceOptions() {
        Map options = super.getSourceOptions();
        boolean inDebug = this.isInDebugMode();
        options.put("debugger.source", inDebug);
        options.put("pg.ddl.show.permissions", this.getShowPermissions());
        options.put("pg.ddl.show.column.comments", this.getShowColumnComments());
        options.put("pg.ddl.show.full", this.getShowFullDDL());
        return options;
    }

    private boolean isInDebugMode() {
        return CommonUtils.getBoolean((Object)this.getDatabaseEditorInput().getAttribute("debugger.source"), (boolean)false);
    }
}

