/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.nativetool;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractNativeToolWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.SmartTextContentAdapter;
import org.jkiss.dbeaver.ui.contentassist.StringContentProposalProvider;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;

public abstract class AbstractNativeToolWizardPage<WIZARD extends AbstractNativeToolWizard>
extends ActiveWizardPage {
    protected final WIZARD wizard;
    protected Text extraCommandArgsText;

    protected AbstractNativeToolWizardPage(WIZARD wizard, String pageName) {
        super(pageName);
        this.wizard = wizard;
    }

    public boolean isPageComplete() {
        return ((AbstractNativeToolWizard)((Object)this.wizard)).getSettings().getClientHome() != null && super.isPageComplete();
    }

    protected void createCheckButtons(Composite buttonsPanel, Table table) {
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)"All", (SelectionListener)new CheckListener(table, true));
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)"None", (SelectionListener)new CheckListener(table, false));
    }

    protected void createExtraArgsInput(Composite outputGroup) {
        this.extraCommandArgsText = UIUtils.createLabelText((Composite)outputGroup, (String)"Extra command args", (String)((AbstractNativeToolWizard)((Object)this.wizard)).getSettings().getExtraCommandArgs());
        this.extraCommandArgsText.setToolTipText("Set extra command args for tool executable.");
        ContentAssistUtils.installContentProposal((Control)this.extraCommandArgsText, (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider(new String[0]));
        this.extraCommandArgsText.addModifyListener(e -> ((AbstractNativeToolWizard)((Object)((Object)this.wizard))).getSettings().setExtraCommandArgs(this.extraCommandArgsText.getText()));
    }

    public void saveState() {
        if (this.extraCommandArgsText != null) {
            ((AbstractNativeToolWizard)((Object)this.wizard)).getSettings().setExtraCommandArgs(this.extraCommandArgsText.getText());
        }
    }

    protected void updateState() {
        this.saveState();
        this.setPageComplete(true);
    }

    private class CheckListener
    extends SelectionAdapter {
        private final Table table;
        private final boolean check;

        public CheckListener(Table table, boolean check) {
            this.table = table;
            this.check = check;
        }

        public void widgetSelected(SelectionEvent e) {
            TableItem[] tableItemArray = this.table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                item.setChecked(this.check);
                ++n2;
            }
            AbstractNativeToolWizardPage.this.updateState();
        }
    }
}

