/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.registry;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizardPage;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.tools.transfer.ui.registry.DataTransferNodeConfiguratorDescriptor;
import org.jkiss.dbeaver.tools.transfer.ui.registry.DataTransferPageDescriptor;

public class DataTransferConfiguratorRegistry {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dataTransferConfigurator";
    private static DataTransferConfiguratorRegistry instance = null;
    private static final Log log = Log.getLog(DataTransferConfiguratorRegistry.class);
    private Map<String, DataTransferNodeConfiguratorDescriptor> nodeConfigurators = new LinkedHashMap<String, DataTransferNodeConfiguratorDescriptor>();

    public static synchronized DataTransferConfiguratorRegistry getInstance() {
        if (instance == null) {
            instance = new DataTransferConfiguratorRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private DataTransferConfiguratorRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("configPages".equals(ext.getName())) {
                String nodeId = ext.getAttribute("node");
                DataTransferNodeConfiguratorDescriptor descriptor = this.nodeConfigurators.get(nodeId);
                if (descriptor == null) {
                    descriptor = new DataTransferNodeConfiguratorDescriptor(ext);
                    this.nodeConfigurators.put(nodeId, descriptor);
                } else {
                    descriptor.loadNodeConfigurations(ext);
                }
            }
            ++n2;
        }
    }

    public DataTransferNodeConfiguratorDescriptor getConfigurator(String nodeId) {
        return this.nodeConfigurators.get(nodeId);
    }

    public DataTransferPageDescriptor getPageDescriptor(IWizardPage page) {
        for (DataTransferNodeConfiguratorDescriptor nd : this.nodeConfigurators.values()) {
            for (DataTransferPageDescriptor pd : nd.patPageDescriptors()) {
                if (!pd.getPageClass().getImplName().equals(page.getClass().getName())) continue;
                return pd;
            }
        }
        return null;
    }
}

