/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.swt.widgets.Display;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;

public class ModelPropertyTester
extends PropertyTester {
    private static final Log log = Log.getLog(ModelPropertyTester.class);
    public static final String NAMESPACE = "org.jkiss.dbeaver.model";
    public static final String PROP_CHILD_OF_TYPE = "childOfType";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!(receiver instanceof DBSObject)) {
            return false;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            return false;
        }
        switch (property) {
            case "childOfType": {
                DBSObject object = (DBSObject)receiver;
                if (object instanceof DBSObjectContainer && expectedValue instanceof String) {
                    try {
                        Class<?> expectedChildClass = Class.forName((String)expectedValue);
                        Class childType = ((DBSObjectContainer)object).getPrimaryChildType((DBRProgressMonitor)new VoidProgressMonitor());
                        return expectedChildClass.isAssignableFrom(childType);
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return false;
            }
        }
        return false;
    }
}

