/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.jkiss.code.NotNull;
import org.jkiss.utils.CommonUtils;

public class SharedFonts {
    private final Map<String, Font> fontMap = new HashMap<String, Font>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Font getFont(Device device, FontData fontData) {
        Map<String, Font> map = this.fontMap;
        synchronized (map) {
            String fontKey = SharedFonts.toString(fontData);
            Font font = this.fontMap.get(fontKey);
            if (font == null) {
                font = new Font(device, fontData);
                this.fontMap.put(fontKey, font);
            }
            return font;
        }
    }

    public Font getFont(Device device, String fontData) {
        String[] fontParts = fontData.split(":");
        FontData data = new FontData(fontParts[0], CommonUtils.toInt((Object)fontParts[1]), CommonUtils.toInt((Object)fontParts[2]));
        return this.getFont(device, data);
    }

    public static String toString(FontData fontData) {
        return String.valueOf(fontData.getName()) + ":" + fontData.getHeight() + ":" + fontData.getStyle();
    }

    public static String toString(Font font) {
        return SharedFonts.toString(font.getFontData()[0]);
    }

    public static boolean equalFonts(Font font1, Font font2) {
        FontData data1 = font1.getFontData()[0];
        FontData data2 = font2.getFontData()[0];
        return CommonUtils.equalObjects((Object)data1.getName(), (Object)data2.getName()) && data1.getHeight() == data2.getHeight() && data1.getStyle() == data2.getStyle();
    }
}

