/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view;

import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardListViewer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardGroupContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewConfiguration;
import org.jkiss.utils.CommonUtils;

public class DashboardView
extends ViewPart
implements IDataSourceContainerProvider,
DBPEventListener {
    public static final String VIEW_ID = "org.jkiss.dbeaver.ui.dashboardView";
    protected static final Log log = Log.getLog(DashboardView.class);
    private DashboardListViewer dashboardListViewer;
    private DashboardViewConfiguration configuration;
    private DBPDataSourceContainer dataSourceContainer;

    public static DashboardView openView(IWorkbenchWindow workbenchWindow, DBPDataSourceContainer dataSourceContainer) {
        try {
            return (DashboardView)workbenchWindow.getActivePage().showView(VIEW_ID, String.valueOf(dataSourceContainer.getProject().getName()) + "/" + dataSourceContainer.getId(), 1);
        }
        catch (PartInitException e) {
            DBWorkbench.getPlatformUI().showError("Dashboard view", "Can't open dashboard view", (Throwable)e);
            return null;
        }
    }

    public DashboardViewConfiguration getConfiguration() {
        return this.configuration;
    }

    public void createPartControl(Composite parent) {
        UIExecutionQueue.queueExec(() -> this.createDashboardControls(parent));
    }

    private void createDashboardControls(Composite parent) {
        try {
            String dsId;
            String projectName;
            String secondaryId = this.getViewSite().getSecondaryId();
            if (CommonUtils.isEmpty((String)secondaryId)) {
                throw new IllegalStateException("Dashboard view requires active database connection");
            }
            int divPos = secondaryId.indexOf("/");
            if (divPos == -1) {
                projectName = null;
                dsId = secondaryId;
            } else {
                projectName = secondaryId.substring(0, divPos);
                dsId = secondaryId.substring(divPos + 1);
            }
            DBPProject project = null;
            if (!CommonUtils.isEmpty((String)projectName)) {
                project = DBWorkbench.getPlatform().getWorkspace().getProject(projectName);
            }
            this.dataSourceContainer = project != null ? project.getDataSourceRegistry().getDataSource(dsId) : DBUtils.findDataSource((String)dsId);
            if (this.dataSourceContainer == null) {
                throw new IllegalStateException("Database connection '" + dsId + "' not found");
            }
            this.dataSourceContainer.getRegistry().addDataSourceListener((DBPEventListener)this);
            this.configuration = new DashboardViewConfiguration(this.dataSourceContainer, secondaryId);
            this.dashboardListViewer = new DashboardListViewer((IWorkbenchSite)this.getSite(), this.dataSourceContainer, this.configuration);
            this.dashboardListViewer.createControl(parent);
            this.dashboardListViewer.createDashboardsFromConfiguration();
            this.getSite().setSelectionProvider((ISelectionProvider)this.dashboardListViewer);
            parent.layout(true, true);
            this.updateStatus();
        }
        catch (Throwable e) {
            log.error((Object)"Error initializing dashboard view", e);
        }
    }

    public void setFocus() {
        DashboardGroupContainer group;
        List<? extends DashboardContainer> items;
        if (this.dashboardListViewer != null && !(items = (group = this.dashboardListViewer.getDefaultGroup()).getItems()).isEmpty()) {
            group.selectItem(items.get(0));
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void dispose() {
        super.dispose();
        if (this.dashboardListViewer != null) {
            this.dataSourceContainer.getRegistry().removeDataSourceListener((DBPEventListener)this);
            this.dashboardListViewer.dispose();
            this.dashboardListViewer = null;
        }
    }

    public void handleDataSourceEvent(DBPEvent event) {
        if (event.getObject() != this.dataSourceContainer) {
            return;
        }
        switch (event.getAction()) {
            case OBJECT_UPDATE: 
            case OBJECT_REMOVE: {
                UIUtils.asyncExec(this::updateStatus);
            }
        }
    }

    private void updateStatus() {
        UIUtils.asyncExec(() -> this.setPartName(String.valueOf(this.dataSourceContainer.getName()) + (this.dataSourceContainer.isConnected() ? "" : " <off>")));
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
    }

    public DashboardListViewer getDashboardListViewer() {
        return this.dashboardListViewer;
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return null;
    }
}

