/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTrigger;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractTriggerColumn;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class OracleTriggerColumn
extends AbstractTriggerColumn {
    private static final Log log = Log.getLog(OracleTriggerColumn.class);
    private OracleTrigger trigger;
    private String name;
    private OracleTableColumn tableColumn;
    private boolean columnList;

    public OracleTriggerColumn(DBRProgressMonitor monitor, OracleTrigger trigger, OracleTableColumn tableColumn, ResultSet dbResult) throws DBException {
        this.trigger = trigger;
        this.tableColumn = tableColumn;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
        this.columnList = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"COLUMN_LIST", (String)"YES");
    }

    OracleTriggerColumn(OracleTrigger trigger, OracleTriggerColumn source) {
        this.trigger = trigger;
        this.tableColumn = source.tableColumn;
        this.columnList = source.columnList;
    }

    public OracleTrigger getTrigger() {
        return this.trigger;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public OracleTableColumn getTableColumn() {
        return this.tableColumn;
    }

    public int getOrdinalPosition() {
        return 0;
    }

    @Nullable
    public String getDescription() {
        return this.tableColumn.getDescription();
    }

    public OracleTrigger getParentObject() {
        return this.trigger;
    }

    @NotNull
    public OracleDataSource getDataSource() {
        return this.trigger.getDataSource();
    }

    public String toString() {
        return this.getName();
    }
}

