/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileLog;
import org.jkiss.dbeaver.model.exec.compile.DBCSourceHost;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.resource.WorkspaceResources;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IActiveWorkbenchPart;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ObjectCompilerLogViewer;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.IDatabasePostSaveProcessor;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.text.BaseTextDocumentProvider;
import org.jkiss.dbeaver.ui.editors.text.DatabaseMarkerAnnotationModel;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public abstract class SQLEditorNested<T extends DBSObject>
extends SQLEditorBase
implements IActiveWorkbenchPart,
IRefreshablePart,
DBCSourceHost,
IDatabasePostSaveProcessor {
    private static final String SAVE_CONTEXT_COMPILE_PARAM = "object.compiled";
    private EditorPageControl pageControl;
    private ObjectCompilerLogViewer compileLog;
    private Control editorControl;
    private SashForm editorSash;
    private boolean activated;

    public SQLEditorNested() {
        this.setDocumentProvider((IDocumentProvider)new ObjectDocumentProvider());
    }

    public IDatabaseEditorInput getDatabaseEditorInput() {
        return (IDatabaseEditorInput)super.getEditorInput();
    }

    public T getSourceObject() {
        IEditorInput editorInput = this.getEditorInput();
        if (!(editorInput instanceof IDatabaseEditorInput)) {
            return null;
        }
        return (T)((IDatabaseEditorInput)editorInput).getDatabaseObject();
    }

    public DBCExecutionContext getExecutionContext() {
        IEditorInput editorInput = this.getEditorInput();
        if (!(editorInput instanceof IDatabaseEditorInput)) {
            return null;
        }
        return ((IDatabaseEditorInput)editorInput).getExecutionContext();
    }

    public DBPPropertySource getInputPropertySource() {
        return this.getDatabaseEditorInput().getPropertySource();
    }

    @Override
    public void createPartControl(Composite parent) {
        boolean hasCompiler;
        this.pageControl = new EditorPageControl(parent, 0x10000000);
        boolean bl = hasCompiler = this.getCompileCommandId() != null;
        if (hasCompiler) {
            this.editorSash = new SashForm(this.pageControl.createContentContainer(), 66048);
            super.createPartControl((Composite)this.editorSash);
            this.editorControl = this.editorSash.getChildren()[0];
            this.compileLog = new ObjectCompilerLogViewer((Composite)this.editorSash, this, false);
        } else {
            super.createPartControl(this.pageControl.createContentContainer());
        }
        this.pageControl.createOrSubstituteProgressPanel(this.getSite());
        this.pageControl.setInfo("Source");
        if (hasCompiler) {
            this.editorSash.setWeights(new int[]{70, 30});
            this.editorSash.setMaximizedControl(this.editorControl);
        }
        StyledText editorControl = this.getEditorControl();
        assert (editorControl != null);
        editorControl.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (SQLEditorNested.this.pageControl != null && !SQLEditorNested.this.pageControl.isDisposed()) {
                    SQLEditorNested.this.pageControl.activate(true);
                }
            }

            public void focusLost(FocusEvent e) {
                if (SQLEditorNested.this.pageControl != null && !SQLEditorNested.this.pageControl.isDisposed()) {
                    SQLEditorNested.this.pageControl.activate(false);
                }
            }
        });
    }

    @Override
    public void doSave(IProgressMonitor progressMonitor) {
        UIUtils.syncExec(() -> SQLEditorNested.super.doSave(progressMonitor));
    }

    public void runPostSaveCommands(Map<String, Object> context) {
        String compileCommandId = this.getCompileCommandId();
        if (compileCommandId != null && context.get(SAVE_CONTEXT_COMPILE_PARAM) == null) {
            try {
                ActionUtils.runCommand((String)compileCommandId, (IServiceLocator)this.getSite().getWorkbenchWindow());
            }
            finally {
                context.put(SAVE_CONTEXT_COMPILE_PARAM, true);
            }
        }
    }

    public void activatePart() {
        if (!this.activated) {
            this.reloadSyntaxRules();
            this.activated = true;
        }
    }

    public void deactivatePart() {
    }

    public void refreshPart(Object source, boolean force) {
        IEditorSite editorSite = this.getEditorSite();
        if (editorSite instanceof MultiPageEditorSite && ((MultiPageEditorSite)editorSite).getMultiPageEditor() instanceof EntityEditor && ((EntityEditor)((MultiPageEditorSite)editorSite).getMultiPageEditor()).isSaveInProgress()) {
            return;
        }
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider instanceof ObjectDocumentProvider) {
            ((ObjectDocumentProvider)documentProvider).sourceText = null;
        }
        if (force) {
            int caretOffset = this.getEditorControl().getCaretOffset();
            super.setInput(this.getEditorInput());
            if (caretOffset < this.getEditorControl().getCharCount()) {
                this.getEditorControl().setCaretOffset(caretOffset);
            }
        }
        this.reloadSyntaxRules();
    }

    protected String getCompileCommandId() {
        return null;
    }

    public boolean isDocumentLoaded() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider instanceof ObjectDocumentProvider) {
            return ((ObjectDocumentProvider)documentProvider).sourceLoaded;
        }
        return true;
    }

    public DBCCompileLog getCompileLog() {
        return this.compileLog;
    }

    public void setCompileInfo(String message, boolean error) {
        this.pageControl.setInfo(message);
    }

    public void positionSource(int line, int position) {
        try {
            IRegion lineInfo = this.getTextViewer().getDocument().getLineInformation(line - 1);
            int offset = lineInfo.getOffset() + position - 1;
            super.selectAndReveal(offset, 1);
        }
        catch (BadLocationException e) {
            log.warn((Object)e);
        }
    }

    public void showCompileLog() {
        this.editorSash.setMaximizedControl(null);
        this.compileLog.layoutLog();
    }

    protected abstract String getSourceText(DBRProgressMonitor var1) throws DBException;

    protected abstract void setSourceText(DBRProgressMonitor var1, String var2);

    protected void contributeEditorCommands(IContributionManager toolBarManager) {
        toolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite().getWorkbenchWindow(), (String)"org.jkiss.dbeaver.ui.editors.sql.open.file"));
        toolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite().getWorkbenchWindow(), (String)"org.jkiss.dbeaver.ui.editors.sql.save.file"));
        String compileCommandId = this.getCompileCommandId();
        if (compileCommandId != null) {
            toolBarManager.add((IContributionItem)new Separator());
            toolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite().getWorkbenchWindow(), (String)compileCommandId));
            toolBarManager.add((IAction)new ViewLogAction());
        }
    }

    @Override
    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.add((IContributionItem)new Separator());
        this.contributeEditorCommands((IContributionManager)menu);
    }

    public void doSaveAs() {
        this.saveToExternalFile();
    }

    private class EditorPageControl
    extends ProgressPageControl {
        EditorPageControl(Composite parent, int style) {
            super(parent, style);
        }

        public void fillCustomActions(IContributionManager contributionManager) {
            SQLEditorNested.this.contributeEditorCommands(contributionManager);
            IWorkbenchPartSite site = SQLEditorNested.this.getSite();
            if (site != null) {
                DatabaseEditorUtils.contributeStandardEditorActions((IWorkbenchSite)site, (IContributionManager)contributionManager);
            }
        }
    }

    private class ObjectDocumentProvider
    extends BaseTextDocumentProvider {
        private String sourceText;
        private boolean sourceLoaded;

        private ObjectDocumentProvider() {
        }

        public boolean isReadOnly(Object element) {
            return SQLEditorNested.this.isReadOnly();
        }

        public boolean isModifiable(Object element) {
            return !SQLEditorNested.this.isReadOnly();
        }

        protected IDocument createDocument(Object element) throws CoreException {
            Document document = new Document();
            if (this.sourceText == null) {
                this.sourceText = SQLUtils.generateCommentLine((DBPDataSource)SQLEditorNested.this.getDataSource(), (String)("Loading '" + SQLEditorNested.this.getEditorInput().getName() + "' source..."));
                document.set(this.sourceText);
                AbstractJob job = new AbstractJob("Load SQL source"){
                    {
                        this.setUser(true);
                    }

                    protected IStatus run(DBRProgressMonitor monitor) {
                        monitor.beginTask(this.getName(), 1);
                        try {
                            DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)SQLEditorNested.this.getDataSource(), param -> {
                                try {
                                    ObjectDocumentProvider.this.sourceText = SQLEditorNested.this.getSourceText(monitor);
                                    if (ObjectDocumentProvider.this.sourceText == null) {
                                        ObjectDocumentProvider.this.sourceText = SQLUtils.generateCommentLine((DBPDataSource)SQLEditorNested.this.getDataSource(), (String)"Empty source");
                                    }
                                }
                                catch (DBException e) {
                                    throw new InvocationTargetException(e);
                                }
                            });
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        catch (Exception e) {
                            ObjectDocumentProvider.this.sourceText = "/* ERROR WHILE READING SOURCE:\n\n" + e.getMessage() + "\n*/";
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        UIUtils.asyncExec(() -> {
                            SQLEditorNested.this.setInput(SQLEditorNested.this.getEditorInput());
                            SQLEditorNested.this.reloadSyntaxRules();
                        });
                        super.done(event);
                    }
                });
                job.schedule();
            }
            document.set(this.sourceText);
            this.sourceLoaded = true;
            return document;
        }

        protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
            Object databaseObject = SQLEditorNested.this.getSourceObject();
            DBNDatabaseNode node = DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject(databaseObject);
            IResource resource = WorkspaceResources.resolveWorkspaceResource(databaseObject);
            if (resource != null) {
                return new DatabaseMarkerAnnotationModel(databaseObject, node, resource);
            }
            return super.createAnnotationModel(element);
        }

        protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
            SQLEditorNested.this.setSourceText(RuntimeUtils.makeMonitor((IProgressMonitor)monitor), document.get());
        }
    }

    public class ViewLogAction
    extends Action {
        ViewLogAction() {
            super("View compile log", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.COMPILE_LOG));
        }

        public void run() {
            if (SQLEditorNested.this.getTextViewer().getControl().isDisposed()) {
                return;
            }
            if (SQLEditorNested.this.editorSash.getMaximizedControl() == null) {
                SQLEditorNested.this.editorSash.setMaximizedControl(SQLEditorNested.this.editorControl);
            } else {
                SQLEditorNested.this.showCompileLog();
            }
        }
    }
}

