/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.transformers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingType;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class MapAttributeTransformer
implements DBDAttributeTransformer {
    @Override
    public void transformAttribute(@NotNull DBCSession session, @NotNull DBDAttributeBinding attribute, @NotNull List<Object[]> rows, @NotNull Map<String, Object> options) throws DBException {
        if (!CommonUtils.isEmpty(attribute.getNestedBindings()) || !session.getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.transform.complex.type")) {
            return;
        }
        MapAttributeTransformer.resolveMapsFromData(session, attribute, rows);
    }

    static void resolveMapsFromData(DBCSession session, DBDAttributeBinding attribute, List<Object[]> rows) throws DBException {
        ArrayList<Pair> valueAttributes = null;
        int i = 0;
        while (i < rows.size()) {
            DBDCollection collection;
            Object value = rows.get(i)[attribute.getOrdinalPosition()];
            if (value instanceof DBDCollection && (collection = (DBDCollection)value).getItemCount() > 0) {
                value = collection.getItem(0);
            }
            if (value instanceof DBDComposite) {
                DBSAttributeBase[] attributes;
                DBSAttributeBase[] dBSAttributeBaseArray = attributes = ((DBDComposite)value).getAttributes();
                int n = attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    DBSAttributeBase attr = dBSAttributeBaseArray[n2];
                    Pair attrValue = null;
                    if (valueAttributes != null) {
                        for (Pair pair : valueAttributes) {
                            if (!((DBSAttributeBase)pair.getFirst()).getName().equals(attr.getName())) continue;
                            attrValue = pair;
                            break;
                        }
                    }
                    if (attrValue != null) {
                        ((Object[])attrValue.getSecond())[i] = ((DBDComposite)value).getAttributeValue(attr);
                    } else {
                        Object[] valueList = new Object[rows.size()];
                        valueList[i] = ((DBDComposite)value).getAttributeValue(attr);
                        if (valueAttributes == null) {
                            valueAttributes = new ArrayList<Pair>();
                        }
                        valueAttributes.add(new Pair((Object)attr, (Object)valueList));
                    }
                    ++n2;
                }
            }
            ++i;
        }
        if (valueAttributes != null && !valueAttributes.isEmpty()) {
            MapAttributeTransformer.createNestedMapBindings(session, attribute, (List<Pair<DBSAttributeBase, Object[]>>)valueAttributes, rows);
        }
    }

    private static void createNestedMapBindings(DBCSession session, DBDAttributeBinding topAttribute, List<Pair<DBSAttributeBase, Object[]>> nestedAttributes, List<Object[]> rows) throws DBException {
        int maxPosition = 0;
        for (Pair<DBSAttributeBase, Object[]> attr : nestedAttributes) {
            maxPosition = Math.max(maxPosition, ((DBSAttributeBase)attr.getFirst()).getOrdinalPosition());
        }
        List<DBDAttributeBinding> nestedBindings = topAttribute.getNestedBindings();
        if (nestedBindings == null) {
            nestedBindings = new ArrayList<DBDAttributeBinding>();
        } else {
            for (DBDAttributeBinding binding : nestedBindings) {
                maxPosition = Math.max(maxPosition, binding.getOrdinalPosition());
            }
        }
        Object[] fakeRow = new Object[maxPosition + 1];
        List<Object[]> fakeRows = Collections.singletonList(fakeRow);
        for (Pair<DBSAttributeBase, Object[]> nestedAttr : nestedAttributes) {
            DBSAttributeBase attribute = (DBSAttributeBase)nestedAttr.getFirst();
            Object[] values = (Object[])nestedAttr.getSecond();
            DBDAttributeBinding nestedBinding = null;
            for (DBDAttributeBinding binding : nestedBindings) {
                if (!binding.getName().equals(attribute.getName())) continue;
                nestedBinding = binding;
                break;
            }
            if (nestedBinding == null) {
                nestedBinding = new DBDAttributeBindingType(topAttribute, attribute);
                nestedBindings.add(nestedBinding);
            }
            if (attribute.getDataKind().isComplex()) {
                int i = 0;
                while (i < values.length) {
                    if (!DBUtils.isNullValue(values[i])) {
                        fakeRow[nestedBinding.getOrdinalPosition()] = values[i];
                        nestedBinding.lateBinding(session, fakeRows);
                    }
                    ++i;
                }
                continue;
            }
            nestedBinding.lateBinding(session, fakeRows);
        }
        if (!nestedBindings.isEmpty()) {
            topAttribute.setNestedBindings(nestedBindings);
        }
    }
}

