/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.security;

import java.sql.ResultSet;
import java.util.Iterator;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolTableObjectType;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.access.DBAPrivilege;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class ExasolBaseObjectGrant
implements DBAPrivilege {
    private ExasolDataSource dataSource;
    private Boolean alterAuth = false;
    private Boolean deleteAuth = false;
    private Boolean insertAuth = false;
    private Boolean referencesAuth = false;
    private Boolean selectAuth = false;
    private Boolean updateAuth = false;
    private Boolean executeAuth = false;
    private Boolean isPersted;
    private ExasolSchema schema;
    private String name;
    private String exasolGrantee;
    private ExasolTableObjectType type;

    public ExasolBaseObjectGrant(ExasolDataSource dataSource, ResultSet resultSet) throws DBException {
        this.type = ExasolUtils.getTableObjectType(JDBCUtils.safeGetString((ResultSet)resultSet, (String)"OBJECT_TYPE"));
        this.dataSource = dataSource;
        this.exasolGrantee = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"GRANTEE");
        String grants = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PRIVS");
        this.schema = this.type == ExasolTableObjectType.SCHEMA ? dataSource.getChild((DBRProgressMonitor)new VoidProgressMonitor(), JDBCUtils.safeGetString((ResultSet)resultSet, (String)"OBJECT_NAME")) : dataSource.getChild((DBRProgressMonitor)new VoidProgressMonitor(), JDBCUtils.safeGetString((ResultSet)resultSet, (String)"OBJECT_SCHEMA"));
        this.name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"OBJECT_NAME");
        Iterator iterator = CommonUtils.splitString((String)grants, (char)'|').iterator();
        while (iterator.hasNext()) {
            String grant;
            switch (grant = (String)iterator.next()) {
                case "ALTER": {
                    this.alterAuth = true;
                    break;
                }
                case "DELETE": {
                    this.deleteAuth = true;
                    break;
                }
                case "INSERT": {
                    this.insertAuth = true;
                    break;
                }
                case "UPDATE": {
                    this.updateAuth = true;
                    break;
                }
                case "SELECT": {
                    this.selectAuth = true;
                    break;
                }
                case "REFERENCES": {
                    this.referencesAuth = true;
                    break;
                }
                case "EXECUTE": {
                    this.executeAuth = true;
                }
            }
        }
        this.isPersted = true;
    }

    public ExasolBaseObjectGrant(ExasolBaseObjectGrant grant) {
        this.dataSource = grant.getDataSource();
        this.exasolGrantee = grant.getGrantee();
        this.alterAuth = grant.getAlterAuth();
        this.deleteAuth = grant.getDeleteAuth();
        this.insertAuth = grant.getInsertAuth();
        this.updateAuth = grant.getUpdateAuth();
        this.executeAuth = grant.getExecuteAuth();
        this.referencesAuth = grant.getReferencesAuth();
        this.selectAuth = grant.getSelectAuth();
        this.type = grant.getType();
        this.name = grant.getObjectName();
        this.schema = grant.getSchema();
        this.isPersted = true;
    }

    public ExasolTableObjectType getType() {
        return this.type;
    }

    @Property(viewable=true, order=10)
    public ExasolSchema getSchema() {
        return this.schema;
    }

    @Property(viewable=true, order=40)
    public Boolean getAlterAuth() {
        return this.alterAuth;
    }

    @Property(viewable=true, order=50)
    public Boolean getDeleteAuth() {
        return this.deleteAuth;
    }

    @Property(viewable=true, order=60)
    public Boolean getInsertAuth() {
        return this.insertAuth;
    }

    @Property(viewable=true, order=70)
    public Boolean getReferencesAuth() {
        return this.referencesAuth;
    }

    @Property(viewable=true, order=80)
    public Boolean getSelectAuth() {
        return this.selectAuth;
    }

    @Property(viewable=true, order=90)
    public Boolean getUpdateAuth() {
        return this.updateAuth;
    }

    public Boolean getExecuteAuth() {
        return this.executeAuth;
    }

    public ExasolDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(hidden=true)
    public String getName() {
        return this.exasolGrantee;
    }

    public boolean isPersisted() {
        return this.isPersted;
    }

    public String getObjectName() {
        return this.name;
    }

    @Property(hidden=true, multiline=true)
    public String getDescription() {
        return "";
    }

    public ExasolDataSource getParentObject() {
        return this.dataSource;
    }

    public String getGrantee() {
        return this.exasolGrantee;
    }
}

