/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.views;

import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.oracle.model.dict.OracleLanguage;
import org.jkiss.dbeaver.ext.oracle.model.dict.OracleTerritory;
import org.jkiss.dbeaver.ext.oracle.ui.internal.OracleUIMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class OracleConnectionExtraPage
extends ConnectionPageAbstract {
    private Combo languageCombo;
    private Combo territoryCombo;
    private Text nlsDateFormat;
    private Button hideEmptySchemasCheckbox;
    private Button showDBAAlwaysCheckbox;
    private Button useDBAViewsCheckbox;
    private Button useSysSchemaCheckbox;
    private Button useRuleHint;
    private Button useOptimizerHint;
    private Button useSimpleConstraints;

    public OracleConnectionExtraPage() {
        this.setTitle(OracleUIMessages.dialog_connection_oracle_properties);
        this.setDescription(OracleUIMessages.dialog_connection_oracle_properties_discription);
    }

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite cfgGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        cfgGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        cfgGroup.setLayoutData((Object)gd);
        Group sessionGroup = UIUtils.createControlGroup((Composite)cfgGroup, (String)OracleUIMessages.dialog_controlgroup_session_settings, (int)2, (int)32, (int)0);
        this.languageCombo = UIUtils.createLabelCombo((Composite)sessionGroup, (String)OracleUIMessages.edit_label_combo_language, (int)4);
        this.languageCombo.setToolTipText(OracleUIMessages.edit_label_combo_language_tool_tip_text);
        this.languageCombo.add("Default");
        OracleLanguage[] oracleLanguageArray = OracleLanguage.values();
        int n = oracleLanguageArray.length;
        int n2 = 0;
        while (n2 < n) {
            OracleLanguage language = oracleLanguageArray[n2];
            this.languageCombo.add(language.getLanguage());
            ++n2;
        }
        this.languageCombo.setText("Default");
        this.territoryCombo = UIUtils.createLabelCombo((Composite)sessionGroup, (String)OracleUIMessages.edit_label_combo_territory, (int)4);
        this.territoryCombo.setToolTipText(OracleUIMessages.edit_label_combo_territory_tool_tip_text);
        this.territoryCombo.add("Default");
        oracleLanguageArray = OracleTerritory.values();
        n = oracleLanguageArray.length;
        n2 = 0;
        while (n2 < n) {
            OracleLanguage territory = oracleLanguageArray[n2];
            this.territoryCombo.add(territory.getTerritory());
            ++n2;
        }
        this.territoryCombo.setText("Default");
        this.nlsDateFormat = UIUtils.createLabelText((Composite)sessionGroup, (String)OracleUIMessages.edit_label_text_date_format, (String)"");
        Group contentGroup = UIUtils.createControlGroup((Composite)cfgGroup, (String)OracleUIMessages.dialog_controlgroup_content, (int)1, (int)32, (int)0);
        this.hideEmptySchemasCheckbox = UIUtils.createCheckbox((Composite)contentGroup, (String)OracleUIMessages.edit_create_checkbox_hide_empty_schemas, (boolean)false);
        this.hideEmptySchemasCheckbox.setToolTipText(OracleUIMessages.edit_create_checkbox_hide_empty_schemas_tool_tip_text);
        this.showDBAAlwaysCheckbox = UIUtils.createCheckbox((Composite)contentGroup, (String)OracleUIMessages.edit_create_checkbox_content_group_show, (String)OracleUIMessages.edit_create_checkbox_content_group_show_discription, (boolean)false, (int)1);
        this.useDBAViewsCheckbox = UIUtils.createCheckbox((Composite)contentGroup, (String)OracleUIMessages.edit_create_checkbox_content_group_use, (String)OracleUIMessages.edit_create_checkbox_content_group_use_discription, (boolean)false, (int)1);
        this.useSysSchemaCheckbox = UIUtils.createCheckbox((Composite)contentGroup, (String)OracleUIMessages.edit_create_checkbox_content_group_use_sys_schema, (String)OracleUIMessages.edit_create_checkbox_content_group_use_sys_schema_description, (boolean)false, (int)1);
        contentGroup = UIUtils.createControlGroup((Composite)cfgGroup, (String)OracleUIMessages.dialog_controlgroup_performance, (int)1, (int)32, (int)0);
        this.useRuleHint = UIUtils.createCheckbox((Composite)contentGroup, (String)OracleUIMessages.edit_create_checkbox_group_use_rule, (boolean)true);
        this.useRuleHint.setToolTipText(OracleUIMessages.edit_create_checkbox_adds_rule_tool_tip_text);
        this.useOptimizerHint = UIUtils.createCheckbox((Composite)contentGroup, (String)OracleUIMessages.edit_create_checkbox_group_use_metadata_optimizer, (boolean)true);
        this.useOptimizerHint.setToolTipText(OracleUIMessages.edit_create_checkbox_group_use_metadata_optimizer_tip);
        this.useSimpleConstraints = UIUtils.createCheckbox((Composite)contentGroup, (String)OracleUIMessages.edit_create_checkbox_content_group_use_simple_constraints, (String)OracleUIMessages.edit_create_checkbox_content_group_use_simple_constraints_description, (boolean)false, (int)1);
        this.setControl((Control)cfgGroup);
        this.loadSettings();
    }

    public boolean isComplete() {
        return true;
    }

    public void loadSettings() {
        Object checkSchemaContent;
        Object dateFormat;
        Object nlsTerritory;
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        Map providerProperties = connectionInfo.getProviderProperties();
        Object nlsLanguage = providerProperties.get("@dbeaver-session-language@");
        if (nlsLanguage != null) {
            this.languageCombo.setText(nlsLanguage.toString());
        }
        if ((nlsTerritory = providerProperties.get("@dbeaver-session-territory@")) != null) {
            this.territoryCombo.setText(nlsTerritory.toString());
        }
        if ((dateFormat = providerProperties.get("@dbeaver-session-nls-date-format@")) != null) {
            this.nlsDateFormat.setText(dateFormat.toString());
        }
        if ((checkSchemaContent = providerProperties.get("@dbeaver-check-schema-content@")) != null) {
            this.hideEmptySchemasCheckbox.setSelection(CommonUtils.getBoolean(checkSchemaContent, (boolean)false));
        }
        this.showDBAAlwaysCheckbox.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-always-show-dba@")), (boolean)false));
        this.useDBAViewsCheckbox.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-always-use-dba-views@")), (boolean)false));
        this.useSysSchemaCheckbox.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-meta-use-sys-schema@")), (boolean)false));
        this.useSimpleConstraints.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-meta-use-simple-constraints@")), (boolean)false));
        this.useRuleHint.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-use-rule-hint@")), (boolean)false));
        this.useOptimizerHint.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-use-meta-optimizer@")), (boolean)false));
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        Map providerProperties = dataSource.getConnectionConfiguration().getProviderProperties();
        if (!"Default".equals(this.languageCombo.getText())) {
            providerProperties.put("@dbeaver-session-language@", this.languageCombo.getText());
        } else {
            providerProperties.remove("@dbeaver-session-language@");
        }
        if (!"Default".equals(this.territoryCombo.getText())) {
            providerProperties.put("@dbeaver-session-territory@", this.territoryCombo.getText());
        } else {
            providerProperties.remove("@dbeaver-session-territory@");
        }
        String dateFormat = this.nlsDateFormat.getText().trim();
        if (!dateFormat.isEmpty()) {
            providerProperties.put("@dbeaver-session-nls-date-format@", dateFormat);
        } else {
            providerProperties.remove("@dbeaver-session-nls-date-format@");
        }
        providerProperties.put("@dbeaver-check-schema-content@", String.valueOf(this.hideEmptySchemasCheckbox.getSelection()));
        providerProperties.put("@dbeaver-always-show-dba@", String.valueOf(this.showDBAAlwaysCheckbox.getSelection()));
        providerProperties.put("@dbeaver-always-use-dba-views@", String.valueOf(this.useDBAViewsCheckbox.getSelection()));
        providerProperties.put("@dbeaver-meta-use-sys-schema@", String.valueOf(this.useSysSchemaCheckbox.getSelection()));
        providerProperties.put("@dbeaver-meta-use-sys-schema@", String.valueOf(this.useSysSchemaCheckbox.getSelection()));
        providerProperties.put("@dbeaver-meta-use-simple-constraints@", String.valueOf(this.useSimpleConstraints.getSelection()));
        providerProperties.put("@dbeaver-use-rule-hint@", String.valueOf(this.useRuleHint.getSelection()));
        providerProperties.put("@dbeaver-use-meta-optimizer@", String.valueOf(this.useOptimizerHint.getSelection()));
        this.saveConnectionURL(dataSource.getConnectionConfiguration());
    }
}

