/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2Alias;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2DataType;
import org.jkiss.dbeaver.ext.db2.model.DB2GlobalObject;
import org.jkiss.dbeaver.ext.db2.model.DB2Index;
import org.jkiss.dbeaver.ext.db2.model.DB2MaterializedQueryTable;
import org.jkiss.dbeaver.ext.db2.model.DB2Package;
import org.jkiss.dbeaver.ext.db2.model.DB2Routine;
import org.jkiss.dbeaver.ext.db2.model.DB2Sequence;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2Trigger;
import org.jkiss.dbeaver.ext.db2.model.DB2View;
import org.jkiss.dbeaver.ext.db2.model.DB2XMLSchema;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2AliasCache;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2IndexCache;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2MaterializedQueryTableCache;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2NicknameCache;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2RoutineCache;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2TableCache;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2TableCheckConstraintCache;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2TableForeignKeyCache;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2TableReferenceCache;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2TableUniqueKeyCache;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2TriggerCache;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2ViewCache;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2OwnerType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2RoutineType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2YesNo;
import org.jkiss.dbeaver.ext.db2.model.fed.DB2Nickname;
import org.jkiss.dbeaver.ext.db2.model.module.DB2Module;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectSimpleCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.utils.CommonUtils;

public class DB2Schema
extends DB2GlobalObject
implements DBSSchema,
DBPRefreshableObject,
DBPSystemObject,
DBSProcedureContainer,
DBPObjectStatisticsCollector,
DBPObjectStatistics {
    private static final List<String> SYSTEM_SCHEMA = Arrays.asList("SYS", "SYSCAT", "SYSFUN", "SYSIBM", "SYSIBMADM", "SYSIBMINTERNAL", "SYSIBMTS", "SYSPROC", "SYSPUBLIC", "SYSSTAT", "SYSTOOLS", "DB2QP", "SQLJ", "NULLID");
    private static final String C_SEQ = "SELECT * FROM SYSCAT.SEQUENCES WHERE SEQSCHEMA = ? AND SEQTYPE <> 'A' ORDER BY SEQNAME WITH UR";
    private static final String C_PKG = "SELECT * FROM SYSCAT.PACKAGES WHERE PKGSCHEMA = ? ORDER BY PKGNAME WITH UR";
    private static final String C_XSR = "SELECT * FROM SYSCAT.XSROBJECTS WHERE OBJECTSCHEMA = ? ORDER BY OBJECTNAME WITH UR";
    private static final String C_MOD = "SELECT * FROM SYSCAT.MODULES WHERE MODULESCHEMA = ? AND MODULETYPE <> 'A'  ORDER BY MODULENAME WITH UR";
    private static final String C_DTT = "SELECT * FROM SYSCAT.DATATYPES WHERE TYPESCHEMA = ? AND METATYPE <> 'S' ORDER BY TYPENAME WITH UR";
    private static final String C_DTT_97 = "SELECT * FROM SYSCAT.DATATYPES WHERE TYPESCHEMA = ? AND METATYPE <> 'S' AND TYPEMODULENAME IS NULL ORDER BY TYPENAME WITH UR";
    private final DB2TableCache tableCache = new DB2TableCache();
    private final DB2ViewCache viewCache = new DB2ViewCache();
    private final DB2MaterializedQueryTableCache mqtCache = new DB2MaterializedQueryTableCache();
    private final DB2NicknameCache nicknameCache = new DB2NicknameCache();
    private final DBSObjectCache<DB2Schema, DB2Sequence> sequenceCache;
    private final DB2IndexCache indexCache = new DB2IndexCache();
    private final DB2TriggerCache triggerCache = new DB2TriggerCache();
    private final DB2AliasCache aliasCache = new DB2AliasCache();
    private final DBSObjectCache<DB2Schema, DB2Package> packageCache;
    private DBSObjectCache<DB2Schema, DB2XMLSchema> xmlSchemaCache;
    private final DB2RoutineCache udfCache = new DB2RoutineCache(DB2RoutineType.F);
    private final DB2RoutineCache methodCache = new DB2RoutineCache(DB2RoutineType.M);
    private final DB2RoutineCache procedureCache = new DB2RoutineCache(DB2RoutineType.P);
    private final DBSObjectCache<DB2Schema, DB2DataType> udtCache;
    private DBSObjectCache<DB2Schema, DB2Module> moduleCache;
    private final DB2TableUniqueKeyCache constraintCache = new DB2TableUniqueKeyCache(this.tableCache);
    private final DB2TableForeignKeyCache associationCache = new DB2TableForeignKeyCache(this.tableCache);
    private final DB2TableReferenceCache referenceCache = new DB2TableReferenceCache(this.tableCache);
    private final DB2TableCheckConstraintCache checkCache = new DB2TableCheckConstraintCache(this.tableCache);
    private String name;
    private String owner;
    private DB2OwnerType ownerType;
    private Timestamp createTime;
    private Integer auditPolicyID;
    private String auditPolicyName;
    private Boolean dataCapture;
    private String remarks;
    private volatile Long schemaTotalSize;
    private volatile boolean hasTableStatistics;

    public DB2Schema(DB2DataSource db2DataSource, ResultSet dbResult) throws DBException {
        this(db2DataSource, JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"SCHEMANAME"));
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        if (db2DataSource.isAtLeastV9_5()) {
            this.ownerType = (DB2OwnerType)CommonUtils.valueOf(DB2OwnerType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNERTYPE"));
        }
        if (db2DataSource.isAtLeastV10_1()) {
            this.auditPolicyID = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"AUDITPOLICYID");
            this.auditPolicyName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"AUDITPOLICYNAME");
            this.dataCapture = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"DATACAPTURE", (String)DB2YesNo.Y.name());
        }
    }

    public DB2Schema(DB2DataSource db2DataSource, String name) {
        super(db2DataSource, true);
        this.name = name;
        this.sequenceCache = new JDBCObjectSimpleCache(DB2Sequence.class, C_SEQ, new Object[]{name});
        this.packageCache = new JDBCObjectSimpleCache(DB2Package.class, C_PKG, new Object[]{name});
        this.xmlSchemaCache = new JDBCObjectSimpleCache(DB2XMLSchema.class, C_XSR, new Object[]{name});
        if (db2DataSource.isAtLeastV9_7()) {
            this.moduleCache = new JDBCObjectSimpleCache(DB2Module.class, C_MOD, new Object[]{name});
        }
        String datatypeSQL = db2DataSource.isAtLeastV9_7() ? C_DTT_97 : C_DTT;
        this.udtCache = new JDBCObjectSimpleCache(DB2DataType.class, datatypeSQL, new Object[]{name});
    }

    public boolean isSystem() {
        return SYSTEM_SCHEMA.contains(this.name);
    }

    public String toString() {
        return "Schema " + this.name;
    }

    public synchronized void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        if ((scope & 1) != 0) {
            monitor.subTask("Cache tables");
            this.tableCache.getAllObjects(monitor, this);
            monitor.subTask("Cache Views");
            this.viewCache.getAllObjects(monitor, this);
            monitor.subTask("Cache MQTs");
            this.mqtCache.getAllObjects(monitor, this);
            monitor.subTask("Cache Nicknames");
            this.nicknameCache.getAllObjects(monitor, this);
            monitor.subTask("Cache Check Constraints");
            this.checkCache.getAllObjects(monitor, this);
            monitor.subTask("Cache Sequences");
            this.sequenceCache.getAllObjects(monitor, (DBSObject)this);
            if (this.xmlSchemaCache != null) {
                monitor.subTask("Cache XML Schemas");
                this.xmlSchemaCache.getAllObjects(monitor, (DBSObject)this);
            }
            if (this.moduleCache != null) {
                monitor.subTask("Cache Modules");
                this.moduleCache.getAllObjects(monitor, (DBSObject)this);
            }
        }
        if ((scope & 2) != 0) {
            monitor.subTask("Cache table columns");
            this.tableCache.loadChildren(monitor, this, null);
        }
        if ((scope & 4) != 0) {
            monitor.subTask("Cache table unique keys");
            this.constraintCache.getObjects(monitor, this, null);
            monitor.subTask("Cache table foreign keys");
            this.associationCache.getObjects(monitor, this, null);
            monitor.subTask("Cache table references");
            this.referenceCache.getObjects(monitor, this, null);
            monitor.subTask("Cache indexes");
            this.indexCache.getAllObjects(monitor, this);
        }
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.tableCache.clearCache();
        this.viewCache.clearCache();
        this.mqtCache.clearCache();
        this.nicknameCache.clearCache();
        this.packageCache.clearCache();
        this.procedureCache.clearCache();
        this.udfCache.clearCache();
        this.udtCache.clearCache();
        this.sequenceCache.clearCache();
        this.aliasCache.clearCache();
        if (this.xmlSchemaCache != null) {
            this.xmlSchemaCache.clearCache();
        }
        if (this.moduleCache != null) {
            this.moduleCache.clearCache();
        }
        this.indexCache.clearCache();
        this.triggerCache.clearCache();
        this.constraintCache.clearCache();
        this.associationCache.clearCache();
        this.referenceCache.clearCache();
        this.checkCache.clearCache();
        this.schemaTotalSize = null;
        this.hasTableStatistics = false;
        return this;
    }

    @NotNull
    public Class<DB2Table> getPrimaryChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return DB2Table.class;
    }

    public Collection<DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<DBSObject> allChildren = new ArrayList<DBSObject>();
        allChildren.addAll(this.aliasCache.getAllObjects(monitor, this));
        allChildren.addAll(this.tableCache.getAllObjects(monitor, this));
        allChildren.addAll(this.viewCache.getAllObjects(monitor, this));
        allChildren.addAll(this.mqtCache.getAllObjects(monitor, this));
        allChildren.addAll(this.nicknameCache.getAllObjects(monitor, this));
        return allChildren;
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        DBSObject child = this.tableCache.getObject(monitor, this, childName);
        if (child == null) {
            child = this.aliasCache.getObject(monitor, this, childName);
        }
        if (child == null) {
            child = this.viewCache.getObject(monitor, this, childName);
        }
        if (child == null) {
            child = this.mqtCache.getObject(monitor, this, childName);
        }
        if (child == null) {
            child = this.nicknameCache.getObject(monitor, this, childName);
        }
        return child;
    }

    @Association
    public List<DB2Table> getTables(DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getTypedObjects(monitor, this, DB2Table.class);
    }

    public DB2Table getTable(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Table)this.tableCache.getObject(monitor, this, name, DB2Table.class);
    }

    @Association
    public Collection<DB2View> getViews(DBRProgressMonitor monitor) throws DBException {
        return this.viewCache.getTypedObjects(monitor, this, DB2View.class);
    }

    public DB2View getView(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2View)this.viewCache.getObject(monitor, this, name, DB2View.class);
    }

    @Association
    public Collection<DB2Nickname> getNicknames(DBRProgressMonitor monitor) throws DBException {
        return this.nicknameCache.getTypedObjects(monitor, this, DB2Nickname.class);
    }

    public DB2Nickname getNickname(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Nickname)this.nicknameCache.getObject(monitor, this, name, DB2Nickname.class);
    }

    @Association
    public Collection<DB2MaterializedQueryTable> getMaterializedQueryTables(DBRProgressMonitor monitor) throws DBException {
        return this.mqtCache.getTypedObjects(monitor, this, DB2MaterializedQueryTable.class);
    }

    public DB2MaterializedQueryTable getMaterializedQueryTable(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2MaterializedQueryTable)this.mqtCache.getObject(monitor, this, name, DB2MaterializedQueryTable.class);
    }

    @Association
    public Collection<DB2Index> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return this.indexCache.getAllObjects(monitor, this);
    }

    public DB2Index getIndex(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Index)((Object)this.indexCache.getObject(monitor, this, name, DB2Index.class));
    }

    @Association
    public Collection<DB2Trigger> getTriggers(DBRProgressMonitor monitor) throws DBException {
        return this.triggerCache.getAllObjects(monitor, this);
    }

    public DB2Trigger getTrigger(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Trigger)this.triggerCache.getObject(monitor, this, name, DB2Trigger.class);
    }

    @Association
    public Collection<DB2DataType> getUDTs(DBRProgressMonitor monitor) throws DBException {
        return this.udtCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2DataType getUDT(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2DataType)this.udtCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2Sequence> getSequences(DBRProgressMonitor monitor) throws DBException {
        return this.sequenceCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2Sequence getSequence(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Sequence)this.sequenceCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2XMLSchema> getXMLSchemas(DBRProgressMonitor monitor) throws DBException {
        return this.xmlSchemaCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2XMLSchema getXMLSchema(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2XMLSchema)this.xmlSchemaCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2Alias> getAliases(DBRProgressMonitor monitor) throws DBException {
        return this.aliasCache.getAllObjects(monitor, this);
    }

    public DB2Alias getAlias(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Alias)this.aliasCache.getObject(monitor, this, name, DB2Alias.class);
    }

    @Association
    public Collection<DB2Package> getPackages(DBRProgressMonitor monitor) throws DBException {
        return this.packageCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2Package getPackage(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Package)this.packageCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2Routine> getProcedures(DBRProgressMonitor monitor) throws DBException {
        return this.procedureCache.getAllObjects(monitor, this);
    }

    public DB2Routine getProcedure(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Routine)this.procedureCache.getObject(monitor, this, name);
    }

    @Association
    public Collection<DB2Routine> getMethods(DBRProgressMonitor monitor) throws DBException {
        return this.methodCache.getAllObjects(monitor, this);
    }

    public DB2Routine getMethod(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Routine)this.methodCache.getObject(monitor, this, name);
    }

    @Association
    public Collection<DB2Routine> getUDFs(DBRProgressMonitor monitor) throws DBException {
        return this.udfCache.getAllObjects(monitor, this);
    }

    public DB2Routine getUDF(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Routine)this.udfCache.getObject(monitor, this, name);
    }

    @Association
    public Collection<DB2Module> getModules(DBRProgressMonitor monitor) throws DBException {
        return this.moduleCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2Module getModule(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Module)this.moduleCache.getObject(monitor, (DBSObject)this, name);
    }

    @Property(viewable=true, editable=false, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Property(viewable=false, editable=false, category="Owner")
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=false, editable=false, category="Owner")
    public DB2OwnerType getOwnerType() {
        return this.ownerType;
    }

    @Property(viewable=true, editable=false, category="Date & Time")
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=false, editable=false, order=7, category="Audit")
    public Integer getAuditPolicyID() {
        return this.auditPolicyID;
    }

    @Property(viewable=false, editable=false, order=8, category="Audit")
    public String getAuditPolicyName() {
        return this.auditPolicyName;
    }

    @Property(viewable=false, editable=false)
    public Boolean getDataCapture() {
        return this.dataCapture;
    }

    @Override
    @Property(viewable=false, editable=false, multiline=true)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    public DB2TableCache getTableCache() {
        return this.tableCache;
    }

    public DB2ViewCache getViewCache() {
        return this.viewCache;
    }

    public DB2NicknameCache getNicknameCache() {
        return this.nicknameCache;
    }

    public DB2MaterializedQueryTableCache getMaterializedQueryTableCache() {
        return this.mqtCache;
    }

    public DBSObjectCache<DB2Schema, DB2DataType> getUdtCache() {
        return this.udtCache;
    }

    public DB2RoutineCache getUdfCache() {
        return this.udfCache;
    }

    public DBSObjectCache<DB2Schema, DB2Sequence> getSequenceCache() {
        return this.sequenceCache;
    }

    public DBSObjectCache<DB2Schema, DB2XMLSchema> getXMLSchemaCache() {
        return this.xmlSchemaCache;
    }

    public DB2AliasCache getAliasCache() {
        return this.aliasCache;
    }

    public DBSObjectCache<DB2Schema, DB2Package> getPackageCache() {
        return this.packageCache;
    }

    public DB2RoutineCache getProcedureCache() {
        return this.procedureCache;
    }

    public DB2IndexCache getIndexCache() {
        return this.indexCache;
    }

    public DB2TableUniqueKeyCache getConstraintCache() {
        return this.constraintCache;
    }

    public DB2TableForeignKeyCache getAssociationCache() {
        return this.associationCache;
    }

    public DB2TableReferenceCache getReferenceCache() {
        return this.referenceCache;
    }

    public DB2TriggerCache getTriggerCache() {
        return this.triggerCache;
    }

    public DB2TableCheckConstraintCache getCheckCache() {
        return this.checkCache;
    }

    public DBSObjectCache<DB2Schema, DB2Module> getModuleCache() {
        return this.moduleCache;
    }

    public DBSObjectCache<DB2Schema, DB2XMLSchema> getXmlSchemaCache() {
        return this.xmlSchemaCache;
    }

    public DBSObjectCache<DB2Schema, DB2Routine> getMethodCache() {
        return this.methodCache;
    }

    public boolean hasStatistics() {
        return this.schemaTotalSize != null;
    }

    public long getStatObjectSize() {
        return this.schemaTotalSize == null ? 0L : this.schemaTotalSize;
    }

    void setSchemaTotalSize(long schemaTotalSize) {
        this.schemaTotalSize = schemaTotalSize;
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }

    public boolean isStatisticsCollected() {
        return this.hasTableStatistics;
    }

    public void collectObjectStatistics(DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasTableStatistics && !forceRefresh) {
            return;
        }
        try {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load schema statistics");){
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT\n    TABNAME,\n    SUM(DATA_OBJECT_P_SIZE + INDEX_OBJECT_P_SIZE + LONG_OBJECT_P_SIZE + LOB_OBJECT_P_SIZE + XML_OBJECT_P_SIZE) AS TOTAL_SIZE_IN_KB\nFROM SYSIBMADM.ADMINTABINFO\nWHERE TABSCHEMA=?\nGROUP BY TABNAME");){
                        dbStat.setString(1, this.getName());
                        Throwable throwable3 = null;
                        Object var11_17 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            while (dbResult.next()) {
                                String tableName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (int)1);
                                long bytes = dbResult.getLong(2) * 1024L;
                                DB2Table table = this.getTable(monitor, tableName);
                                if (table == null) continue;
                                table.setTableTotalSize(bytes);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException("Error reading table statistics", (Throwable)e);
            }
        }
        finally {
            this.hasTableStatistics = true;
        }
    }
}

