/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.view;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.tasks.ui.view.DatabaseTasksTree;
import org.jkiss.dbeaver.tasks.ui.view.DatabaseTasksView;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;

public class TaskHandlerGroupBy
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        GroupBy groupBy = (GroupBy)CommonUtils.valueOf(GroupBy.class, (String)event.getParameter("group"), (Enum)GroupBy.project);
        DatabaseTasksView view = (DatabaseTasksView)HandlerUtil.getActivePart((ExecutionEvent)event);
        DatabaseTasksTree tasksTree = view.getTasksTree();
        switch (groupBy) {
            case project: {
                tasksTree.setGroupByProject(!tasksTree.isGroupByProject());
                break;
            }
            case category: {
                tasksTree.setGroupByCategory(!tasksTree.isGroupByCategory());
                break;
            }
            case type: {
                tasksTree.setGroupByType(!tasksTree.isGroupByType());
            }
        }
        tasksTree.regroupTasks();
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        DatabaseTasksView taskView = (DatabaseTasksView)UIUtils.findView((IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow(), (String)"org.jkiss.dbeaver.tasks");
        if (taskView != null) {
            DatabaseTasksTree tasksTree = taskView.getTasksTree();
            GroupBy groupBy = (GroupBy)CommonUtils.valueOf(GroupBy.class, (String)((String)parameters.get("group")), (Enum)GroupBy.project);
            switch (groupBy) {
                case project: {
                    element.setChecked(tasksTree.isGroupByProject());
                    break;
                }
                case category: {
                    element.setChecked(tasksTree.isGroupByCategory());
                    break;
                }
                case type: {
                    element.setChecked(tasksTree.isGroupByType());
                }
            }
            String commandName = Platform.getResourceBundle((Bundle)Platform.getBundle((String)"org.jkiss.dbeaver.tasks.ui")).getString("command.org.jkiss.dbeaver.task.group." + groupBy.name() + ".name");
            element.setText(commandName);
            element.setTooltip(commandName);
        }
    }

    public static enum GroupBy {
        project,
        category,
        type;

    }
}

