/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.ui.config;

import java.util.ArrayList;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableKeyColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableUniqueKey;
import org.jkiss.dbeaver.ext.exasol.ui.internal.ExasolMessages;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditConstraintPage;

public class ExasolPrimaryKeyConfigurator
implements DBEObjectConfigurator<ExasolTableUniqueKey> {
    protected static final Log log = Log.getLog(ExasolPrimaryKeyConfigurator.class);

    public ExasolTableUniqueKey configureObject(final DBRProgressMonitor monitor, Object container, final ExasolTableUniqueKey constraint) {
        return (ExasolTableUniqueKey)new UITask<ExasolTableUniqueKey>(){

            protected ExasolTableUniqueKey runTask() {
                EditConstraintPage editPage = new EditConstraintPage(ExasolMessages.edit_exasol_constraint_manager_dialog_title, (DBSEntityConstraint)constraint, new DBSEntityConstraintType[]{DBSEntityConstraintType.PRIMARY_KEY});
                if (!editPage.edit()) {
                    return null;
                }
                constraint.setConstraintType(editPage.getConstraintType());
                constraint.setEnabled(Boolean.valueOf(editPage.isEnableConstraint()));
                constraint.setName(editPage.getConstraintName());
                ArrayList<ExasolTableKeyColumn> constColumns = new ArrayList<ExasolTableKeyColumn>();
                int ordinalPosition = 0;
                for (DBSEntityAttribute tableColumn : editPage.getSelectedAttributes()) {
                    ExasolTableKeyColumn col;
                    try {
                        col = new ExasolTableKeyColumn((AbstractTableConstraint)constraint, constraint.getTable().getAttribute(monitor, tableColumn.getName()), Integer.valueOf(++ordinalPosition));
                    }
                    catch (DBException dBException) {
                        log.error((Object)("Could not find column " + tableColumn.getName() + " in table " + constraint.getTable().getFullyQualifiedName(DBPEvaluationContext.DDL)));
                        return null;
                    }
                    constColumns.add(col);
                }
                constraint.setColumns(constColumns);
                return constraint;
            }
        }.execute();
    }
}

