/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.net;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class SocksProxyConfiguratorUI
implements IObjectPropertyConfigurator<DBWHandlerConfiguration> {
    private Text hostText;
    private Spinner portText;
    private Text userNameText;
    private Text passwordText;
    private Button savePasswordCheckbox;

    public void createControl(Composite parent, Runnable propertyChangeListener) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(1808));
        this.createSocksGroup(composite);
    }

    protected void createSocksGroup(Composite parent) {
        Group composite = UIUtils.createControlGroup((Composite)parent, (String)"SOCKS", (int)4, (int)768, (int)-1);
        this.hostText = UIUtils.createLabelText((Composite)composite, (String)UIConnectionMessages.dialog_connection_network_socket_label_host, null);
        this.hostText.setLayoutData((Object)new GridData(768));
        this.portText = UIUtils.createLabelSpinner((Composite)composite, (String)UIConnectionMessages.dialog_connection_network_socket_label_port, (int)1080, (int)0, (int)65535);
        GridData gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Control)this.portText) * 7;
        this.portText.setLayoutData((Object)gd);
        this.userNameText = UIUtils.createLabelText((Composite)composite, (String)UIConnectionMessages.dialog_connection_network_socket_label_username, null);
        this.userNameText.setLayoutData((Object)new GridData(768));
        this.passwordText = UIUtils.createLabelText((Composite)composite, (String)UIConnectionMessages.dialog_connection_network_socket_label_password, (String)"", (int)0x400800);
        UIUtils.createEmptyLabel((Composite)composite, (int)1, (int)1);
        this.savePasswordCheckbox = UIUtils.createCheckbox((Composite)composite, (String)UIConnectionMessages.dialog_connection_auth_checkbox_save_password, (boolean)false);
    }

    public void loadSettings(DBWHandlerConfiguration configuration) {
        this.hostText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("socks-host")));
        String portString = configuration.getStringProperty("socks-port");
        if (!CommonUtils.isEmpty((String)portString)) {
            this.portText.setSelection(CommonUtils.toInt((Object)portString));
        } else {
            this.portText.setSelection(1080);
        }
        this.userNameText.setText(CommonUtils.notEmpty((String)configuration.getUserName()));
        this.passwordText.setText(CommonUtils.notEmpty((String)configuration.getPassword()));
        this.savePasswordCheckbox.setSelection(configuration.isSavePassword());
    }

    public void saveSettings(DBWHandlerConfiguration configuration) {
        configuration.setProperty("socks-host", (Object)this.hostText.getText().trim());
        configuration.setProperty("socks-port", (Object)this.portText.getSelection());
        configuration.setUserName(this.userNameText.getText().trim());
        configuration.setPassword(this.passwordText.getText());
        configuration.setSavePassword(this.savePasswordCheckbox.getSelection());
    }

    public void resetSettings(DBWHandlerConfiguration configuration) {
    }

    public boolean isComplete() {
        return false;
    }
}

