/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.exec.compile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileError;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileLog;

public class DBCCompileLogBase
implements DBCCompileLog {
    public static final int LOG_LEVEL_TRACE = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_WARN = 4;
    public static final int LOG_LEVEL_ERROR = 5;
    public static final int LOG_LEVEL_FATAL = 6;
    private Throwable error;
    private List<DBCCompileError> errorStack = new ArrayList<DBCCompileError>();

    protected void log(int type, Object message, Throwable t) {
        if (t != null) {
            this.error = t;
        } else if (message instanceof DBCCompileError) {
            this.errorStack.add((DBCCompileError)message);
        }
    }

    @Override
    public void trace(String trace) {
        this.log(1, trace, null);
    }

    @Override
    public void info(String trace) {
        this.log(3, trace, null);
    }

    @Override
    public void warn(DBCCompileError error) {
        this.log(4, error, null);
    }

    @Override
    public void error(DBCCompileError error) {
        this.log(5, error, null);
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public Collection<DBCCompileError> getErrorStack() {
        return this.errorStack;
    }

    @Override
    public void clearLog() {
        this.error = null;
        this.errorStack.clear();
    }
}

