/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.encode;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.jkiss.dbeaver.runtime.encode.EncryptionException;
import org.jkiss.dbeaver.runtime.encode.PasswordEncrypter;
import org.jkiss.utils.Base64;

public class SimpleStringEncrypter
implements PasswordEncrypter {
    private static final byte[] PASSWORD_ENCRYPTION_KEY = "sdf@!#$verf^wv%6Fwe%$$#FFGwfsdefwfe135s$^H)dg".getBytes(Charset.defaultCharset());
    private static final String CHARSET = "UTF8";

    @Override
    public String encrypt(String unencryptedString) throws EncryptionException {
        if (unencryptedString == null) {
            throw new IllegalArgumentException("Empty string");
        }
        try {
            byte[] stringBytes = unencryptedString.getBytes(CHARSET);
            byte[] plainBytes = Arrays.copyOf(stringBytes, stringBytes.length + 2);
            plainBytes[plainBytes.length - 2] = 0;
            plainBytes[plainBytes.length - 1] = -127;
            this.xorStringByKey(plainBytes);
            return Base64.encode((byte[])plainBytes);
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    private void xorStringByKey(byte[] plainBytes) throws UnsupportedEncodingException {
        int keyOffset = 0;
        int i = 0;
        while (i < plainBytes.length) {
            byte keyChar = PASSWORD_ENCRYPTION_KEY[keyOffset];
            if (++keyOffset >= PASSWORD_ENCRYPTION_KEY.length) {
                keyOffset = 0;
            }
            int n = i++;
            plainBytes[n] = (byte)(plainBytes[n] ^ keyChar);
        }
    }

    @Override
    public String decrypt(String encryptedString) throws EncryptionException {
        if (encryptedString == null || encryptedString.trim().length() <= 0) {
            throw new IllegalArgumentException("Empty encrypted string");
        }
        try {
            byte[] cleartext = Base64.decode((String)encryptedString);
            this.xorStringByKey(cleartext);
            if (cleartext[cleartext.length - 2] != 0 || cleartext[cleartext.length - 1] != -127) {
                throw new EncryptionException("Invalid encrypted string");
            }
            return new String(cleartext, 0, cleartext.length - 2, CHARSET);
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }
}

